/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.item;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.sarocesch.sarosroadblocksmod.SarosRoadBlocksModMod;
import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.config.ModConfigs;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModDataComponents;
import de.sarocesch.sarosroadblocksmod.util.CustomModelDataHelper;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import de.sarocesch.sarosroadblocksmod.world.inventory.GUIMenu;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class BrushItem
extends Item {
    public BrushItem(Item.Properties properties) {
        super(properties.stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    private boolean isPainted(ItemStack stack) {
        return (Boolean)stack.getOrDefault((DataComponentType)SarosRoadBlocksModModDataComponents.PAINTED.get(), (Object)false);
    }

    private void togglePainted(ItemStack stack) {
        boolean painted = !this.isPainted(stack);
        stack.set((DataComponentType)SarosRoadBlocksModModDataComponents.PAINTED.get(), (Object)painted);
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)CustomModelDataHelper.fromInt(painted ? 1 : 0));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (player != null && !player.mayUseItemAt(context.getClickedPos(), context.getClickedFace(), stack)) {
            if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue()) {
                SarosRoadBlocksModMod.LOGGER.warn("[Brush] no permission to use at {} {} {}", (Object)context.getClickedPos().getX(), (Object)context.getClickedPos().getY(), (Object)context.getClickedPos().getZ());
                player.displayClientMessage((Component)Component.translatable((String)"message.saros_road_blocks_mod.brush.no_permission"), true);
            }
            return InteractionResult.FAIL;
        }
        if (player != null && player.isShiftKeyDown()) {
            if (!world.isClientSide()) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, playerEntity) -> new GUIMenu(windowId, playerInventory, null), (Component)Component.translatable((String)"gui.saros_road_blocks_mod.gui")));
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof AsphaltBlock) {
            AsphaltBlock asphaltBlock = (AsphaltBlock)block;
            String modi = (String)stack.getOrDefault((DataComponentType)SarosRoadBlocksModModDataComponents.MODI.get(), (Object)"");
            BlockState newState = blockState;
            boolean textureChanged = false;
            if ("rotate".equals(modi)) {
                newState = blockState.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
            } else if ("remove".equals(modi)) {
                newState = (BlockState)blockState.setValue(AsphaltBlock.TEXTURE_VARIANT, (Comparable)((Object)AsphaltBlock.TextureVariant.DEFAULT));
                RoadTextureManager.setTextureForBlock(world, pos, "default");
                textureChanged = true;
                if (!world.isClientSide()) {
                    world.sendBlockUpdated(pos, blockState, newState, 3);
                }
            } else {
                try {
                    if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue()) {
                        SarosRoadBlocksModMod.LOGGER.info("[Brush] applying modi={} at {} {} {}", (Object)modi, (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
                    }
                    AsphaltBlock.TextureVariant variant = AsphaltBlock.TextureVariant.valueOf(modi.toUpperCase());
                    newState = (BlockState)blockState.setValue(AsphaltBlock.TEXTURE_VARIANT, (Comparable)((Object)variant));
                    Direction playerFacing = player.getDirection();
                    newState = (BlockState)newState.setValue(AsphaltBlock.FACING, (Comparable)playerFacing);
                    RoadTextureManager.setTextureForBlock(world, pos, modi.toLowerCase());
                    textureChanged = true;
                    if (!world.isClientSide()) {
                        world.sendBlockUpdated(pos, blockState, newState, 3);
                    }
                    if (newState != blockState || textureChanged) {
                        this.playPaintSound(world, pos);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue() && player != null) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.saros_road_blocks_mod.brush.invalid_mode", (Object[])new Object[]{modi}), true);
                        SarosRoadBlocksModMod.LOGGER.error("[Brush] invalid modi '{}'", (Object)modi);
                    }
                    return InteractionResult.PASS;
                }
            }
            if (newState != blockState || textureChanged) {
                BlockEntity blockEntity;
                world.setBlock(pos, newState, 3);
                if (!world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) != null) {
                    blockEntity.setChanged();
                    world.sendBlockUpdated(pos, newState, newState, 3);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (((Boolean)ModConfigs.DEBUG_BRUSH.get()).booleanValue() && player != null) {
            player.displayClientMessage((Component)Component.translatable((String)"message.saros_road_blocks_mod.brush.not_asphalt"), true);
            SarosRoadBlocksModMod.LOGGER.warn("[Brush] tried to use on non-asphalt at {} {} {}", (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
        return InteractionResult.PASS;
    }

    private void playPaintSound(Level world, BlockPos pos) {
        File configroads = new File(FMLPaths.GAMEDIR.get().toString() + "/config/", File.separator + "saro\u00b4s_road_blocks_mod.json");
        try {
            ResourceLocation soundLocation;
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configroads));
            StringBuilder jsonstringbuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                jsonstringbuilder.append(line);
            }
            bufferedReader.close();
            JsonObject main = (JsonObject)new Gson().fromJson(jsonstringbuilder.toString(), JsonObject.class);
            if (main.get("sounds").getAsBoolean() && ForgeRegistries.SOUND_EVENTS.containsKey(soundLocation = ResourceLocation.parse((String)"saros_road_blocks_mod:streichen"))) {
                if (!world.isClientSide()) {
                    world.playSound(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLocation), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

