/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class RoadBlockEntity
extends BlockEntity {
    private String textureId = "default";

    public RoadBlockEntity(BlockPos pos, BlockState state) {
        super(null, pos, state);
    }

    public String getTextureId() {
        return this.textureId;
    }

    public void setTextureId(String textureId) {
        this.textureId = textureId;
        this.setChanged();
        Level level = this.getLevel();
        if (level != null && !level.isClientSide()) {
            BlockState state = this.getBlockState();
            level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putString("TextureId", this.textureId);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.textureId = input.getStringOr("TextureId", "");
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void handleUpdateTag(ValueInput input, HolderLookup.Provider provider) {
        super.handleUpdateTag(input, provider);
        Level level = this.getLevel();
        if (level != null) {
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            level.getModelDataManager().requestRefresh((BlockEntity)this);
        }
    }
}

