/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.client.input;

import de.sarocesch.sarosroadblocksmod.SarosRoadBlocksModMod;
import de.sarocesch.sarosroadblocksmod.client.render.RoadPlannerClientRender;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModItems;
import de.sarocesch.sarosroadblocksmod.item.RoadPlannerItem;
import de.sarocesch.sarosroadblocksmod.network.RoadPlannerPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoadPlannerInputHandler {
    @SubscribeEvent
    public static boolean onScroll(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        if (!player.isShiftKeyDown()) {
            return false;
        }
        ItemStack held = player.getMainHandItem();
        if (held.isEmpty() || held.getItem() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return false;
        }
        int width = RoadPlannerItem.getWidth(held);
        double delta = event.getDeltaY();
        if (delta > 0.0) {
            ++width;
        } else if (delta < 0.0) {
            --width;
        }
        RoadPlannerItem.setWidth(held, width);
        SarosRoadBlocksModMod.PACKET_HANDLER.send((Object)new RoadPlannerPackets.C2SSetWidth(RoadPlannerItem.getWidth(held)), PacketDistributor.SERVER.noArg());
        player.displayClientMessage((Component)Component.literal((String)("Road Width: " + RoadPlannerItem.getWidth(held) + " blocks")), true);
        return true;
    }

    @SubscribeEvent
    public static boolean onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (player == null) {
            return false;
        }
        if (!player.level().isClientSide()) {
            return false;
        }
        ItemStack held = player.getMainHandItem();
        if (held.isEmpty() || held.getItem() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return false;
        }
        BlockPos nearest = RoadPlannerClientRender.findNearestWaypointByRay(10.0, 0.75);
        if (nearest == null) {
            return false;
        }
        SarosRoadBlocksModMod.PACKET_HANDLER.send((Object)new RoadPlannerPackets.C2SClick(RoadPlannerPackets.C2SClick.Action.REMOVE, nearest), PacketDistributor.SERVER.noArg());
        return true;
    }

    @SubscribeEvent
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (!player.level().isClientSide()) {
            return;
        }
        ItemStack held = player.getMainHandItem();
        if (held.isEmpty() || held.getItem() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return;
        }
        BlockPos nearest = RoadPlannerClientRender.findNearestWaypointByRay(10.0, 0.75);
        if (nearest == null) {
            return;
        }
        SarosRoadBlocksModMod.PACKET_HANDLER.send((Object)new RoadPlannerPackets.C2SClick(RoadPlannerPackets.C2SClick.Action.REMOVE, nearest), PacketDistributor.SERVER.noArg());
    }
}

