/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoadPlannerClientRender {
    private static final int GREEN = -16711936;
    private static final int BLUE = -16776961;
    private static final int RED = -65536;
    private static List<BlockPos> clientWaypoints = new ArrayList<BlockPos>();

    public static void setClientWaypoints(List<BlockPos> list) {
        clientWaypoints = list;
    }

    public static BlockPos findNearestWaypoint(BlockPos center, double radius) {
        if (clientWaypoints == null || clientWaypoints.isEmpty() || center == null) {
            return null;
        }
        double r2 = radius * radius;
        BlockPos best = null;
        double bestD2 = Double.MAX_VALUE;
        for (BlockPos bp : clientWaypoints) {
            double dz;
            double dy;
            double dx = bp.getX() - center.getX();
            double d2 = dx * dx + (dy = (double)(bp.getY() - center.getY())) * dy + (dz = (double)(bp.getZ() - center.getZ())) * dz;
            if (!(d2 <= r2) || !(d2 < bestD2)) continue;
            bestD2 = d2;
            best = bp;
        }
        return best;
    }

    public static BlockPos findNearestWaypointByRay(double maxDist, double radius) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || clientWaypoints == null || clientWaypoints.isEmpty()) {
            return null;
        }
        Vec3 o = mc.gameRenderer.getMainCamera().getPosition();
        Vec3 d = mc.player.getLookAngle();
        if (d == null) {
            return null;
        }
        double r2 = radius * radius;
        double bestT = Double.MAX_VALUE;
        BlockPos best = null;
        for (BlockPos bp : clientWaypoints) {
            Vec3 c;
            double dist2;
            Vec3 p = new Vec3((double)bp.getX() + 0.5, (double)bp.getY() + 1.0, (double)bp.getZ() + 0.5);
            Vec3 op = p.subtract(o);
            double t = op.dot(d);
            if (t < 0.0) {
                t = 0.0;
            } else if (t > maxDist) {
                t = maxDist;
            }
            if (!((dist2 = p.distanceToSqr(c = o.add(d.scale(t)))) <= r2) || !(t < bestT)) continue;
            bestT = t;
            best = bp;
        }
        return best;
    }

    private static void renderBox(VertexConsumer vc, PoseStack pose, BlockPos pos, int argb) {
        float x = (float)pos.getX() + 0.5f;
        float y = (float)pos.getY() + 1.0f;
        float z = (float)pos.getZ() + 0.5f;
        float size = 0.4f;
        RoadPlannerClientRender.line(vc, pose, x - size, y, z, x + size, y, z, argb);
        RoadPlannerClientRender.line(vc, pose, x, y - size, z, x, y + size, z, argb);
        RoadPlannerClientRender.line(vc, pose, x, y, z - size, x, y, z + size, argb);
        float boxSize = 0.3f;
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z - boxSize, x + boxSize, y - boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z - boxSize, x + boxSize, y - boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z + boxSize, x - boxSize, y - boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z + boxSize, x - boxSize, y - boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y + boxSize, z - boxSize, x + boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y + boxSize, z - boxSize, x + boxSize, y + boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y + boxSize, z + boxSize, x - boxSize, y + boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y + boxSize, z + boxSize, x - boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z - boxSize, x - boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z - boxSize, x + boxSize, y + boxSize, z - boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x + boxSize, y - boxSize, z + boxSize, x + boxSize, y + boxSize, z + boxSize, argb);
        RoadPlannerClientRender.line(vc, pose, x - boxSize, y - boxSize, z + boxSize, x - boxSize, y + boxSize, z + boxSize, argb);
    }

    private static void renderLine(VertexConsumer vc, PoseStack pose, BlockPos a, BlockPos b, int argb) {
        float x1 = (float)a.getX() + 0.5f;
        float y1 = (float)a.getY() + 1.0f;
        float z1 = (float)a.getZ() + 0.5f;
        float x2 = (float)b.getX() + 0.5f;
        float y2 = (float)b.getY() + 1.0f;
        float z2 = (float)b.getZ() + 0.5f;
        RoadPlannerClientRender.line(vc, pose, x1, y1, z1, x2, y2, z2, argb);
    }

    private static void line(VertexConsumer vc, PoseStack pose, float x1, float y1, float z1, float x2, float y2, float z2, int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        Matrix3f n = pose.last().normal();
        vc.addVertex(pose.last().pose(), x1, y1, z1).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(pose.last().pose(), x2, y2, z2).setColor(r, g, b, a).setNormal(0.0f, 1.0f, 0.0f);
    }
}

