/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.entity.RoadBlockEntity;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class RoadBlockRenderer
implements BlockEntityRenderer<RoadBlockEntity> {
    public RoadBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RoadBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffers, int packedLight, int packedOverlay, Vec3 cameraPos) {
        BlockState state = be.getBlockState();
        if (!(state.getBlock() instanceof AsphaltBlock)) {
            return;
        }
        if (state.getValue(AsphaltBlock.TEXTURE_VARIANT) != AsphaltBlock.TextureVariant.DEFAULT) {
            return;
        }
        String textureId = be.getTextureId();
        if (textureId == null || textureId.isEmpty() || "default".equals(textureId)) {
            return;
        }
        RoadTextureManager mgr = RoadTextureManager.getInstance();
        RoadTextureManager.TextureSet set = mgr.getTextureSet(textureId);
        if (set == null || set.top == null) {
            return;
        }
        String vname = ((AsphaltBlock.Variant)((Object)state.getValue(AsphaltBlock.VARIANT))).getSerializedName();
        int height16 = "default".equals(vname) ? 16 : Math.max(1, 16 - this.parseIntSafe(vname, 0));
        float y = (float)height16 / 16.0f + 0.001f;
        Direction facing = (Direction)state.getValue(AsphaltBlock.FACING);
        int rotY = switch (facing) {
            case Direction.EAST -> 90;
            case Direction.SOUTH -> 180;
            case Direction.WEST -> 270;
            default -> 0;
        };
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)rotY));
        poseStack.translate(-0.5, 0.0, -0.5);
        this.renderQuadTop(poseStack, buffers, set.top, y, packedLight, packedOverlay);
        ResourceLocation north = mgr.getFaceTexture(textureId, RoadTextureManager.Face.NORTH);
        ResourceLocation south = mgr.getFaceTexture(textureId, RoadTextureManager.Face.SOUTH);
        ResourceLocation east = mgr.getFaceTexture(textureId, RoadTextureManager.Face.EAST);
        ResourceLocation west = mgr.getFaceTexture(textureId, RoadTextureManager.Face.WEST);
        float y0 = 0.0f;
        float y1 = (float)height16 / 16.0f;
        float eps = 0.001f;
        if (north != null) {
            this.renderQuadNorth(poseStack, buffers, north, y0, y1, eps, packedLight, packedOverlay);
        }
        if (south != null) {
            this.renderQuadSouth(poseStack, buffers, south, y0, y1, eps, packedLight, packedOverlay);
        }
        if (east != null) {
            this.renderQuadEast(poseStack, buffers, east, y0, y1, eps, packedLight, packedOverlay);
        }
        if (west != null) {
            this.renderQuadWest(poseStack, buffers, west, y0, y1, eps, packedLight, packedOverlay);
        }
        poseStack.popPose();
    }

    private int parseIntSafe(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private void renderQuadTop(PoseStack ps, MultiBufferSource buffers, ResourceLocation tex, float y, int light, int overlay) {
        VertexConsumer vc = buffers.getBuffer(RenderType.entityCutout((ResourceLocation)tex));
        Matrix4f m = ps.last().pose();
        Matrix3f n = ps.last().normal();
        vc.addVertex(m, 0.0f, y, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 1.0f, y, 1.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
        vc.addVertex(m, 0.0f, y, 1.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 1.0f, 0.0f);
    }

    private void renderQuadNorth(PoseStack ps, MultiBufferSource buffers, ResourceLocation tex, float y0, float y1, float eps, int light, int overlay) {
        VertexConsumer vc = buffers.getBuffer(RenderType.entityCutout((ResourceLocation)tex));
        Matrix4f m = ps.last().pose();
        Matrix3f n = ps.last().normal();
        float z = 0.0f - eps;
        vc.addVertex(m, 0.0f, y0, z).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 1.0f, y0, z).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 1.0f, y1, z).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(m, 0.0f, y1, z).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void renderQuadSouth(PoseStack ps, MultiBufferSource buffers, ResourceLocation tex, float y0, float y1, float eps, int light, int overlay) {
        VertexConsumer vc = buffers.getBuffer(RenderType.entityCutout((ResourceLocation)tex));
        Matrix4f m = ps.last().pose();
        Matrix3f n = ps.last().normal();
        float z = 1.0f + eps;
        vc.addVertex(m, 1.0f, y0, z).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 0.0f, y0, z).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 0.0f, y1, z).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
        vc.addVertex(m, 1.0f, y1, z).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(0.0f, 0.0f, 1.0f);
    }

    private void renderQuadEast(PoseStack ps, MultiBufferSource buffers, ResourceLocation tex, float y0, float y1, float eps, int light, int overlay) {
        VertexConsumer vc = buffers.getBuffer(RenderType.entityCutout((ResourceLocation)tex));
        Matrix4f m = ps.last().pose();
        Matrix3f n = ps.last().normal();
        float x = 1.0f + eps;
        vc.addVertex(m, x, y0, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y0, 1.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 1.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 0.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(1.0f, 0.0f, 0.0f);
    }

    private void renderQuadWest(PoseStack ps, MultiBufferSource buffers, ResourceLocation tex, float y0, float y1, float eps, int light, int overlay) {
        VertexConsumer vc = buffers.getBuffer(RenderType.entityCutout((ResourceLocation)tex));
        Matrix4f m = ps.last().pose();
        Matrix3f n = ps.last().normal();
        float x = 0.0f - eps;
        vc.addVertex(m, x, y0, 1.0f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y0, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 0.0f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
        vc.addVertex(m, x, y1, 1.0f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(light).setOverlay(overlay).setNormal(-1.0f, 0.0f, 0.0f);
    }
}

