/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.network;

import de.sarocesch.sarosroadblocksmod.SarosRoadBlocksModMod;
import de.sarocesch.sarosroadblocksmod.client.render.RoadPlannerClientRender;
import de.sarocesch.sarosroadblocksmod.config.ModConfigs;
import de.sarocesch.sarosroadblocksmod.item.RoadPlannerItem;
import de.sarocesch.sarosroadblocksmod.road.RoadPlannerManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RoadPlannerPackets {
    public static void encode(C2SClick msg, FriendlyByteBuf buf) {
        buf.writeEnum((Enum)msg.action);
        buf.writeBlockPos(msg.pos == null ? BlockPos.ZERO : msg.pos);
    }

    public static C2SClick decode(FriendlyByteBuf buf) {
        C2SClick.Action act = (C2SClick.Action)buf.readEnum(C2SClick.Action.class);
        BlockPos pos = buf.readBlockPos();
        return new C2SClick(act, pos.equals((Object)BlockPos.ZERO) ? null : pos);
    }

    public static void handle(C2SClick msg, CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        switch (msg.action.ordinal()) {
            case 0: {
                RoadPlannerManager.addWaypoint(sender.level(), (Player)sender, msg.pos);
                break;
            }
            case 1: {
                RoadPlannerManager.clearWaypoints(sender.level(), (Player)sender);
                break;
            }
            case 2: {
                RoadPlannerManager.buildPlannedRoad(sender.level(), (Player)sender);
                break;
            }
            case 3: {
                RoadPlannerManager.removeNearestWaypoint(sender.level(), (Player)sender, msg.pos, 0.75);
            }
        }
        context.setPacketHandled(true);
    }

    public static void encodeSync(S2CSyncWaypoints msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.points.size());
        for (BlockPos bp : msg.points) {
            buf.writeBlockPos(bp);
        }
    }

    public static S2CSyncWaypoints decodeSync(FriendlyByteBuf buf) {
        int n = buf.readInt();
        ArrayList<BlockPos> pts = new ArrayList<BlockPos>(n);
        for (int i = 0; i < n; ++i) {
            pts.add(buf.readBlockPos());
        }
        return new S2CSyncWaypoints(pts);
    }

    public static void handleSync(S2CSyncWaypoints msg, CustomPayloadEvent.Context context) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RoadPlannerClientRender.setClientWaypoints(msg.points);
            if (((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
                SarosRoadBlocksModMod.LOGGER.info("[RoadPlannerNet] client synced {} waypoints", (Object)msg.points.size());
            }
        });
        context.setPacketHandled(true);
    }

    public static void encodeWidth(C2SSetWidth msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.width);
    }

    public static C2SSetWidth decodeWidth(FriendlyByteBuf buf) {
        return new C2SSetWidth(buf.readInt());
    }

    public static void handleWidth(C2SSetWidth msg, CustomPayloadEvent.Context context) {
        ServerPlayer sender = context.getSender();
        if (sender == null) {
            return;
        }
        ItemStack held = sender.getMainHandItem();
        if (!held.isEmpty() && held.getItem() instanceof RoadPlannerItem) {
            RoadPlannerItem.setWidth(held, msg.width);
        }
        context.setPacketHandled(true);
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        SarosRoadBlocksModMod.addNetworkMessage(C2SClick.class, RoadPlannerPackets::encode, RoadPlannerPackets::decode, RoadPlannerPackets::handle);
        SarosRoadBlocksModMod.addNetworkMessage(S2CSyncWaypoints.class, RoadPlannerPackets::encodeSync, RoadPlannerPackets::decodeSync, RoadPlannerPackets::handleSync);
        SarosRoadBlocksModMod.addNetworkMessage(C2SSetWidth.class, RoadPlannerPackets::encodeWidth, RoadPlannerPackets::decodeWidth, RoadPlannerPackets::handleWidth);
        if (((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
            SarosRoadBlocksModMod.LOGGER.info("[RoadPlannerNet] registered C2SClick, S2CSyncWaypoints, C2SSetWidth packets");
        }
    }

    public static class C2SClick {
        public final Action action;
        public final BlockPos pos;

        public C2SClick(Action action, BlockPos pos) {
            this.action = action;
            this.pos = pos;
        }

        public static enum Action {
            ADD,
            CLEAR,
            BUILD,
            REMOVE;

        }
    }

    public static class S2CSyncWaypoints {
        public final List<BlockPos> points;

        public S2CSyncWaypoints(List<BlockPos> pts) {
            this.points = pts;
        }
    }

    public static class C2SSetWidth {
        public final int width;

        public C2SSetWidth(int width) {
            this.width = width;
        }
    }
}

