/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.block;

import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.SidewalkBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FakeSnowSlopeBlock
extends SnowLayerBlock {
    public static final IntegerProperty SURFACE_OFFSET = IntegerProperty.m_61631_((String)"surface_offset", (int)0, (int)15);

    public FakeSnowSlopeBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60978_(0.1f).m_60999_().m_60918_(SoundType.f_56747_).m_60955_().m_60924_((state, world, pos) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(1))).m_61124_((Property)SURFACE_OFFSET, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_56581_, SURFACE_OFFSET});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState existingState = context.m_43725_().m_8055_(context.m_8083_());
        if (existingState.m_60713_((Block)this)) {
            int layers = (Integer)existingState.m_61143_((Property)f_56581_);
            int offset = (Integer)existingState.m_61143_((Property)SURFACE_OFFSET);
            return (BlockState)((BlockState)existingState.m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(Math.min(8, layers + 1)))).m_61124_((Property)SURFACE_OFFSET, (Comparable)Integer.valueOf(offset));
        }
        int offset = this.computeOffsetPx((LevelAccessor)context.m_43725_(), context.m_8083_().m_7495_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(1))).m_61124_((Property)SURFACE_OFFSET, (Comparable)Integer.valueOf(offset));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int layers = (Integer)state.m_61143_((Property)f_56581_);
        int offset = (Integer)state.m_61143_((Property)SURFACE_OFFSET);
        int snowHeight = layers * 2;
        VoxelShape base = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)snowHeight, (double)16.0);
        return base.m_83216_(0.0, -((double)offset / 16.0), 0.0);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, world, pos, context);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            int newOffset = this.computeOffsetPx(world, currentPos.m_7495_());
            if ((Integer)state.m_61143_((Property)SURFACE_OFFSET) != newOffset) {
                return (BlockState)state.m_61124_((Property)SURFACE_OFFSET, (Comparable)Integer.valueOf(newOffset));
            }
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    private int computeOffsetPx(LevelAccessor level, BlockPos belowPos) {
        BlockState below = level.m_8055_(belowPos);
        int h = 16;
        if (below.m_60734_() instanceof AsphaltBlock) {
            v = (AsphaltBlock.Variant)((Object)below.m_61143_(AsphaltBlock.VARIANT));
            h = this.heightFromVariant((AsphaltBlock.Variant)v);
        } else if (below.m_60734_() instanceof SidewalkBlock) {
            v = (SidewalkBlock.Variant)((Object)below.m_61143_(SidewalkBlock.VARIANT));
            h = this.heightFromVariant((SidewalkBlock.Variant)v);
        } else if (below.m_60734_() instanceof SlabBlock) {
            SlabType slabType = (SlabType)below.m_61143_((Property)SlabBlock.f_56353_);
            h = slabType == SlabType.BOTTOM ? 8 : (slabType == SlabType.TOP ? 16 : 16);
        }
        int off = 16 - h;
        if (off < 0) {
            off = 0;
        }
        if (off > 15) {
            off = 15;
        }
        return off;
    }

    private int heightFromVariant(AsphaltBlock.Variant v) {
        return switch (v) {
            case AsphaltBlock.Variant.ONE -> 15;
            case AsphaltBlock.Variant.TWO -> 14;
            case AsphaltBlock.Variant.THREE -> 13;
            case AsphaltBlock.Variant.FOUR -> 12;
            case AsphaltBlock.Variant.FIVE -> 11;
            case AsphaltBlock.Variant.SIX -> 10;
            case AsphaltBlock.Variant.SEVEN -> 9;
            case AsphaltBlock.Variant.EIGHT -> 8;
            case AsphaltBlock.Variant.NINE -> 7;
            case AsphaltBlock.Variant.TEN -> 6;
            case AsphaltBlock.Variant.ELEVEN -> 5;
            case AsphaltBlock.Variant.TWELVE -> 4;
            case AsphaltBlock.Variant.THIRTEEN -> 3;
            case AsphaltBlock.Variant.FOURTEEN -> 2;
            case AsphaltBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }

    private int heightFromVariant(SidewalkBlock.Variant v) {
        return switch (v) {
            case SidewalkBlock.Variant.ONE -> 15;
            case SidewalkBlock.Variant.TWO -> 14;
            case SidewalkBlock.Variant.THREE -> 13;
            case SidewalkBlock.Variant.FOUR -> 12;
            case SidewalkBlock.Variant.FIVE -> 11;
            case SidewalkBlock.Variant.SIX -> 10;
            case SidewalkBlock.Variant.SEVEN -> 9;
            case SidewalkBlock.Variant.EIGHT -> 8;
            case SidewalkBlock.Variant.NINE -> 7;
            case SidewalkBlock.Variant.TEN -> 6;
            case SidewalkBlock.Variant.ELEVEN -> 5;
            case SidewalkBlock.Variant.TWELVE -> 4;
            case SidewalkBlock.Variant.THIRTEEN -> 3;
            case SidewalkBlock.Variant.FOURTEEN -> 2;
            case SidewalkBlock.Variant.FIFTEEN -> 1;
            default -> 16;
        };
    }
}

