/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.road;

import de.sarocesch.sarosroadblocksmod.SarosRoadBlocksModMod;
import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.config.ModConfigs;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModBlocks;
import de.sarocesch.sarosroadblocksmod.item.RoadPlannerItem;
import de.sarocesch.sarosroadblocksmod.network.RoadPlannerPackets;
import de.sarocesch.sarosroadblocksmod.road.CurveUtil;
import de.sarocesch.sarosroadblocksmod.road.VecUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class RoadPlannerManager {
    private static final boolean DEBUG_PLANNER_COVERAGE = true;
    private static final Map<UUID, List<BlockPos>> WAYPOINTS = new HashMap<UUID, List<BlockPos>>();
    private static final Deque<List<BlockPos>> UNDO_STACK = new ArrayDeque<List<BlockPos>>();
    private static final Deque<Map<BlockPos, BlockState>> UNDO_BLOCKS = new ArrayDeque<Map<BlockPos, BlockState>>();

    public static void addWaypoint(Level level, Player player, BlockPos pos) {
        UUID id = player.m_20148_();
        WAYPOINTS.computeIfAbsent(id, k -> new ArrayList()).add(pos.m_7949_());
        if (((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
            SarosRoadBlocksModMod.LOGGER.info("[RoadPlanner] add waypoint {} by {} -> {}", (Object)pos, (Object)player.m_36316_().getName(), (Object)WAYPOINTS.get(id).size());
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_5661_((Component)Component.m_237113_((String)("Waypoint added: " + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_())), true);
            RoadPlannerManager.syncTo(sp);
        }
    }

    public static void clearWaypoints(Level level, Player player) {
        List<BlockPos> list = WAYPOINTS.remove(player.m_20148_());
        if (list != null && ((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
            SarosRoadBlocksModMod.LOGGER.info("[RoadPlanner] cleared {} waypoints for {}", (Object)list.size(), (Object)player.m_36316_().getName());
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_5661_((Component)Component.m_237113_((String)"Cleared waypoints"), true);
            RoadPlannerManager.syncTo(sp);
        }
    }

    public static boolean removeNearestWaypoint(Level level, Player player, BlockPos clicked, double radius) {
        List<BlockPos> list = WAYPOINTS.get(player.m_20148_());
        if (list == null || list.isEmpty()) {
            return false;
        }
        double r2 = radius * radius;
        int idx = -1;
        double best = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            double dz;
            double dy;
            BlockPos wp = list.get(i);
            double dx = wp.m_123341_() - clicked.m_123341_();
            double d2 = dx * dx + (dy = (double)(wp.m_123342_() - clicked.m_123342_())) * dy + (dz = (double)(wp.m_123343_() - clicked.m_123343_())) * dz;
            if (!(d2 <= r2) || !(d2 < best)) continue;
            idx = i;
            best = d2;
        }
        if (idx >= 0) {
            BlockPos removed = list.remove(idx);
            if (((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
                SarosRoadBlocksModMod.LOGGER.info("[RoadPlanner] removed waypoint {} at index {} by {}", (Object)removed, (Object)idx, (Object)player.m_36316_().getName());
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_5661_((Component)Component.m_237113_((String)("Removed waypoint #" + (idx + 1) + ": " + removed.m_123341_() + "," + removed.m_123342_() + "," + removed.m_123343_())), true);
                RoadPlannerManager.syncTo(sp);
            }
            return true;
        }
        return false;
    }

    public static boolean isExistingWaypoint(Level level, BlockPos pos) {
        for (List<BlockPos> list : WAYPOINTS.values()) {
            for (BlockPos wp : list) {
                if (!wp.equals((Object)pos)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExistingWaypoint(Level level, Player player, BlockPos pos) {
        List<BlockPos> list = WAYPOINTS.get(player.m_20148_());
        if (list == null) {
            return false;
        }
        for (BlockPos wp : list) {
            if (!wp.equals((Object)pos)) continue;
            return true;
        }
        return false;
    }

    public static boolean buildPlannedRoad(Level level, Player player) {
        List<BlockPos> pts = WAYPOINTS.get(player.m_20148_());
        int width = 5;
        if (player != null && player.m_21205_() != null && player.m_21205_().m_41720_() instanceof RoadPlannerItem) {
            width = RoadPlannerItem.getWidth(player.m_21205_());
        }
        if (pts == null || pts.size() < 2) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        UNDO_STACK.push(new ArrayList<BlockPos>(pts));
        List<Vec3> curve = CurveUtil.sampleCatmullRomVec(pts);
        HashMap<BlockPos, BlockState> replaced = new HashMap<BlockPos, BlockState>();
        int placed = RoadPlannerManager.placeAsphaltAlongCurveWide(serverLevel, curve, replaced, width);
        UNDO_BLOCKS.push(replaced);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_5661_((Component)Component.m_237113_((String)("Built road blocks: " + placed)), true);
            RoadPlannerManager.clearWaypoints(level, player);
        }
        return true;
    }

    public static int undoLast(ServerLevel level, ServerPlayer player) {
        if (UNDO_STACK.isEmpty()) {
            return 0;
        }
        List<BlockPos> last = UNDO_STACK.pop();
        Map replaced = UNDO_BLOCKS.isEmpty() ? Collections.emptyMap() : UNDO_BLOCKS.pop();
        int restored = 0;
        List<BlockPos> curve = CurveUtil.sampleCatmullRomBlocks(last);
        if (replaced != null && !replaced.isEmpty()) {
            for (Map.Entry entry : replaced.entrySet()) {
                if (!level.m_8055_((BlockPos)entry.getKey()).m_60713_((Block)SarosRoadBlocksModModBlocks.ASPHALT.get())) continue;
                level.m_7731_((BlockPos)entry.getKey(), (BlockState)entry.getValue(), 3);
                ++restored;
            }
        }
        for (BlockPos blockPos : curve) {
            BlockState prev = (BlockState)replaced.get(blockPos);
            if (prev != null) {
                level.m_7731_(blockPos, prev, 3);
                ++restored;
                continue;
            }
            if (!level.m_8055_(blockPos).m_60713_((Block)SarosRoadBlocksModModBlocks.ASPHALT.get())) continue;
            level.m_7471_(blockPos, false);
            ++restored;
        }
        player.m_5661_((Component)Component.m_237113_((String)("Undo restored blocks: " + restored)), true);
        return restored;
    }

    private static int placeAsphaltAlongCurve(ServerLevel level, List<BlockPos> positions, Map<BlockPos, BlockState> replacedOut) {
        int placed = 0;
        BlockPos prev = null;
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos p = positions.get(i);
            if (prev != null && p.equals(prev)) continue;
            BlockState prevState = level.m_8055_(p);
            replacedOut.putIfAbsent(p, prevState);
            BlockPos next = i + 1 < positions.size() ? positions.get(i + 1) : p;
            int dy = next.m_123342_() - p.m_123342_();
            AsphaltBlock.Variant variant = RoadPlannerManager.slopeVariantFromDy(dy);
            BlockState asphalt = (BlockState)((Block)SarosRoadBlocksModModBlocks.ASPHALT.get()).m_49966_().m_61124_(AsphaltBlock.VARIANT, (Comparable)((Object)variant));
            level.m_7731_(p, asphalt, 3);
            ++placed;
            prev = p;
        }
        return placed;
    }

    private static AsphaltBlock.Variant slopeVariantFromDy(int dy) {
        return switch (dy) {
            case 1 -> AsphaltBlock.Variant.TWO;
            case -1 -> AsphaltBlock.Variant.THREE;
            default -> AsphaltBlock.Variant.DEFAULT;
        };
    }

    private static int removeAsphaltLine(ServerLevel level, BlockPos a, BlockPos b) {
        int removed = 0;
        int x1 = a.m_123341_();
        int y1 = a.m_123342_();
        int z1 = a.m_123343_();
        int x2 = b.m_123341_();
        int y2 = b.m_123342_();
        int z2 = b.m_123343_();
        int dx = Math.abs(x2 - x1);
        int dz = Math.abs(z2 - z1);
        int sx = x1 < x2 ? 1 : -1;
        int sz = z1 < z2 ? 1 : -1;
        int err = dx - dz;
        int x = x1;
        int z = z1;
        while (true) {
            BlockPos p;
            if (level.m_8055_(p = new BlockPos(x, y1, z)).m_60713_((Block)SarosRoadBlocksModModBlocks.ASPHALT.get())) {
                level.m_7471_(p, false);
                ++removed;
            }
            if (x == x2 && z == z2) break;
            int e2 = 2 * err;
            if (e2 > -dz) {
                err -= dz;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            z += sz;
        }
        return removed;
    }

    private static void syncTo(ServerPlayer player) {
        List<BlockPos> pts = WAYPOINTS.getOrDefault(player.m_20148_(), List.of());
        SarosRoadBlocksModMod.PACKET_HANDLER.sendTo((Object)new RoadPlannerPackets.S2CSyncWaypoints(pts), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    private static int placeAsphaltAlongCurveWide(ServerLevel level, List<Vec3> curve, Map<BlockPos, BlockState> replacedOut, int width) {
        int i;
        int placed = 0;
        HashSet<BlockPos> touched = new HashSet<BlockPos>();
        Vec3 lastDir = new Vec3(1.0, 0.0, 0.0);
        int smoothWindow = 5;
        double[] smoothedY = new double[curve.size()];
        for (i = 0; i < curve.size(); ++i) {
            double sum = 0.0;
            int count = 0;
            for (int j = Math.max(0, i - smoothWindow); j <= Math.min(curve.size() - 1, i + smoothWindow); ++j) {
                sum += curve.get((int)j).f_82480_;
                ++count;
            }
            smoothedY[i] = sum / (double)count;
        }
        for (i = 0; i < curve.size(); ++i) {
            int heightPx;
            Vec3 c = curve.get(i);
            Vec3 next = i + 1 < curve.size() ? curve.get(i + 1) : c;
            Vec3 dir = next.m_82546_(c);
            double dlen = Math.hypot(dir.f_82479_, dir.f_82481_);
            if (dlen < 1.0E-6) {
                if (i > 0 && i + 1 < curve.size()) {
                    dir = curve.get(i + 1).m_82546_(curve.get(i - 1));
                    dlen = Math.hypot(dir.f_82479_, dir.f_82481_);
                }
                if (dlen < 1.0E-6) {
                    dir = lastDir;
                }
            }
            lastDir = dir;
            Vec3 normal = VecUtil.normal2D(dir);
            double ySmooth = smoothedY[i];
            double yContCenter = ySmooth - 1.0;
            int yFloorCenter = (int)Math.floor(yContCenter);
            double fracCenter = yContCenter - (double)yFloorCenter;
            if (fracCenter < 0.0) {
                fracCenter = 0.0;
            }
            if (fracCenter >= 1.0) {
                fracCenter = 0.9999;
            }
            double slope = 0.0;
            int lookAhead = Math.min(10, curve.size() - 1 - i);
            int lookBehind = Math.min(10, i);
            if (lookAhead > 0 && lookBehind > 0) {
                double yAhead = smoothedY[i + lookAhead];
                double yBehind = smoothedY[i - lookBehind];
                double dyTotal = yAhead - yBehind;
                double distTotal = Math.hypot(curve.get((int)(i + lookAhead)).f_82479_ - curve.get((int)(i - lookBehind)).f_82479_, curve.get((int)(i + lookAhead)).f_82481_ - curve.get((int)(i - lookBehind)).f_82481_);
                if (distTotal > 0.1) {
                    slope = dyTotal / distTotal;
                }
            }
            if (Math.abs(slope) < 0.05) {
                heightPx = 16;
            } else {
                heightPx = Math.max(1, Math.min(16, (int)Math.round(fracCenter * 16.0)));
                if (heightPx == 0) {
                    heightPx = 1;
                }
            }
            AsphaltBlock.Variant variant = RoadPlannerManager.variantForHeightPixels(heightPx);
            Direction facing = Direction.m_122364_((double)((float)Math.toDegrees(Math.atan2(dir.f_82479_, dir.f_82481_)))).m_122424_();
            double span = (double)(width - 1) / 2.0;
            Vec3 left = c.m_82549_(normal.m_82490_(-span));
            Vec3 right = c.m_82549_(normal.m_82490_(span));
            int x0 = (int)Math.round(left.f_82479_);
            int z0 = (int)Math.round(left.f_82481_);
            int x1 = (int)Math.round(right.f_82479_);
            int z1 = (int)Math.round(right.f_82481_);
            int placeY = yFloorCenter;
            List<BlockPos> lateralLine = RoadPlannerManager.sampleLineXZRound(x0, z0, x1, z1, placeY);
            LinkedHashSet<BlockPos> band = new LinkedHashSet<BlockPos>(lateralLine);
            if (band.size() < width) {
                double spanD = span;
                for (double off = -spanD; off <= spanD + 1.0E-6; off += 0.5) {
                    Vec3 offPos = c.m_82549_(normal.m_82490_(off));
                    int bx = (int)Math.round(offPos.f_82479_);
                    int bz = (int)Math.round(offPos.f_82481_);
                    band.add(new BlockPos(bx, placeY, bz));
                }
            }
            SarosRoadBlocksModMod.LOGGER.info("RoadPlanner[{}]: y={} frac={} slope={} heightPx={} variant={} facing={} band={}", (Object)i, (Object)String.format("%.2f", ySmooth), (Object)String.format("%.3f", fracCenter), (Object)String.format("%.4f", slope), (Object)heightPx, (Object)variant, (Object)facing, (Object)band.size());
            for (BlockPos bp : band) {
                if (!touched.add(bp)) continue;
                BlockState prevState = level.m_8055_(bp);
                replacedOut.putIfAbsent(bp, prevState);
                BlockState asphalt = (BlockState)((BlockState)((Block)SarosRoadBlocksModModBlocks.ASPHALT.get()).m_49966_().m_61124_(AsphaltBlock.VARIANT, (Comparable)((Object)variant))).m_61124_((Property)AsphaltBlock.FACING, (Comparable)facing);
                level.m_7731_(bp, asphalt, 3);
                ++placed;
            }
        }
        return placed;
    }

    private static AsphaltBlock.Variant variantForHeightPixels(int px) {
        switch (px) {
            case 16: {
                return AsphaltBlock.Variant.DEFAULT;
            }
            case 15: {
                return AsphaltBlock.Variant.ONE;
            }
            case 14: {
                return AsphaltBlock.Variant.TWO;
            }
            case 13: {
                return AsphaltBlock.Variant.THREE;
            }
            case 12: {
                return AsphaltBlock.Variant.FOUR;
            }
            case 11: {
                return AsphaltBlock.Variant.FIVE;
            }
            case 10: {
                return AsphaltBlock.Variant.SIX;
            }
            case 9: {
                return AsphaltBlock.Variant.SEVEN;
            }
            case 8: {
                return AsphaltBlock.Variant.EIGHT;
            }
            case 7: {
                return AsphaltBlock.Variant.NINE;
            }
            case 6: {
                return AsphaltBlock.Variant.TEN;
            }
            case 5: {
                return AsphaltBlock.Variant.ELEVEN;
            }
            case 4: {
                return AsphaltBlock.Variant.TWELVE;
            }
            case 3: {
                return AsphaltBlock.Variant.THIRTEEN;
            }
            case 2: {
                return AsphaltBlock.Variant.FOURTEEN;
            }
            case 1: {
                return AsphaltBlock.Variant.FIFTEEN;
            }
        }
        return AsphaltBlock.Variant.DEFAULT;
    }

    private static List<BlockPos> sampleLineXZRound(int x0, int z0, int x1, int z1, int y) {
        LinkedHashSet<BlockPos> pts = new LinkedHashSet<BlockPos>();
        int dx = x1 - x0;
        int dz = z1 - z0;
        int steps = Math.max(Math.abs(dx), Math.abs(dz));
        if (steps == 0) {
            pts.add(new BlockPos(x0, y, z0));
        } else {
            for (int i = 0; i <= steps; ++i) {
                double t = (double)i / (double)steps;
                int x = (int)Math.round((double)x0 + t * (double)dx);
                int z = (int)Math.round((double)z0 + t * (double)dz);
                pts.add(new BlockPos(x, y, z));
            }
        }
        return new ArrayList<BlockPos>(pts);
    }
}

