/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.BloodNightManager;
import com.example.examplemod.WaveBossBar;
import com.example.examplemod.WaveNotificationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;

public class ActiveWave {
    private final int day;
    private final BlockPos centerPos;
    private final List<UUID> waveMobs = new ArrayList<UUID>();
    private final boolean isBigWave;
    private WaveBossBar bossBar;
    private int initialMobCount = 0;
    private long waveStartTime;
    private boolean isCompleted = false;
    private ServerLevel level;
    private long lastProgressCheck = 0L;

    public ActiveWave(int day, BlockPos centerPos, boolean isBigWave, ServerLevel level) {
        this.day = day;
        this.centerPos = centerPos;
        this.isBigWave = isBigWave;
        this.level = level;
        this.waveStartTime = System.currentTimeMillis();
        String waveName = isBigWave ? "\u00a74\u00a7l\u26a1 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + " \u26a1" : "\u00a7c\u00a7l\u0412\u041e\u041b\u041d\u0410 " + day;
        this.bossBar = new WaveBossBar(waveName, day, level);
        this.addAllPlayersToBar();
    }

    public void addMob(Mob mob) {
        if (mob != null) {
            this.waveMobs.add(mob.m_20148_());
            ++this.initialMobCount;
            if (this.initialMobCount > 1) {
                this.updateBossBar();
            }
        }
    }

    public void finalizeWave() {
        this.updateBossBar();
        for (ServerPlayer player : this.level.m_6907_()) {
            player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a76[\u0412\u041e\u041b\u041d\u0410 %d] \u0417\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e: \u00a7e%d \u00a76\u043c\u043e\u0431\u043e\u0432!", this.day, this.initialMobCount)));
        }
    }

    public void removeMob(UUID mobUUID) {
        if (this.waveMobs.remove(mobUUID)) {
            this.updateBossBar();
            if (this.waveMobs.isEmpty() && !this.isCompleted) {
                this.completeWave();
            }
        }
    }

    private void updateBossBar() {
        if (this.bossBar == null || this.initialMobCount == 0) {
            return;
        }
        int remaining = this.waveMobs.size();
        float progress = (float)remaining / (float)this.initialMobCount;
        String waveName = BloodNightManager.isBloodNightDay(this.day) ? BloodNightManager.getBloodNightWaveName(this.day, remaining, this.initialMobCount) : (this.isBigWave ? String.format("\u00a74\u00a7l\u26a1 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 %d \u26a1 \u00a7f| \u00a7c%d\u00a77/\u00a7c%d \u00a7f\u043c\u043e\u0431\u043e\u0432", this.day, remaining, this.initialMobCount) : String.format("\u00a7c\u00a7l\u0412\u041e\u041b\u041d\u0410 %d \u00a7f| \u00a7e%d\u00a77/\u00a7e%d \u00a7f\u043c\u043e\u0431\u043e\u0432", this.day, remaining, this.initialMobCount));
        this.bossBar.setName(waveName);
        this.bossBar.setProgress(progress);
        if (BloodNightManager.isBloodNightDay(this.day)) {
            this.bossBar.setColor(BloodNightManager.getBloodNightBossBarColor());
        } else if (this.isBigWave) {
            this.bossBar.setColor("purple");
        } else if (progress > 0.75f) {
            this.bossBar.setColor("red");
        } else if (progress > 0.5f) {
            this.bossBar.setColor("red");
        } else if (progress > 0.25f) {
            this.bossBar.setColor("yellow");
        } else {
            this.bossBar.setColor("green");
        }
    }

    private void completeWave() {
        this.isCompleted = true;
        long duration = System.currentTimeMillis() - this.waveStartTime;
        int seconds = (int)(duration / 1000L);
        if (this.bossBar != null) {
            String completeName = String.format("\u00a7a\u00a7l\u2713 \u0412\u041e\u041b\u041d\u0410 %d \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d\u0410 \u00a7f(%d\u0441)", this.day, seconds);
            this.bossBar.setName(completeName);
            this.bossBar.setProgress(0.0f);
            this.bossBar.setColor("green");
            new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                    if (this.bossBar != null) {
                        this.bossBar.cleanup();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
        if (BloodNightManager.isBloodNightDay(this.day)) {
            BloodNightManager.endBloodNight(this.level, this.day);
        } else {
            WaveNotificationManager.notifyWaveCompleted(this.level, this.day, seconds, this.isBigWave);
        }
    }

    public void tick(ServerLevel level) {
        int previousCount = this.waveMobs.size();
        this.waveMobs.removeIf(uuid -> {
            Entity entity = level.m_8791_(uuid);
            return entity == null || !entity.m_6084_() || !(entity instanceof Monster);
        });
        if (this.waveMobs.size() != previousCount) {
            this.updateBossBar();
        }
        if (this.waveMobs.isEmpty() && !this.isCompleted) {
            this.completeWave();
        }
    }

    public int getRemainingMobCount() {
        return this.waveMobs.size();
    }

    public int getDay() {
        return this.day;
    }

    public boolean isBigWave() {
        return this.isBigWave;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public BlockPos getCenterPos() {
        return this.centerPos;
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public boolean hasMob(UUID mobUUID) {
        return this.waveMobs.contains(mobUUID);
    }

    public void cleanup() {
        this.waveMobs.clear();
        this.isCompleted = true;
        if (this.bossBar != null) {
            this.bossBar.cleanup();
            this.bossBar = null;
        }
    }

    public int getInitialMobCount() {
        return this.initialMobCount;
    }

    public long getWaveStartTime() {
        return this.waveStartTime;
    }

    public WaveBossBar getBossBar() {
        return this.bossBar;
    }

    private void addAllPlayersToBar() {
        if (this.bossBar != null && this.level != null) {
            for (ServerPlayer player : this.level.m_6907_()) {
                this.bossBar.addPlayer(player);
            }
        }
    }

    public void refreshPlayers() {
        this.addAllPlayersToBar();
    }
}

