/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ProtectionZone;
import com.example.examplemod.ScreenNotificationManager;
import com.example.examplemod.SurvivalManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class AutoDefenseBuilder {
    private static final int WALL_HEIGHT = 5;
    private static final BlockState WALL_BLOCK = Blocks.f_50069_.m_49966_();
    private static final BlockState FLOOR_BLOCK = Blocks.f_50652_.m_49966_();

    public static void buildTestDefense(ServerLevel level, BlockPos centerBlock) {
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return;
        }
        ProtectionZone zone = null;
        for (ProtectionZone protectionZone : manager.getProtectionZones()) {
            if (!protectionZone.getCenterBlock().equals((Object)centerBlock)) continue;
            zone = protectionZone;
            break;
        }
        if (zone == null) {
            return;
        }
        int radius = zone.getZoneRadius();
        ScreenNotificationManager.showBuildingNotification(level, "\u00a7e\u0421\u0442\u0440\u043e\u0438\u043c \u0431\u0430\u0437\u043e\u0432\u0443\u044e \u043e\u0431\u043e\u0440\u043e\u043d\u0443... \u0420\u0430\u0434\u0438\u0443\u0441: " + radius + " \u0431\u043b\u043e\u043a\u043e\u0432");
        AutoDefenseBuilder.buildDefenseWalls(level, centerBlock, radius);
        AutoDefenseBuilder.buildDefenseFloor(level, centerBlock, radius);
        AutoDefenseBuilder.buildDefenseGates(level, centerBlock, radius);
        ScreenNotificationManager.showNotification(level, "\u00a7a\u00a7l\u2705 \u041e\u0411\u041e\u0420\u041e\u041d\u0410 \u041f\u041e\u0421\u0422\u0420\u041e\u0415\u041d\u0410!", "\u00a7e\u041a\u0430\u043c\u0435\u043d\u043d\u044b\u0435 \u0441\u0442\u0435\u043d\u044b, \u0431\u0443\u043b\u044b\u0436\u043d\u0438\u043a\u043e\u0432\u044b\u0439 \u043f\u043e\u043b, 4 \u0432\u0445\u043e\u0434\u0430");
    }

    private static void buildDefenseWalls(ServerLevel level, BlockPos center, int radius) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (!AutoDefenseBuilder.isOnBoundary(x, z, radius)) continue;
                BlockPos basePos = center.m_7918_(x, 0, z);
                for (int y = 0; y < 5; ++y) {
                    BlockPos wallPos = basePos.m_7918_(0, y, 0);
                    BlockState currentState = level.m_8055_(wallPos);
                    if (!currentState.m_60795_() && currentState.m_60734_() != Blocks.f_50440_ && currentState.m_60734_() != Blocks.f_50493_ && currentState.m_60734_() != Blocks.f_50069_) continue;
                    level.m_7731_(wallPos, WALL_BLOCK, 3);
                }
            }
        }
    }

    private static void buildDefenseFloor(ServerLevel level, BlockPos center, int radius) {
        for (int x = -radius + 1; x < radius; ++x) {
            for (int z = -radius + 1; z < radius; ++z) {
                BlockPos floorPos = center.m_7918_(x, -1, z);
                BlockState currentState = level.m_8055_(floorPos);
                if (!currentState.m_60795_() && currentState.m_60734_() != Blocks.f_50440_ && currentState.m_60734_() != Blocks.f_50493_) continue;
                level.m_7731_(floorPos, FLOOR_BLOCK, 3);
            }
        }
    }

    private static void buildDefenseGates(ServerLevel level, BlockPos center, int radius) {
        AutoDefenseBuilder.createGate(level, center.m_7918_(0, 0, -radius), 2);
        AutoDefenseBuilder.createGate(level, center.m_7918_(0, 0, radius), 2);
        AutoDefenseBuilder.createGate(level, center.m_7918_(radius, 0, 0), 2);
        AutoDefenseBuilder.createGate(level, center.m_7918_(-radius, 0, 0), 2);
    }

    private static void createGate(ServerLevel level, BlockPos gateCenter, int gateWidth) {
        for (int i = -gateWidth / 2; i <= gateWidth / 2; ++i) {
            for (int y = 0; y < 4; ++y) {
                BlockPos gatePos = gateCenter.m_7918_(i, y, 0);
                level.m_7731_(gatePos, Blocks.f_50016_.m_49966_(), 3);
            }
        }
    }

    private static boolean isOnBoundary(int x, int z, int radius) {
        return Math.abs(x) == radius || Math.abs(z) == radius;
    }

    public static void buildAdvancedDefense(ServerLevel level, BlockPos centerBlock) {
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return;
        }
        ProtectionZone zone = null;
        for (ProtectionZone protectionZone : manager.getProtectionZones()) {
            if (!protectionZone.getCenterBlock().equals((Object)centerBlock)) continue;
            zone = protectionZone;
            break;
        }
        if (zone == null) {
            return;
        }
        int radius = zone.getZoneRadius();
        AutoDefenseBuilder.buildDoubleWalls(level, centerBlock, radius);
        AutoDefenseBuilder.buildWatchtowers(level, centerBlock, radius);
        AutoDefenseBuilder.buildTrapPits(level, centerBlock, radius);
        ScreenNotificationManager.showNotification(level, "\u00a7a\u00a7l\ud83c\udff0 \u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u041d\u0410\u042f \u041e\u0411\u041e\u0420\u041e\u041d\u0410!", "\u00a7e\u0414\u0432\u043e\u0439\u043d\u044b\u0435 \u0441\u0442\u0435\u043d\u044b, \u0431\u0430\u0448\u043d\u0438, \u043b\u043e\u0432\u0443\u0448\u043a\u0438");
    }

    private static void buildDoubleWalls(ServerLevel level, BlockPos center, int radius) {
        AutoDefenseBuilder.buildWallAtRadius(level, center, radius, 5);
        AutoDefenseBuilder.buildWallAtRadius(level, center, radius - 2, 4);
    }

    private static void buildWallAtRadius(ServerLevel level, BlockPos center, int radius, int height) {
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (!AutoDefenseBuilder.isOnBoundary(x, z, radius)) continue;
                BlockPos basePos = center.m_7918_(x, 0, z);
                for (int y = 0; y < height; ++y) {
                    BlockPos wallPos = basePos.m_7918_(0, y, 0);
                    BlockState currentState = level.m_8055_(wallPos);
                    if (!currentState.m_60795_() && currentState.m_60734_() != Blocks.f_50440_ && currentState.m_60734_() != Blocks.f_50493_) continue;
                    level.m_7731_(wallPos, WALL_BLOCK, 3);
                }
            }
        }
    }

    private static void buildWatchtowers(ServerLevel level, BlockPos center, int radius) {
        BlockPos[] corners;
        for (BlockPos corner : corners = new BlockPos[]{center.m_7918_(radius, 0, radius), center.m_7918_(radius, 0, -radius), center.m_7918_(-radius, 0, radius), center.m_7918_(-radius, 0, -radius)}) {
            for (int y = 0; y < 7; ++y) {
                level.m_7731_(corner.m_7918_(0, y, 0), WALL_BLOCK, 3);
            }
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    level.m_7731_(corner.m_7918_(x, 7, z), WALL_BLOCK, 3);
                }
            }
        }
    }

    private static void buildTrapPits(ServerLevel level, BlockPos center, int radius) {
        BlockPos[] gatePositions;
        for (BlockPos gatePos : gatePositions = new BlockPos[]{center.m_7918_(0, 0, -radius - 2), center.m_7918_(0, 0, radius + 2), center.m_7918_(radius + 2, 0, 0), center.m_7918_(-radius - 2, 0, 0)}) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    for (int y = -2; y < 0; ++y) {
                        BlockPos pitPos = gatePos.m_7918_(x, y, z);
                        level.m_7731_(pitPos, Blocks.f_50016_.m_49966_(), 3);
                    }
                }
            }
        }
    }
}

