/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.SurvivalConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class BlockHealthData {
    private static final Map<BlockPos, Integer> blockHealth = new HashMap<BlockPos, Integer>();
    private static final Map<BlockPos, Integer> maxHealth = new HashMap<BlockPos, Integer>();

    public static void initializeBlock(BlockPos pos) {
        SurvivalConfig config = SurvivalConfig.getInstance();
        blockHealth.put(pos, config.getMaxHealth());
        maxHealth.put(pos, config.getMaxHealth());
    }

    public static int getHealth(BlockPos pos) {
        return blockHealth.getOrDefault(pos, 100);
    }

    public static int getMaxHealth(BlockPos pos) {
        return maxHealth.getOrDefault(pos, 100);
    }

    public static int getHealthPercentage(BlockPos pos) {
        int current = BlockHealthData.getHealth(pos);
        int max = BlockHealthData.getMaxHealth(pos);
        return current * 100 / max;
    }

    public static boolean damageBlock(BlockPos pos, Level level) {
        SurvivalConfig config = SurvivalConfig.getInstance();
        int currentHealth = BlockHealthData.getHealth(pos);
        int newHealth = Math.max(0, currentHealth - config.getDamagePerAttack());
        blockHealth.put(pos, newHealth);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int percentage = BlockHealthData.getHealthPercentage(pos);
            String message = config.getMessage("block_damaged", Map.of("health", String.valueOf(percentage)));
            for (ServerPlayer player : serverLevel.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
        }
        return newHealth <= 0;
    }

    public static void healBlock(BlockPos pos, int amount) {
        int currentHealth = BlockHealthData.getHealth(pos);
        int max = BlockHealthData.getMaxHealth(pos);
        int newHealth = Math.min(max, currentHealth + amount);
        blockHealth.put(pos, newHealth);
    }

    public static void increaseMaxHealth(BlockPos pos, int amount) {
        int currentMax = BlockHealthData.getMaxHealth(pos);
        int newMax = currentMax + amount;
        maxHealth.put(pos, newMax);
        int currentHealth = BlockHealthData.getHealth(pos);
        int newHealth = Math.min(newMax, currentHealth + amount);
        blockHealth.put(pos, newHealth);
    }

    public static void regenerateBlock(BlockPos pos) {
        SurvivalConfig config = SurvivalConfig.getInstance();
        BlockHealthData.healBlock(pos, config.getRegenerationPerDay());
    }

    public static boolean isBlockDestroyed(BlockPos pos) {
        return BlockHealthData.getHealth(pos) <= 0;
    }

    public static void removeBlock(BlockPos pos) {
        blockHealth.remove(pos);
        maxHealth.remove(pos);
    }

    public static void save(CompoundTag tag) {
        CompoundTag healthTag = new CompoundTag();
        for (Map.Entry<BlockPos, Integer> entry : blockHealth.entrySet()) {
            healthTag.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.m_128365_("block_health", (Tag)healthTag);
        CompoundTag maxHealthTag = new CompoundTag();
        for (Map.Entry<BlockPos, Integer> entry : maxHealth.entrySet()) {
            maxHealthTag.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.m_128365_("max_health", (Tag)maxHealthTag);
    }

    public static void load(CompoundTag tag) {
        BlockPos pos;
        blockHealth.clear();
        maxHealth.clear();
        if (tag.m_128441_("block_health")) {
            CompoundTag healthTag = tag.m_128469_("block_health");
            for (String key : healthTag.m_128431_()) {
                pos = BlockPos.m_122022_((long)Long.parseLong(key));
                blockHealth.put(pos, healthTag.m_128451_(key));
            }
        }
        if (tag.m_128441_("max_health")) {
            CompoundTag maxHealthTag = tag.m_128469_("max_health");
            for (String key : maxHealthTag.m_128431_()) {
                pos = BlockPos.m_122022_((long)Long.parseLong(key));
                maxHealth.put(pos, maxHealthTag.m_128451_(key));
            }
        }
    }
}

