/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.BlockHealthData;
import com.example.examplemod.IconNotificationManager;
import com.example.examplemod.SurvivalBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class BlockHealthMonitor {
    private static final Map<BlockPos, Integer> lastKnownHealth = new HashMap<BlockPos, Integer>();

    public static void checkBlockHealth(ServerLevel level, BlockPos blockPos) {
        if (level.m_8055_(blockPos).m_60734_() instanceof SurvivalBlock) {
            int currentHealth = BlockHealthData.getHealth(blockPos);
            Integer lastHealth = lastKnownHealth.get(blockPos);
            if (lastHealth == null || !lastHealth.equals(currentHealth)) {
                BlockHealthMonitor.showHealthIcon(level, currentHealth);
                lastKnownHealth.put(blockPos, currentHealth);
            }
        }
    }

    private static void showHealthIcon(ServerLevel level, int healthPercent) {
        if (healthPercent <= 25) {
            IconNotificationManager.showIconToAll(level, IconNotificationManager.IconType.RED, 4);
        } else if (healthPercent <= 60) {
            IconNotificationManager.showIconToAll(level, IconNotificationManager.IconType.YELLOW, 3);
        } else {
            IconNotificationManager.showIconToAll(level, IconNotificationManager.IconType.GREEN, 2);
        }
    }

    public static void forceShowHealthIcon(ServerLevel level, BlockPos blockPos) {
        if (level.m_8055_(blockPos).m_60734_() instanceof SurvivalBlock) {
            int currentHealth = BlockHealthData.getHealth(blockPos);
            BlockHealthMonitor.showHealthIcon(level, currentHealth);
            lastKnownHealth.put(blockPos, currentHealth);
        }
    }

    public static void removeBlock(BlockPos blockPos) {
        lastKnownHealth.remove(blockPos);
    }

    public static void clearAll() {
        lastKnownHealth.clear();
    }
}

