/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ProtectionZone;
import com.example.examplemod.SurvivalManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class BlockUpgradeData {
    private int upgradeLevel = 0;
    private static final int MAX_LEVEL = 100;
    private static final Random random = new Random();
    private static final Map<Integer, UpgradeRequirement> UPGRADE_REQUIREMENTS = new HashMap<Integer, UpgradeRequirement>();

    private static Map<Item, Integer> getSimpleResources(int level) {
        HashMap<Item, Integer> resources = new HashMap<Item, Integer>();
        resources.put(Items.f_42329_, Math.min(10 + level * 2, 64));
        resources.put(Items.f_42594_, Math.min(5 + level, 32));
        resources.put(Items.f_42416_, Math.min(level, 16));
        return resources;
    }

    private static Map<Item, Integer> getMediumResources(int level) {
        HashMap<Item, Integer> resources = new HashMap<Item, Integer>();
        resources.put(Items.f_42416_, Math.min(10 + level, 32));
        resources.put(Items.f_42417_, Math.min(5 + level / 2, 16));
        resources.put(Items.f_42415_, Math.min(level / 3, 8));
        resources.put(Items.f_42616_, Math.min(level / 4, 4));
        return resources;
    }

    private static Map<Item, Integer> getAdvancedResources(int level) {
        HashMap<Item, Integer> resources = new HashMap<Item, Integer>();
        resources.put(Items.f_42415_, Math.min(10 + level / 2, 32));
        resources.put(Items.f_42616_, Math.min(5 + level / 3, 16));
        resources.put(Items.f_42418_, Math.min(level / 10, 4));
        resources.put(Items.f_42437_, Math.min(level / 20, 2));
        return resources;
    }

    public int getUpgradeLevel() {
        return this.upgradeLevel;
    }

    public boolean canUpgrade() {
        return this.upgradeLevel < 100;
    }

    public UpgradeRequirement getNextUpgradeRequirement() {
        int nextLevel = this.upgradeLevel + 1;
        if (!UPGRADE_REQUIREMENTS.containsKey(nextLevel)) {
            UPGRADE_REQUIREMENTS.put(nextLevel, this.generateRandomRequirement(nextLevel));
        }
        return UPGRADE_REQUIREMENTS.get(nextLevel);
    }

    private UpgradeRequirement generateRandomRequirement(int level) {
        HashMap<Item, Integer> resources = new HashMap<Item, Integer>();
        int radiusIncrease = level <= 20 ? 2 : (level <= 50 ? 4 : 5);
        Item[] commonItems = new Item[]{Items.f_42329_, Items.f_42594_, Items.f_42647_, Items.f_41905_, Items.f_41830_, Items.f_41832_};
        Item[] rareItems = new Item[]{Items.f_42416_, Items.f_42417_, Items.f_42415_, Items.f_42616_, Items.f_42534_};
        Item[] epicItems = new Item[]{Items.f_42418_, Items.f_42437_, Items.f_42686_, Items.f_42104_};
        int itemCount = 2 + random.nextInt(3);
        for (int i = 0; i < itemCount; ++i) {
            int count;
            Item item;
            int rarity = random.nextInt(100);
            if (level <= 20) {
                if (rarity < 80) {
                    item = commonItems[random.nextInt(commonItems.length)];
                    count = 10 + random.nextInt(50) + level;
                } else {
                    item = rareItems[random.nextInt(rareItems.length)];
                    count = 1 + random.nextInt(10) + level / 2;
                }
            } else if (level <= 50) {
                if (rarity < 50) {
                    item = commonItems[random.nextInt(commonItems.length)];
                    count = 20 + random.nextInt(100) + level;
                } else if (rarity < 90) {
                    item = rareItems[random.nextInt(rareItems.length)];
                    count = 5 + random.nextInt(20) + level / 2;
                } else {
                    item = epicItems[random.nextInt(epicItems.length)];
                    count = 1 + random.nextInt(3);
                }
            } else if (rarity < 30) {
                item = commonItems[random.nextInt(commonItems.length)];
                count = 50 + random.nextInt(200) + level;
            } else if (rarity < 70) {
                item = rareItems[random.nextInt(rareItems.length)];
                count = 10 + random.nextInt(50) + level / 2;
            } else {
                item = epicItems[random.nextInt(epicItems.length)];
                count = 1 + random.nextInt(5) + level / 20;
            }
            resources.put(item, count);
        }
        return new UpgradeRequirement(resources, radiusIncrease);
    }

    public boolean upgrade(ServerPlayer player, Level level, BlockPos blockPos) {
        if (!this.canUpgrade()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442!"));
            return false;
        }
        UpgradeRequirement requirement = this.getNextUpgradeRequirement();
        if (requirement == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f!"));
            return false;
        }
        if (!this.hasRequiredResources(player, requirement)) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f!"));
            this.sendRequiredResources(player, requirement);
            return false;
        }
        this.takeResources(player, requirement);
        ++this.upgradeLevel;
        this.expandProtectionZone(level, blockPos, requirement.getRadiusIncrease());
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u00a7l\u0411\u043b\u043e\u043a \u0443\u043b\u0443\u0447\u0448\u0435\u043d \u0434\u043e \u0443\u0440\u043e\u0432\u043d\u044f " + this.upgradeLevel + "!")));
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7e\u0417\u0430\u0449\u0438\u0442\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0430 \u043d\u0430 " + requirement.getRadiusIncrease() + " \u0431\u043b\u043e\u043a\u043e\u0432!")));
        return true;
    }

    private boolean hasRequiredResources(ServerPlayer player, UpgradeRequirement requirement) {
        for (Map.Entry<Item, Integer> entry : requirement.getResources().entrySet()) {
            int count = player.m_150109_().m_18947_(entry.getKey());
            if (count >= entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private void takeResources(ServerPlayer player, UpgradeRequirement requirement) {
        for (Map.Entry<Item, Integer> entry : requirement.getResources().entrySet()) {
            player.m_150109_().m_36022_(item -> item.m_41720_() == entry.getKey(), entry.getValue().intValue(), (Container)player.f_36095_.m_39730_());
        }
    }

    private void sendRequiredResources(ServerPlayer player, UpgradeRequirement requirement) {
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76\u0422\u0440\u0435\u0431\u0443\u0435\u043c\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b:"));
        for (Map.Entry<Item, Integer> entry : requirement.getResources().entrySet()) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a77- " + entry.getKey().m_41466_().getString() + ": " + String.valueOf(entry.getValue()))));
        }
    }

    private void expandProtectionZone(Level level, BlockPos blockPos, int radiusIncrease) {
        ServerLevel serverLevel;
        SurvivalManager manager;
        if (level instanceof ServerLevel && (manager = SurvivalManager.get((Level)(serverLevel = (ServerLevel)level))) != null) {
            for (ProtectionZone zone : manager.getProtectionZones()) {
                if (!zone.getCenterBlock().equals((Object)blockPos)) continue;
                zone.expandZone(level, radiusIncrease);
                break;
            }
        }
    }

    public void save(CompoundTag tag) {
        tag.m_128405_("upgradeLevel", this.upgradeLevel);
    }

    public void load(CompoundTag tag) {
        this.upgradeLevel = tag.m_128451_("upgradeLevel");
    }

    public static class UpgradeRequirement {
        private final Map<Item, Integer> resources;
        private final int radiusIncrease;

        public UpgradeRequirement(Map<Item, Integer> resources, int radiusIncrease) {
            this.resources = resources;
            this.radiusIncrease = radiusIncrease;
        }

        public Map<Item, Integer> getResources() {
            return this.resources;
        }

        public int getRadiusIncrease() {
            return this.radiusIncrease;
        }
    }
}

