/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.IconNotificationManager;
import com.example.examplemod.ScreenNotificationManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class BloodNightManager {
    private static boolean isBloodNight = false;
    private static boolean bloodNightMusicPlaying = false;
    private static Thread musicLoopThread = null;

    public static boolean isBloodNightDay(int day) {
        return day % 7 == 0 && day > 0;
    }

    public static void startBloodNight(ServerLevel level, int day) {
        isBloodNight = true;
        bloodNightMusicPlaying = false;
        ScreenNotificationManager.showNotification(level, "\u00a74\u00a7l\ud83d\udc80 \u041a\u0420\u041e\u0412\u0410\u0412\u0410\u042f \u041d\u041e\u0427\u042c " + day + " \ud83d\udc80", "\u00a7c\u0413\u0440\u044f\u0434\u0435\u0442 \u0443\u0436\u0430\u0441... \u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u044c\u0442\u0435\u0441\u044c \u043a \u043a\u043e\u0448\u043c\u0430\u0440\u0443!");
        for (ServerPlayer player : level.m_6907_()) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12563_, SoundSource.MASTER, 0.8f, 0.3f);
        }
        new Thread(() -> {
            try {
                Thread.sleep(3000L);
                BloodNightManager.startBloodNightMusic(level);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private static void startBloodNightMusic(ServerLevel level) {
        if (!isBloodNight) {
            return;
        }
        bloodNightMusicPlaying = true;
        BloodNightManager.startLoopingMusic(level);
        ScreenNotificationManager.showNotification(level, "\u00a74\u00a7l\u26a1 \u041a\u0420\u041e\u0412\u0410\u0412\u0410\u042f \u0411\u0423\u0420\u042f \u26a1", "\u00a7c\u0412\u043e\u043b\u043d\u0430 \u0443\u0436\u0430\u0441\u0430 \u043d\u0430\u0447\u0430\u043b\u0430\u0441\u044c! x10 \u043c\u043e\u0431\u043e\u0432!");
    }

    public static void endBloodNight(ServerLevel level, int day) {
        if (!isBloodNight) {
            return;
        }
        isBloodNight = false;
        bloodNightMusicPlaying = false;
        BloodNightManager.stopLoopingMusic();
        ScreenNotificationManager.showNotification(level, "\u00a7a\u00a7l\u2713 \u041a\u0420\u041e\u0412\u0410\u0412\u0410\u042f \u041d\u041e\u0427\u042c \u041f\u0415\u0420\u0415\u0416\u0418\u0422\u0410 \u2713", "\u00a7a\u0412\u044b \u0432\u044b\u0436\u0438\u043b\u0438 \u0432 \u043d\u043e\u0447\u0438 \u0443\u0436\u0430\u0441\u0430! \u0417\u0430\u0441\u043b\u0443\u0436\u0435\u043d\u043d\u044b\u0439 \u043e\u0442\u0434\u044b\u0445...");
        for (ServerPlayer player : level.m_6907_()) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.MASTER, 1.0f, 1.0f);
            new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_11699_, SoundSource.MASTER, 0.8f, 1.3f);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
        IconNotificationManager.showSafe(level);
    }

    public static int getBloodNightMobMultiplier() {
        return isBloodNight ? 10 : 1;
    }

    public static boolean isBloodNightActive() {
        return isBloodNight;
    }

    public static boolean isBloodNightMusicPlaying() {
        return bloodNightMusicPlaying;
    }

    public static String getBloodNightWaveName(int day, int remaining, int total) {
        return String.format("\u00a74\u00a7l\ud83d\udc80 \u041a\u0420\u041e\u0412\u0410\u0412\u0410\u042f \u041d\u041e\u0427\u042c %d \ud83d\udc80 \u00a7f| \u00a7c%d\u00a77/\u00a7c%d \u00a74\u043c\u043e\u0431\u043e\u0432", day, remaining, total);
    }

    public static String getBloodNightBossBarColor() {
        return "red";
    }

    private static void startLoopingMusic(ServerLevel level) {
        BloodNightManager.stopLoopingMusic();
        musicLoopThread = new Thread(() -> {
            try {
                while (isBloodNight && bloodNightMusicPlaying) {
                    for (ServerPlayer player : level.m_6907_()) {
                        level.m_5594_(null, player.m_20183_(), SoundEvents.f_12149_, SoundSource.MASTER, 0.7f, 1.0f);
                    }
                    Thread.sleep(30000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
        musicLoopThread.start();
    }

    private static void stopLoopingMusic() {
        if (musicLoopThread != null && musicLoopThread.isAlive()) {
            musicLoopThread.interrupt();
            musicLoopThread = null;
        }
    }
}

