/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.DifficultyManager;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class ClientDifficultySettings {
    private static final String SETTINGS_FILE = "citadelguard_difficulty.dat";
    private static DifficultyManager.Difficulty selectedDifficulty = null;

    public static void saveSelectedDifficulty(DifficultyManager.Difficulty difficulty) {
        selectedDifficulty = difficulty;
        try {
            File gameDir = Minecraft.m_91087_().f_91069_;
            File settingsFile = new File(gameDir, SETTINGS_FILE);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("selectedDifficulty", difficulty.getId());
            tag.m_128359_("displayName", difficulty.getDisplayName());
            NbtIo.m_128944_((CompoundTag)tag, (File)settingsFile);
            System.out.println("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: " + difficulty.getDisplayName());
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438: " + e.getMessage());
        }
    }

    public static DifficultyManager.Difficulty loadSelectedDifficulty() {
        if (selectedDifficulty != null) {
            return selectedDifficulty;
        }
        try {
            File gameDir = Minecraft.m_91087_().f_91069_;
            File settingsFile = new File(gameDir, SETTINGS_FILE);
            if (!settingsFile.exists()) {
                return null;
            }
            CompoundTag tag = NbtIo.m_128937_((File)settingsFile);
            String difficultyId = tag.m_128461_("selectedDifficulty");
            for (DifficultyManager.Difficulty diff : DifficultyManager.Difficulty.values()) {
                if (!diff.getId().equals(difficultyId)) continue;
                selectedDifficulty = diff;
                System.out.println("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: " + diff.getDisplayName());
                return diff;
            }
        }
        catch (IOException e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438: " + e.getMessage());
        }
        return null;
    }

    public static DifficultyManager.Difficulty getSelectedDifficulty() {
        if (selectedDifficulty == null) {
            selectedDifficulty = ClientDifficultySettings.loadSelectedDifficulty();
        }
        return selectedDifficulty;
    }

    public static String getFormattedDifficultyName() {
        DifficultyManager.Difficulty difficulty = ClientDifficultySettings.getSelectedDifficulty();
        if (difficulty == null) {
            return "\u00a77\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430";
        }
        String color = switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case DifficultyManager.Difficulty.NOVICE -> "\u00a7a";
            case DifficultyManager.Difficulty.EXPERIENCED -> "\u00a7e";
            case DifficultyManager.Difficulty.MONSTER -> "\u00a7c";
            case DifficultyManager.Difficulty.DEATH -> "\u00a74";
            case DifficultyManager.Difficulty.TEST -> "\u00a7d";
        };
        return color + difficulty.getDisplayName();
    }

    public static boolean isDifficultySelected() {
        return ClientDifficultySettings.getSelectedDifficulty() != null;
    }

    public static void clearSelectedDifficulty() {
        selectedDifficulty = null;
        try {
            File gameDir = Minecraft.m_91087_().f_91069_;
            File settingsFile = new File(gameDir, SETTINGS_FILE);
            if (settingsFile.exists()) {
                settingsFile.delete();
            }
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0447\u0438\u0441\u0442\u043a\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438: " + e.getMessage());
        }
    }
}

