/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.IconNotificationManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="citadelguard", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientIconRenderer {
    private static final ResourceLocation RED_ICON = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)"textures/gui/red.png");
    private static final ResourceLocation YELLOW_ICON = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)"textures/gui/yellow.png");
    private static final ResourceLocation GREEN_ICON = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)"textures/gui/green.png");
    private static final Map<IconNotificationManager.IconType, Long> activeIcons = new HashMap<IconNotificationManager.IconType, Long>();
    private static final int ICON_SIZE = 32;
    private static final int ICON_SPACING = 5;

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay().id().toString().equals("minecraft:hotbar")) {
            ClientIconRenderer.renderIcons(event.getGuiGraphics());
        }
    }

    private static void renderIcons(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        int baseX = screenWidth - 32 - 10;
        int baseY = screenHeight - 32 - 10;
        int iconIndex = 0;
        activeIcons.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
        for (Map.Entry<IconNotificationManager.IconType, Long> entry2 : activeIcons.entrySet()) {
            IconNotificationManager.IconType iconType = entry2.getKey();
            int x = baseX - iconIndex * 37;
            int y = baseY;
            ResourceLocation texture = ClientIconRenderer.getIconTexture(iconType);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
            guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
            ++iconIndex;
        }
    }

    private static ResourceLocation getIconTexture(IconNotificationManager.IconType iconType) {
        return switch (iconType) {
            default -> throw new IncompatibleClassChangeError();
            case IconNotificationManager.IconType.RED -> RED_ICON;
            case IconNotificationManager.IconType.YELLOW -> YELLOW_ICON;
            case IconNotificationManager.IconType.GREEN -> GREEN_ICON;
        };
    }

    public static void showIcon(IconNotificationManager.IconType iconType, int durationSeconds) {
        long endTime = System.currentTimeMillis() + (long)durationSeconds * 1000L;
        activeIcons.put(iconType, endTime);
    }

    public static void hideIcon(IconNotificationManager.IconType iconType) {
        activeIcons.remove((Object)iconType);
    }

    public static void hideAllIcons() {
        activeIcons.clear();
    }
}

