/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class DebugManager {
    private static final Set<UUID> debugEnabledPlayers = new HashSet<UUID>();

    public static void toggleDebug(ServerPlayer player) {
        UUID playerUUID = player.m_20148_();
        if (debugEnabledPlayers.contains(playerUUID)) {
            debugEnabledPlayers.remove(playerUUID);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[DEBUG] \u041e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u044b"));
        } else {
            debugEnabledPlayers.add(playerUUID);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[DEBUG] \u041e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u044b"));
        }
    }

    public static boolean isDebugEnabled(ServerPlayer player) {
        return debugEnabledPlayers.contains(player.m_20148_());
    }

    public static void sendDebugMessage(ServerPlayer player, String message) {
        if (DebugManager.isDebugEnabled(player)) {
            player.m_213846_((Component)Component.m_237113_((String)("\u00a78[DEBUG] " + message)));
        }
    }

    public static void sendDebugMessageToAll(ServerLevel level, String message) {
        for (ServerPlayer player : level.m_6907_()) {
            DebugManager.sendDebugMessage(player, message);
        }
    }

    public static void clearDebugPlayers() {
        debugEnabledPlayers.clear();
    }
}

