/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ProgressionManager;
import com.example.examplemod.SurvivalManager;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public final class DifficultyManager {
    private static volatile Difficulty selectedDifficulty = null;
    private static UUID currentPlayerUUID = null;

    private DifficultyManager() {
    }

    public static boolean setSelectedDifficulty(Difficulty difficulty, ServerPlayer player) {
        if (difficulty != null && player != null) {
            selectedDifficulty = difficulty;
            currentPlayerUUID = player.m_20148_();
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u2713 \u0421\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430: " + difficulty.getDisplayName())));
            System.out.println("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: " + difficulty.getDisplayName() + " \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430: " + player.m_7755_().getString());
            return true;
        }
        return false;
    }

    public static Difficulty getSelectedDifficulty() {
        return selectedDifficulty;
    }

    public static boolean isDifficultyChosen() {
        return selectedDifficulty != null;
    }

    public static String getConfigFilename() {
        return "survival_config_" + (selectedDifficulty != null ? selectedDifficulty.getId() : "experienced") + ".json";
    }

    public static void completeDifficulty(ServerLevel level, Difficulty difficulty) {
        if (currentPlayerUUID != null) {
            ProgressionManager progression = ProgressionManager.get(level);
            progression.completeDifficulty(currentPlayerUUID, difficulty);
            ServerPlayer player = level.m_7654_().m_6846_().m_11259_(currentPlayerUUID);
            if (player != null) {
                player.m_213846_((Component)Component.m_237113_((String)""));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a76\u00a7l\ud83c\udfc6 \u041f\u041e\u0417\u0414\u0420\u0410\u0412\u041b\u042f\u0415\u041c! \ud83c\udfc6"));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u0412\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0448\u043b\u0438 \u0443\u0440\u043e\u0432\u0435\u043d\u044c: " + difficulty.getDisplayName())));
                Difficulty nextDifficulty = DifficultyManager.getNextDifficulty(difficulty);
                if (nextDifficulty != null) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7e\ud83d\udd13 \u0420\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u043e\u0432\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c: " + nextDifficulty.getDisplayName())));
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a77" + nextDifficulty.getDescription())));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7d\ud83c\udf89 \u0412\u044b \u043f\u0440\u043e\u0448\u043b\u0438 \u0432\u0441\u0435 \u0443\u0440\u043e\u0432\u043d\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438! \u041f\u043e\u0437\u0434\u0440\u0430\u0432\u043b\u044f\u0435\u043c, \u043c\u0430\u0441\u0442\u0435\u0440!"));
                }
                player.m_213846_((Component)Component.m_237113_((String)""));
            }
        }
    }

    private static Difficulty getNextDifficulty(Difficulty current) {
        switch (current) {
            case NOVICE: {
                return Difficulty.EXPERIENCED;
            }
            case EXPERIENCED: {
                return Difficulty.MONSTER;
            }
            case MONSTER: {
                return Difficulty.DEATH;
            }
        }
        return null;
    }

    public static void checkCompletionConditions(ServerLevel level) {
        long daysElapsed;
        if (selectedDifficulty == null || currentPlayerUUID == null) {
            return;
        }
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager != null && (daysElapsed = manager.getDaysElapsed((Level)level)) >= 100L && !manager.isApocalypseMode()) {
            DifficultyManager.completeDifficulty(level, selectedDifficulty);
        }
    }

    public static void reset() {
        selectedDifficulty = null;
        currentPlayerUUID = null;
    }

    public static void setWorldDifficulty(Difficulty difficulty) {
        selectedDifficulty = difficulty;
    }

    public static enum Difficulty {
        NOVICE("novice", "\ud83d\ude0a \u041d\u043e\u0432\u0438\u0447\u043e\u043a", "\u0418\u0437\u0443\u0447\u0438\u0442\u0435 \u043e\u0441\u043d\u043e\u0432\u044b \u043e\u0431\u043e\u0440\u043e\u043d\u044b"),
        EXPERIENCED("experienced", "\ud83d\ude10 \u041e\u043f\u044b\u0442\u043d\u044b\u0439", "\u0421\u0431\u0430\u043b\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0432\u044b\u0437\u043e\u0432"),
        MONSTER("monster", "\ud83d\ude20 \u041c\u043e\u043d\u0441\u0442\u0440", "\u0421\u0435\u0440\u044c\u0435\u0437\u043d\u043e\u0435 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435"),
        DEATH("death", "\ud83d\udc80 \u0421\u043c\u0435\u0440\u0442\u044c", "\u042d\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c"),
        TEST("test", "\ud83e\uddea \u0422\u0435\u0441\u0442", "\u0420\u0435\u0436\u0438\u043c \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u0432");

        private final String id;
        private final String displayName;
        private final String description;

        private Difficulty(String id, String displayName, String description) {
            this.id = id;
            this.displayName = displayName;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

