/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.DifficultyManager;
import com.example.examplemod.IconNotificationManager;
import com.example.examplemod.ScreenNotificationManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class DifficultySelectionPacket {
    private final DifficultyManager.Difficulty difficulty;

    public DifficultySelectionPacket(DifficultyManager.Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public static void encode(DifficultySelectionPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.difficulty.ordinal());
    }

    public static DifficultySelectionPacket decode(FriendlyByteBuf buffer) {
        int difficultyOrdinal = buffer.readInt();
        DifficultyManager.Difficulty difficulty = DifficultyManager.Difficulty.values()[difficultyOrdinal];
        return new DifficultySelectionPacket(difficulty);
    }

    public static void handle(DifficultySelectionPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Level patt1305$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt1305$temp = player.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt1305$temp;
                boolean success = DifficultyManager.setSelectedDifficulty(packet.difficulty, player);
                if (success) {
                    try {
                        IconNotificationManager.hideDifficultySelection(serverLevel);
                    }
                    catch (Exception e) {
                        System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043a\u0440\u044b\u0442\u0438\u0438 GUI: " + e.getMessage());
                    }
                    String difficultyName = DifficultySelectionPacket.getDifficultyDisplayName(packet.difficulty);
                    String difficultyColor = DifficultySelectionPacket.getDifficultyColor(packet.difficulty);
                    try {
                        ScreenNotificationManager.showNotification(serverLevel, difficultyColor + "\u00a7l\u2713 \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u042c \u0412\u042b\u0411\u0420\u0410\u041d\u0410", difficultyColor + difficultyName);
                    }
                    catch (Exception e) {
                        System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043a\u0430\u0437\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f: " + e.getMessage());
                        player.m_213846_((Component)Component.m_237113_((String)(difficultyColor + "\u00a7l\u2713 \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u042c \u0412\u042b\u0411\u0420\u0410\u041d\u0410: " + difficultyName)));
                    }
                    System.out.println("\u0418\u0433\u0440\u043e\u043a " + player.m_7755_().getString() + " \u0432\u044b\u0431\u0440\u0430\u043b \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: " + packet.difficulty.getDisplayName());
                }
            }
        });
        context.setPacketHandled(true);
    }

    private static String getDifficultyDisplayName(DifficultyManager.Difficulty difficulty) {
        return switch (difficulty) {
            case DifficultyManager.Difficulty.NOVICE -> "\u041d\u041e\u0412\u0418\u0427\u041e\u041a - \u0414\u043b\u044f \u043d\u0430\u0447\u0438\u043d\u0430\u044e\u0449\u0438\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432";
            case DifficultyManager.Difficulty.EXPERIENCED -> "\u041e\u041f\u042b\u0422\u041d\u042b\u0419 - \u0421\u0431\u0430\u043b\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c";
            case DifficultyManager.Difficulty.MONSTER -> "\u041c\u041e\u041d\u0421\u0422\u0420 - \u0414\u043b\u044f \u044d\u043a\u0441\u043f\u0435\u0440\u0442\u043e\u0432";
            case DifficultyManager.Difficulty.DEATH -> "\u0421\u041c\u0415\u0420\u0422\u042c - \u042d\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c";
            case DifficultyManager.Difficulty.TEST -> "\u0422\u0415\u0421\u0422\u041e\u0412\u042b\u0419 \u0420\u0415\u0416\u0418\u041c - \u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0431\u043e\u0440\u043e\u043d\u0430";
            default -> "\u041d\u0415\u0418\u0417\u0412\u0415\u0421\u0422\u041d\u0410\u042f \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u042c";
        };
    }

    private static String getDifficultyColor(DifficultyManager.Difficulty difficulty) {
        return switch (difficulty) {
            case DifficultyManager.Difficulty.NOVICE -> "\u00a7a";
            case DifficultyManager.Difficulty.EXPERIENCED -> "\u00a7e";
            case DifficultyManager.Difficulty.MONSTER -> "\u00a7c";
            case DifficultyManager.Difficulty.DEATH -> "\u00a74";
            case DifficultyManager.Difficulty.TEST -> "\u00a7d";
            default -> "\u00a7f";
        };
    }
}

