/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ClientDifficultySettings;
import com.example.examplemod.DifficultyManager;
import com.example.examplemod.NetworkHandler;
import com.example.examplemod.NightMobConfig;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class DifficultySelectionScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"textures/gui/demo_background.png");
    private DifficultyManager.Difficulty selectedDifficultyTemp = null;

    public DifficultySelectionScreen() {
        super((Component)Component.m_237113_((String)"\u0412\u044b\u0431\u043e\u0440 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438"));
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonCenterX = this.f_96543_ / 2;
        int startY = Math.max(100, this.f_96544_ / 2 - 100);
        int buttonWidth = 300;
        int buttonHeight = 30;
        int spacing = 35;
        Button noviceButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7a\u00a7l\ud83c\udf31 \u041d\u041e\u0412\u0418\u0427\u041e\u041a"), button -> {
            this.selectedDifficultyTemp = DifficultyManager.Difficulty.NOVICE;
            this.playClickSound();
        }).m_252987_(buttonCenterX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)noviceButton);
        Button experiencedButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7e\u00a7l\u2694 \u041e\u041f\u042b\u0422\u041d\u042b\u0419"), button -> {
            this.selectedDifficultyTemp = DifficultyManager.Difficulty.EXPERIENCED;
            this.playClickSound();
        }).m_252987_(buttonCenterX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)experiencedButton);
        Button monsterButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7c\u00a7l\ud83d\udc80 \u041c\u041e\u041d\u0421\u0422\u0420"), button -> {
            this.selectedDifficultyTemp = DifficultyManager.Difficulty.MONSTER;
            this.playClickSound();
        }).m_252987_(buttonCenterX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)monsterButton);
        Button deathButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a74\u00a7l\u2620 \u0421\u041c\u0415\u0420\u0422\u042c"), button -> {
            this.selectedDifficultyTemp = DifficultyManager.Difficulty.DEATH;
            this.playClickSound();
        }).m_252987_(buttonCenterX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)deathButton);
        Button testButton = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7d\u00a7l\ud83d\udd27 \u0422\u0415\u0421\u0422\u041e\u0412\u042b\u0419 \u0420\u0415\u0416\u0418\u041c"), button -> {
            this.selectedDifficultyTemp = DifficultyManager.Difficulty.TEST;
            this.playClickSound();
        }).m_252987_(buttonCenterX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_();
        this.m_142416_((GuiEventListener)testButton);
        int bottomY = this.f_96544_ - 40;
        int bottomButtonWidth = 100;
        int bottomButtonSpacing = 30;
        int bottomCenterX = this.f_96543_ / 2;
        Button confirmButton = Button.m_253074_((Component)Component.m_237113_((String)"\u041f\u041e\u0414\u0422\u0412\u0415\u0420\u0414\u0418\u0422\u042c"), button -> this.confirmSelection()).m_252987_(bottomCenterX - bottomButtonWidth - bottomButtonSpacing / 2, bottomY, bottomButtonWidth, 26).m_253136_();
        this.m_142416_((GuiEventListener)confirmButton);
        Button cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"\u041e\u0422\u041c\u0415\u041d\u0410"), button -> this.f_96541_.m_91152_(null)).m_252987_(bottomCenterX + bottomButtonSpacing / 2, bottomY, bottomButtonWidth, 26).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
    }

    private void confirmSelection() {
        if (this.selectedDifficultyTemp != null) {
            this.selectDifficulty(this.selectedDifficultyTemp);
        } else {
            this.selectDifficulty(DifficultyManager.Difficulty.NOVICE);
        }
    }

    private void playClickSound() {
        if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
            this.f_96541_.f_91073_.m_7785_(this.f_96541_.f_91074_.m_20185_(), this.f_96541_.f_91074_.m_20186_(), this.f_96541_.f_91074_.m_20189_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.MASTER, 0.5f, 1.0f, false);
        }
    }

    private void renderDifficultyInfo(GuiGraphics guiGraphics, int panelX, int startY) {
        int availableHeight = this.f_96544_ - startY - 80;
        if (availableHeight < 60 || panelX < 50) {
            guiGraphics.m_280488_(this.f_96547_, "\u00a77\u00a7o\ud83d\udca1 \u041d\u0430\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u0443\u0440\u0441\u043e\u0440", panelX, startY, 0x888888);
            guiGraphics.m_280488_(this.f_96547_, "\u00a77\u00a7o   \u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0443 \u0434\u043b\u044f", panelX, startY + 12, 0x888888);
            guiGraphics.m_280488_(this.f_96547_, "\u00a77\u00a7o   \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0435\u0439", panelX, startY + 24, 0x888888);
            return;
        }
        int lineHeight = 11;
        int currentY = startY;
        guiGraphics.m_280488_(this.f_96547_, "\u00a76\u00a7l\ud83d\udcca \u0421\u0422\u0410\u0422\u0418\u0421\u0422\u0418\u041a\u0410 \u041c\u041e\u0411\u041e\u0412", panelX, currentY, 0xFFFFFF);
        int col1X = panelX;
        int col2X = panelX + 80;
        int col3X = panelX + 120;
        guiGraphics.m_280488_(this.f_96547_, "\u00a78\u0420\u0435\u0436\u0438\u043c", col1X, currentY += lineHeight + 8, 0xAAAAAA);
        guiGraphics.m_280488_(this.f_96547_, "\u00a781\u043d", col2X, currentY, 0xAAAAAA);
        guiGraphics.m_280488_(this.f_96547_, "\u00a78100\u043d", col3X, currentY, 0xAAAAAA);
        guiGraphics.m_280509_(col1X - 2, currentY += lineHeight + 2, col3X + 35, currentY + 1, -12566464);
        currentY += 4;
        DifficultyManager.Difficulty[] difficulties = new DifficultyManager.Difficulty[]{DifficultyManager.Difficulty.NOVICE, DifficultyManager.Difficulty.EXPERIENCED, DifficultyManager.Difficulty.MONSTER, DifficultyManager.Difficulty.DEATH, DifficultyManager.Difficulty.TEST};
        String[] colors = new String[]{"\u00a7a", "\u00a7e", "\u00a7c", "\u00a74", "\u00a7d"};
        String[] shortNames = new String[]{"\u041d\u043e\u0432\u0438\u0447\u043e\u043a", "\u041e\u043f\u044b\u0442\u043d\u044b\u0439", "\u041c\u043e\u043d\u0441\u0442\u0440", "\u0421\u043c\u0435\u0440\u0442\u044c", "\u0422\u0435\u0441\u0442"};
        for (int i = 0; i < difficulties.length && currentY + lineHeight < this.f_96544_ - 80; ++i) {
            DifficultyManager.Difficulty diff = difficulties[i];
            String color = colors[i];
            int night1 = NightMobConfig.getMobCountForNight(1, diff);
            int night100 = NightMobConfig.getMobCountForNight(100, diff);
            if (this.selectedDifficultyTemp == diff) {
                guiGraphics.m_280509_(col1X - 3, currentY - 1, col3X + 35, currentY + lineHeight, 0x40FFFFFF);
            }
            guiGraphics.m_280488_(this.f_96547_, color + shortNames[i], col1X, currentY, 0xFFFFFF);
            guiGraphics.m_280488_(this.f_96547_, "\u00a7f" + night1, col2X, currentY, 0xFFFFFF);
            guiGraphics.m_280488_(this.f_96547_, color + "\u00a7l" + night100, col3X, currentY, 0xFFFFFF);
            currentY += lineHeight + 1;
        }
        guiGraphics.m_280488_(this.f_96547_, "\u00a77\u00a7o\u26a1 \u0411\u043e\u043b\u044c\u0448\u0438\u0435 \u0432\u043e\u043b\u043d\u044b:", panelX, currentY += 8, 0x888888);
        guiGraphics.m_280488_(this.f_96547_, "\u00a77\u00a7o  \u043a\u0430\u0436\u0434\u044b\u0435 10 \u043d\u043e\u0447\u0435\u0439 +20%", panelX, currentY += 10, 0x888888);
        guiGraphics.m_280488_(this.f_96547_, "\u00a77\u00a7o\ud83e\ude78 \u041a\u0440\u043e\u0432\u0430\u0432\u044b\u0435 \u043d\u043e\u0447\u0438:", panelX, currentY += 12, 0x888888);
        guiGraphics.m_280488_(this.f_96547_, "\u00a77\u00a7o  \u043a\u0430\u0436\u0434\u044b\u0435 7 \u0434\u043d\u0435\u0439 x10", panelX, currentY += 10, 0x888888);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        String title = "\u2699 \u041d\u0410\u0421\u0422\u0420\u041e\u0419\u041a\u0410 \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u0418 CITADEL GUARD \u2699";
        guiGraphics.m_280137_(this.f_96547_, "\u00a78" + title, this.f_96543_ / 2 + 2, 32, 0);
        guiGraphics.m_280137_(this.f_96547_, "\u00a76\u00a7l" + title, this.f_96543_ / 2, 30, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "\u00a77\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0434\u043b\u044f \u0437\u0430\u0449\u0438\u0442\u044b \u0446\u0438\u0442\u0430\u0434\u0435\u043b\u0438", this.f_96543_ / 2, 45, 0xAAAAAA);
        if (this.selectedDifficultyTemp != null) {
            String selectedText = "\u00a7a\u00a7l\u25ba \u0412\u042b\u0411\u0420\u0410\u041d\u041e: " + this.getDifficultyColor(this.selectedDifficultyTemp) + "\u00a7l" + this.selectedDifficultyTemp.getDisplayName();
            guiGraphics.m_280137_(this.f_96547_, selectedText, this.f_96543_ / 2, 75, 0xFFFFFF);
        } else {
            guiGraphics.m_280137_(this.f_96547_, "\u00a77\u00a7o(\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u043d\u0438\u0436\u0435)", this.f_96543_ / 2, 75, 0x888888);
        }
        int leftPanelX = Math.max(20, this.f_96543_ / 2 - 250);
        int leftPanelY = Math.max(100, this.f_96544_ / 2 - 100);
        this.renderDifficultyInfo(guiGraphics, leftPanelX, leftPanelY);
        this.renderSelectedButtonHighlight(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltips(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280137_(this.f_96547_, "\u00a78\u00a7o\ud83d\udca1 \u041d\u0430\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u0443\u0440\u0441\u043e\u0440 \u043d\u0430 \u043a\u043d\u043e\u043f\u043a\u0443 \u0434\u043b\u044f \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438", this.f_96543_ / 2, this.f_96544_ - 40, 0x888888);
    }

    private void renderSelectedButtonHighlight(GuiGraphics guiGraphics) {
        if (this.selectedDifficultyTemp == null) {
            return;
        }
        int buttonCenterX = this.f_96543_ / 2;
        int startY = Math.max(100, this.f_96544_ / 2 - 100);
        int buttonWidth = 300;
        int buttonHeight = 30;
        int spacing = 35;
        int buttonIndex = switch (this.selectedDifficultyTemp) {
            default -> throw new IncompatibleClassChangeError();
            case DifficultyManager.Difficulty.NOVICE -> 0;
            case DifficultyManager.Difficulty.EXPERIENCED -> 1;
            case DifficultyManager.Difficulty.MONSTER -> 2;
            case DifficultyManager.Difficulty.DEATH -> 3;
            case DifficultyManager.Difficulty.TEST -> 4;
        };
        int buttonY = startY + spacing * buttonIndex;
        int buttonX = buttonCenterX - buttonWidth / 2;
        int highlightColor = this.getDifficultyBorderColor(this.selectedDifficultyTemp);
        guiGraphics.m_280509_(buttonX - 3, buttonY - 3, buttonX + buttonWidth + 3, buttonY - 2, highlightColor);
        guiGraphics.m_280509_(buttonX - 3, buttonY + buttonHeight + 2, buttonX + buttonWidth + 3, buttonY + buttonHeight + 3, highlightColor);
        guiGraphics.m_280509_(buttonX - 3, buttonY - 2, buttonX - 2, buttonY + buttonHeight + 2, highlightColor);
        guiGraphics.m_280509_(buttonX + buttonWidth + 2, buttonY - 2, buttonX + buttonWidth + 3, buttonY + buttonHeight + 2, highlightColor);
        int innerColor = highlightColor & 0xFFFFFF | 0x40000000;
        guiGraphics.m_280509_(buttonX - 2, buttonY - 2, buttonX + buttonWidth + 2, buttonY + buttonHeight + 2, innerColor);
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int buttonCenterX = this.f_96543_ / 2;
        int startY = Math.max(100, this.f_96544_ / 2 - 100);
        int buttonWidth = 300;
        int buttonHeight = 30;
        int spacing = 35;
        if (this.isMouseOverButton(mouseX, mouseY, buttonCenterX - buttonWidth / 2, startY, buttonWidth, buttonHeight)) {
            this.renderDifficultyTooltip(guiGraphics, mouseX, mouseY, DifficultyManager.Difficulty.NOVICE, "\u00a7a\u0418\u0434\u0435\u0430\u043b\u044c\u043d\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u0438\u0442 \u0434\u043b\u044f \u043d\u043e\u0432\u0438\u0447\u043a\u043e\u0432 \u0432 \u0438\u0433\u0440\u0435", "\u00a77\u0423\u043c\u0435\u0440\u0435\u043d\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432 \u043f\u043e \u043d\u043e\u0447\u0430\u043c", "\u00a77\u041e\u0442\u043b\u0438\u0447\u043d\u043e \u0434\u043b\u044f \u0438\u0437\u0443\u0447\u0435\u043d\u0438\u044f \u0432\u0441\u0435\u0445 \u0438\u0433\u0440\u043e\u0432\u044b\u0445 \u043c\u0435\u0445\u0430\u043d\u0438\u043a", "\u00a77\u041f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0441\u043f\u043e\u043a\u043e\u0439\u043d\u043e \u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0438 \u0440\u0430\u0437\u0432\u0438\u0432\u0430\u0442\u044c\u0441\u044f");
        } else if (this.isMouseOverButton(mouseX, mouseY, buttonCenterX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight)) {
            this.renderDifficultyTooltip(guiGraphics, mouseX, mouseY, DifficultyManager.Difficulty.EXPERIENCED, "\u00a7e\u0414\u043b\u044f \u043e\u043f\u044b\u0442\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0441 \u0445\u043e\u0440\u043e\u0448\u0438\u043c\u0438 \u043d\u0430\u0432\u044b\u043a\u0430\u043c\u0438", "\u00a77\u0417\u0430\u043c\u0435\u0442\u043d\u043e \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432", "\u00a77\u0422\u0440\u0435\u0431\u0443\u0435\u0442 \u0441\u0442\u0440\u0430\u0442\u0435\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0431\u043e\u0440\u043e\u043d\u044b", "\u00a77\u0411\u0430\u043b\u0430\u043d\u0441 \u043c\u0435\u0436\u0434\u0443 \u0432\u044b\u0437\u043e\u0432\u043e\u043c \u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c\u044e \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f");
        } else if (this.isMouseOverButton(mouseX, mouseY, buttonCenterX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight)) {
            this.renderDifficultyTooltip(guiGraphics, mouseX, mouseY, DifficultyManager.Difficulty.MONSTER, "\u00a7c\u041e\u0447\u0435\u043d\u044c \u0432\u044b\u0441\u043e\u043a\u0430\u044f \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u0435\u0440\u0442\u043e\u0432", "\u00a77\u0411\u043e\u043b\u044c\u0448\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u044b\u0445 \u043c\u043e\u0431\u043e\u0432", "\u00a77\u0422\u0440\u0435\u0431\u0443\u0435\u0442 \u043f\u0440\u043e\u0434\u0432\u0438\u043d\u0443\u0442\u044b\u0445 \u043d\u0430\u0432\u044b\u043a\u043e\u0432 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f", "\u00a77\u041f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430\u044f \u0443\u0433\u0440\u043e\u0437\u0430 \u0438 \u043d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u043d\u0430\u044f \u0438\u0433\u0440\u0430");
        } else if (this.isMouseOverButton(mouseX, mouseY, buttonCenterX - buttonWidth / 2, startY + spacing * 3, buttonWidth, buttonHeight)) {
            this.renderDifficultyTooltip(guiGraphics, mouseX, mouseY, DifficultyManager.Difficulty.DEATH, "\u00a74\u042d\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u043c\u0430\u0441\u0442\u0435\u0440\u043e\u0432", "\u00a77\u041e\u0433\u0440\u043e\u043c\u043d\u044b\u0435 \u043e\u0440\u0434\u044b \u043c\u043e\u0431\u043e\u0432 \u043a\u0430\u0436\u0434\u0443\u044e \u043d\u043e\u0447\u044c", "\u00a77\u0422\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0438\u0441\u0442\u0438\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u043e\u043d\u0430\u043b\u043e\u0432!", "\u00a77\u0412\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0435\u0439");
        } else if (this.isMouseOverButton(mouseX, mouseY, buttonCenterX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight)) {
            this.renderDifficultyTooltip(guiGraphics, mouseX, mouseY, DifficultyManager.Difficulty.TEST, "\u00a7d\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", "\u00a77\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0431\u043e\u0432", "\u00a77\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u043c \u0444\u0443\u043d\u043a\u0446\u0438\u044f\u043c", "\u00a77\u0418\u0434\u0435\u0430\u043b\u044c\u043d\u043e \u0434\u043b\u044f \u0438\u0437\u0443\u0447\u0435\u043d\u0438\u044f \u043c\u043e\u0434\u0430 \u0438 \u043e\u0442\u043b\u0430\u0434\u043a\u0438");
        }
    }

    private boolean isMouseOverButton(int mouseX, int mouseY, int buttonX, int buttonY, int buttonWidth, int buttonHeight) {
        return mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight;
    }

    private void renderDifficultyTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, DifficultyManager.Difficulty difficulty, String ... lines) {
        int padding;
        ArrayList<Object> tooltipLines = new ArrayList<Object>();
        String difficultyColor = this.getDifficultyColor(difficulty);
        tooltipLines.add(difficultyColor + "\u00a7l" + difficulty.getDisplayName());
        for (String line : lines) {
            tooltipLines.add(line);
        }
        tooltipLines.add("");
        tooltipLines.add("\u00a76\u00a7l\ud83d\udcca \u0421\u0422\u0410\u0422\u0418\u0421\u0422\u0418\u041a\u0410:");
        int finalMobs = NightMobConfig.getFinalNightTarget(difficulty);
        tooltipLines.add("\u00a77\u041c\u043e\u0431\u043e\u0432 \u043d\u0430 100-\u044e \u043d\u043e\u0447\u044c: " + difficultyColor + "\u00a7l" + String.format("%,d", finalMobs));
        tooltipLines.add("");
        tooltipLines.add("\u00a78\u00a7o\ud83d\udca1 \u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u0434\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u044d\u0442\u043e\u0439 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438");
        int tooltipX = mouseX + 20;
        int tooltipY = mouseY - 20;
        int maxWidth = 0;
        for (String string : tooltipLines) {
            int width = this.f_96547_.m_92895_(string);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (tooltipX + (maxWidth = Math.max(maxWidth, 480)) + (padding = 10) > this.f_96543_) {
            tooltipX = mouseX - maxWidth - padding - 20;
        }
        if (tooltipY < 0) {
            tooltipY = mouseY + 20;
        }
        int n = tooltipLines.size() * 14 + padding * 2;
        guiGraphics.m_280024_(tooltipX - padding, tooltipY - padding, tooltipX + maxWidth + padding, tooltipY + n - padding, -268435456, -266330080);
        int borderColor = this.getDifficultyBorderColor(difficulty);
        guiGraphics.m_280509_(tooltipX - padding - 2, tooltipY - padding - 2, tooltipX + maxWidth + padding + 2, tooltipY - padding - 1, borderColor);
        guiGraphics.m_280509_(tooltipX - padding - 2, tooltipY + n - padding + 1, tooltipX + maxWidth + padding + 2, tooltipY + n - padding + 2, borderColor);
        guiGraphics.m_280509_(tooltipX - padding - 2, tooltipY - padding - 1, tooltipX - padding - 1, tooltipY + n - padding + 1, borderColor);
        guiGraphics.m_280509_(tooltipX + maxWidth + padding + 1, tooltipY - padding - 1, tooltipX + maxWidth + padding + 2, tooltipY + n - padding + 1, borderColor);
        guiGraphics.m_280509_(tooltipX - padding - 1, tooltipY - padding - 1, tooltipX + maxWidth + padding + 1, tooltipY - padding, -12566464);
        guiGraphics.m_280509_(tooltipX - padding - 1, tooltipY + n - padding, tooltipX + maxWidth + padding + 1, tooltipY + n - padding + 1, -12566464);
        guiGraphics.m_280509_(tooltipX - padding - 1, tooltipY - padding, tooltipX - padding, tooltipY + n - padding, -12566464);
        guiGraphics.m_280509_(tooltipX + maxWidth + padding, tooltipY - padding, tooltipX + maxWidth + padding + 1, tooltipY + n - padding, -12566464);
        for (int i = 0; i < tooltipLines.size(); ++i) {
            guiGraphics.m_280488_(this.f_96547_, (String)tooltipLines.get(i), tooltipX, tooltipY + i * 14, 0xFFFFFF);
        }
    }

    private String getDifficultyColor(DifficultyManager.Difficulty difficulty) {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case DifficultyManager.Difficulty.NOVICE -> "\u00a7a";
            case DifficultyManager.Difficulty.EXPERIENCED -> "\u00a7e";
            case DifficultyManager.Difficulty.MONSTER -> "\u00a7c";
            case DifficultyManager.Difficulty.DEATH -> "\u00a74";
            case DifficultyManager.Difficulty.TEST -> "\u00a7d";
        };
    }

    private int getDifficultyBorderColor(DifficultyManager.Difficulty difficulty) {
        return switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case DifficultyManager.Difficulty.NOVICE -> -11141291;
            case DifficultyManager.Difficulty.EXPERIENCED -> -171;
            case DifficultyManager.Difficulty.MONSTER -> -43691;
            case DifficultyManager.Difficulty.DEATH -> -5636096;
            case DifficultyManager.Difficulty.TEST -> -43521;
        };
    }

    private void selectDifficulty(DifficultyManager.Difficulty difficulty) {
        System.out.println("\u0412\u044b\u0431\u0440\u0430\u043d\u0430 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: " + difficulty.getDisplayName());
        ClientDifficultySettings.saveSelectedDifficulty(difficulty);
        NetworkHandler.sendDifficultySelection(difficulty);
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u2713 \u0412\u044b\u0431\u0440\u0430\u043d\u0430 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: " + difficulty.getDisplayName())));
        }
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }
}

