/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.Config;
import com.example.examplemod.DifficultyBlock;
import com.example.examplemod.GenomControllerBlock;
import com.example.examplemod.GenomControllerBlockEntity;
import com.example.examplemod.GenomControllerContainer;
import com.example.examplemod.GenomControllerScreen;
import com.example.examplemod.GenomMachineBlock;
import com.example.examplemod.GenomMultiblockPart;
import com.example.examplemod.HealthBoostBlock;
import com.example.examplemod.NetworkHandler;
import com.example.examplemod.NightTestBlock;
import com.example.examplemod.NightTestContainer;
import com.example.examplemod.NightTestScreen;
import com.example.examplemod.RepairBlock;
import com.example.examplemod.RepairBlockContainer;
import com.example.examplemod.RepairBlockEntity;
import com.example.examplemod.RepairBlockScreen;
import com.example.examplemod.SurvivalBlock;
import com.example.examplemod.SurvivalBlockContainer;
import com.example.examplemod.SurvivalBlockEntity;
import com.example.examplemod.SurvivalBlockScreen;
import com.example.examplemod.SurvivalCommands;
import com.example.examplemod.WorldCreationEventHandler;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="citadelguard")
public class ExampleMod {
    public static final String MODID = "citadelguard";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"citadelguard");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"citadelguard");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"citadelguard");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"citadelguard");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"citadelguard");
    public static final RegistryObject<Block> EXAMPLE_BLOCK = BLOCKS.register("example_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Item> EXAMPLE_BLOCK_ITEM = ITEMS.register("example_block", () -> new BlockItem((Block)EXAMPLE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> SURVIVAL_BLOCK = BLOCKS.register("survival_block", () -> new SurvivalBlock());
    public static final RegistryObject<Block> HEALTH_BOOST_BLOCK = BLOCKS.register("health_boost_block", () -> new HealthBoostBlock());
    public static final RegistryObject<Item> HEALTH_BOOST_BLOCK_ITEM = ITEMS.register("health_boost_block", () -> new BlockItem((Block)HEALTH_BOOST_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> DIFFICULTY_BLOCK = BLOCKS.register("difficulty_block", () -> new DifficultyBlock());
    public static final RegistryObject<Item> DIFFICULTY_BLOCK_ITEM = ITEMS.register("difficulty_block", () -> new BlockItem((Block)DIFFICULTY_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> NIGHT_TEST_BLOCK = BLOCKS.register("night_test_block", () -> new NightTestBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283947_)));
    public static final RegistryObject<Item> NIGHT_TEST_BLOCK_ITEM = ITEMS.register("night_test_block", () -> new BlockItem((Block)NIGHT_TEST_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> REPAIR_BLOCK = BLOCKS.register("repair_block", () -> new RepairBlock());
    public static final RegistryObject<Item> REPAIR_BLOCK_ITEM = ITEMS.register("repair_block", () -> new BlockItem((Block)REPAIR_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> GENOM_CONTROLLER_BLOCK = BLOCKS.register("genom_controller_block", () -> new GenomControllerBlock());
    public static final RegistryObject<Item> GENOM_CONTROLLER_BLOCK_ITEM = ITEMS.register("genom_controller_block", () -> new BlockItem((Block)GENOM_CONTROLLER_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Block> GENOM_MULTIBLOCK_PART = BLOCKS.register("genom_multiblock_part", () -> new GenomMultiblockPart());
    public static final RegistryObject<Block> GENOM_MACHINE_BLOCK = BLOCKS.register("genom_machine_block", () -> new GenomMachineBlock());
    public static final RegistryObject<Item> GENOM_MACHINE_BLOCK_ITEM = ITEMS.register("genom_machine_block", () -> new BlockItem((Block)GENOM_MACHINE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> MEAT_CHUNK = ITEMS.register("meat_chunk", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> REPAIR_KEY = ITEMS.register("repair_key", () -> new Item(new Item.Properties()));
    public static final RegistryObject<BlockEntityType<SurvivalBlockEntity>> SURVIVAL_BLOCK_ENTITY = BLOCK_ENTITIES.register("survival_block", () -> BlockEntityType.Builder.m_155273_(SurvivalBlockEntity::new, (Block[])new Block[]{(Block)SURVIVAL_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<RepairBlockEntity>> REPAIR_BLOCK_ENTITY = BLOCK_ENTITIES.register("repair_block", () -> BlockEntityType.Builder.m_155273_(RepairBlockEntity::new, (Block[])new Block[]{(Block)REPAIR_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<GenomControllerBlockEntity>> GENOM_CONTROLLER_BLOCK_ENTITY = BLOCK_ENTITIES.register("genom_controller_block", () -> BlockEntityType.Builder.m_155273_(GenomControllerBlockEntity::new, (Block[])new Block[]{(Block)GENOM_CONTROLLER_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<MenuType<SurvivalBlockContainer>> SURVIVAL_BLOCK_CONTAINER = MENU_TYPES.register("survival_block", () -> IForgeMenuType.create((windowId, inv, data) -> new SurvivalBlockContainer(windowId, inv, inv.f_35978_.m_9236_().m_7702_(data.m_130135_()))));
    public static final RegistryObject<MenuType<NightTestContainer>> NIGHT_TEST_CONTAINER = MENU_TYPES.register("night_test", () -> IForgeMenuType.create((windowId, inv, data) -> new NightTestContainer(windowId, inv, data.m_130135_())));
    public static final RegistryObject<MenuType<RepairBlockContainer>> REPAIR_BLOCK_CONTAINER = MENU_TYPES.register("repair_block", () -> IForgeMenuType.create((windowId, inv, data) -> new RepairBlockContainer(windowId, inv, (RepairBlockEntity)inv.f_35978_.m_9236_().m_7702_(data.m_130135_()))));
    public static final RegistryObject<MenuType<GenomControllerContainer>> GENOM_CONTROLLER_CONTAINER = MENU_TYPES.register("genom_controller", () -> IForgeMenuType.create((windowId, inv, data) -> new GenomControllerContainer(windowId, inv, (GenomControllerBlockEntity)inv.f_35978_.m_9236_().m_7702_(data.m_130135_()))));
    public static final RegistryObject<Item> EXAMPLE_ITEM = ITEMS.register("example_item", () -> new Item(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(1).m_38758_(2.0f).m_38767_())));

    public ExampleMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(SurvivalCommands::onRegisterCommands);
        MinecraftForge.EVENT_BUS.register(WorldCreationEventHandler.class);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
        if (Config.logDirtBlock) {
            LOGGER.info("DIRT BLOCK >> {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50493_));
        }
        LOGGER.info(Config.magicNumberIntroduction + Config.magicNumber);
        Config.items.forEach(item -> LOGGER.info("ITEM >> {}", (Object)item.toString()));
        NetworkHandler.register();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(EXAMPLE_BLOCK_ITEM);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(modid="citadelguard", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonModEvents {
        @SubscribeEvent
        public static void addCreative(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256788_) {
                event.m_246326_((ItemLike)EXAMPLE_BLOCK_ITEM.get());
                event.m_246326_((ItemLike)HEALTH_BOOST_BLOCK_ITEM.get());
                event.m_246326_((ItemLike)DIFFICULTY_BLOCK_ITEM.get());
                event.m_246326_((ItemLike)NIGHT_TEST_BLOCK_ITEM.get());
                event.m_246326_((ItemLike)REPAIR_BLOCK_ITEM.get());
                event.m_246326_((ItemLike)GENOM_CONTROLLER_BLOCK_ITEM.get());
                event.m_246326_((ItemLike)GENOM_MACHINE_BLOCK_ITEM.get());
                event.m_246326_((ItemLike)MEAT_CHUNK.get());
                event.m_246326_((ItemLike)REPAIR_KEY.get());
            }
            if (event.getTabKey() == CreativeModeTabs.f_256839_) {
                event.m_246326_((ItemLike)EXAMPLE_ITEM.get());
            }
        }
    }

    @Mod.EventBusSubscriber(modid="citadelguard", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("HELLO FROM CLIENT SETUP");
            LOGGER.info("MINECRAFT NAME >> {}", (Object)Minecraft.m_91087_().m_91094_().m_92546_());
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)SURVIVAL_BLOCK_CONTAINER.get()), SurvivalBlockScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)NIGHT_TEST_CONTAINER.get()), NightTestScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)REPAIR_BLOCK_CONTAINER.get()), RepairBlockScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)GENOM_CONTROLLER_CONTAINER.get()), GenomControllerScreen::new);
            });
        }
    }
}

