/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ExampleMod;
import com.example.examplemod.GenomControllerBlock;
import com.example.examplemod.GenomMultiblockPart;
import com.example.examplemod.NetworkHandler;
import com.example.examplemod.SyncMachineDataPacket;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkDirection;

public class GenomControllerBlockEntity
extends BlockEntity {
    private boolean isMultiblockFormed = false;
    private final ItemStackHandler itemHandler = new ItemStackHandler(18);
    private boolean isWorking = false;
    private int progress = 0;
    private int maxProgress = 600;
    private static final int ORES_PER_BATCH = 5;
    private boolean clientIsWorking = false;
    private int clientProgress = 0;
    private int clientMaxProgress = 600;

    public GenomControllerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ExampleMod.GENOM_CONTROLLER_BLOCK_ENTITY.get(), pos, blockState);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GenomControllerBlockEntity blockEntity) {
        if (!level.f_46443_) {
            if (blockEntity.isWorking && blockEntity.isMultiblockFormed) {
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.progress = 0;
                    blockEntity.processCrafting();
                    if (!blockEntity.hasOresInInput()) {
                        blockEntity.isWorking = false;
                        blockEntity.updateControllerTexture(false);
                        System.out.println("DEBUG: Machine stopped - no more ores");
                    } else {
                        System.out.println("DEBUG: Machine continues - more ores available");
                    }
                }
                blockEntity.m_6596_();
                if (level.m_46467_() % 2L == 0L) {
                    blockEntity.syncToClients();
                }
            }
        } else if (blockEntity.isWorkingForClient()) {
            GenomControllerBlockEntity.spawnWorkingParticles(level, pos, state);
        }
    }

    private static void spawnWorkingParticles(Level level, BlockPos pos, BlockState state) {
        double randomZ;
        double randomY;
        double randomX;
        RandomSource random = level.f_46441_;
        Direction facing = (Direction)state.m_61143_((Property)GenomControllerBlock.FACING);
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        double offsetX = 0.0;
        double offsetZ = 0.0;
        switch (facing) {
            case NORTH: {
                offsetZ = -0.52;
                break;
            }
            case SOUTH: {
                offsetZ = 0.52;
                break;
            }
            case WEST: {
                offsetX = -0.52;
                break;
            }
            case EAST: {
                offsetX = 0.52;
            }
        }
        if (random.m_188500_() < 0.3) {
            randomX = x + offsetX + (random.m_188500_() - 0.5) * 0.3;
            randomY = y + random.m_188500_() * 0.5;
            randomZ = z + offsetZ + (random.m_188500_() - 0.5) * 0.3;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, randomX, randomY, randomZ, 0.0, 0.05, 0.0);
        }
        if (random.m_188500_() < 0.1) {
            randomX = x + offsetX + (random.m_188500_() - 0.5) * 0.3;
            randomY = y + random.m_188500_() * 0.5;
            randomZ = z + offsetZ + (random.m_188500_() - 0.5) * 0.3;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, randomX, randomY, randomZ, 0.0, 0.05, 0.0);
        }
    }

    public boolean checkMultiblockStructure() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.checkStructureAtOffset(0, 0, -1)) {
            this.isMultiblockFormed = true;
            return true;
        }
        if (this.checkStructureAtOffset(0, 0, 1)) {
            this.isMultiblockFormed = true;
            return true;
        }
        if (this.checkStructureAtOffset(-1, 0, 0)) {
            this.isMultiblockFormed = true;
            return true;
        }
        if (this.checkStructureAtOffset(1, 0, 0)) {
            this.isMultiblockFormed = true;
            return true;
        }
        this.isMultiblockFormed = false;
        return false;
    }

    private boolean checkStructureAtOffset(int offsetX, int offsetY, int offsetZ) {
        BlockPos center = this.f_58858_.m_7918_(-offsetX, -offsetY, -offsetZ);
        System.out.println("DEBUG: Checking structure at offset " + offsetX + "," + offsetY + "," + offsetZ);
        System.out.println("DEBUG: Controller at " + String.valueOf(this.f_58858_) + ", center at " + String.valueOf(center));
        int checkedBlocks = 0;
        int correctBlocks = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = center.m_7918_(x, y, z);
                    if (checkPos.equals((Object)this.f_58858_)) continue;
                    ++checkedBlocks;
                    BlockState state = this.f_58857_.m_8055_(checkPos);
                    if (state.m_60713_((Block)ExampleMod.GENOM_MACHINE_BLOCK.get())) {
                        ++correctBlocks;
                        continue;
                    }
                    System.out.println("DEBUG: Wrong block at " + String.valueOf(checkPos) + ": " + String.valueOf(state.m_60734_()));
                }
            }
        }
        System.out.println("DEBUG: Structure check result: " + correctBlocks + "/" + checkedBlocks + " correct blocks");
        return correctBlocks == checkedBlocks;
    }

    public boolean isMultiblockFormed() {
        return this.isMultiblockFormed;
    }

    public void forceCheckStructure() {
        this.checkMultiblockStructure();
    }

    public void ensureMultiblockChecked() {
        if (!this.isMultiblockFormed) {
            this.checkMultiblockStructure();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("multiblockFormed", this.isMultiblockFormed);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128379_("isWorking", this.isWorking);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("maxProgress", this.maxProgress);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isMultiblockFormed = tag.m_128471_("multiblockFormed");
        if (tag.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        }
        this.isWorking = tag.m_128471_("isWorking");
        this.progress = tag.m_128451_("progress");
        this.maxProgress = tag.m_128441_("maxProgress") ? tag.m_128451_("maxProgress") : 600;
    }

    private void activateMultiblock(int offsetX, int offsetY, int offsetZ) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos center = this.f_58858_.m_7918_(-offsetX, -offsetY, -offsetZ);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockState state;
                    BlockPos checkPos = center.m_7918_(x, y, z);
                    if (checkPos.equals((Object)this.f_58858_) || !(state = this.f_58857_.m_8055_(checkPos)).m_60713_((Block)ExampleMod.GENOM_MACHINE_BLOCK.get())) continue;
                    this.f_58857_.m_7731_(checkPos, ((Block)ExampleMod.GENOM_MULTIBLOCK_PART.get()).m_49966_(), 3);
                }
            }
        }
        this.m_6596_();
    }

    public void deactivateMultiblock() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos checkPos = this.f_58858_.m_7918_(x, y, z);
                    BlockState state = this.f_58857_.m_8055_(checkPos);
                    if (!(state.m_60734_() instanceof GenomMultiblockPart)) continue;
                    this.f_58857_.m_7731_(checkPos, ((Block)ExampleMod.GENOM_MACHINE_BLOCK.get()).m_49966_(), 3);
                }
            }
        }
        this.isMultiblockFormed = false;
        this.m_6596_();
    }

    public void startWorking() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.ensureMultiblockChecked();
            System.out.println("DEBUG: startWorking called on server");
            System.out.println("DEBUG: isWorking=" + this.isWorking + ", isMultiblockFormed=" + this.isMultiblockFormed + ", hasOres=" + this.hasOresInInput());
            if (!this.isWorking && this.isMultiblockFormed && this.hasOresInInput()) {
                this.isWorking = true;
                this.progress = 0;
                this.updateControllerTexture(true);
                this.m_6596_();
                this.syncToClients();
                System.out.println("DEBUG: Machine started successfully!");
            } else {
                System.out.println("DEBUG: Machine start failed - conditions not met");
            }
        }
    }

    public void stopWorking() {
        this.isWorking = false;
        this.progress = 0;
        this.updateControllerTexture(false);
        this.m_6596_();
        this.syncToClients();
    }

    private boolean hasOresInInput() {
        int oreCount = 0;
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || !this.isOre(stack) || (oreCount += stack.m_41613_()) < 5) continue;
            return true;
        }
        return false;
    }

    private boolean isOre(ItemStack stack) {
        return stack.m_150930_(Items.f_41835_) || stack.m_150930_(Items.f_150963_) || stack.m_150930_(Items.f_41834_) || stack.m_150930_(Items.f_150964_) || stack.m_150930_(Items.f_41833_) || stack.m_150930_(Items.f_150967_) || stack.m_150930_(Items.f_42010_) || stack.m_150930_(Items.f_150994_) || stack.m_150930_(Items.f_42107_) || stack.m_150930_(Items.f_150969_) || stack.m_150930_(Items.f_41853_) || stack.m_150930_(Items.f_150993_) || stack.m_150930_(Items.f_41977_) || stack.m_150930_(Items.f_150968_) || stack.m_150930_(Items.f_150965_) || stack.m_150930_(Items.f_150966_) || stack.m_150930_(Items.f_41836_) || stack.m_150930_(Items.f_42154_);
    }

    private void updateControllerTexture(boolean working) {
        BlockState currentState;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (currentState = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof GenomControllerBlock) {
            BlockState newState = (BlockState)currentState.m_61124_((Property)GenomControllerBlock.WORKING, (Comparable)Boolean.valueOf(working));
            this.f_58857_.m_7731_(this.f_58858_, newState, 3);
        }
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressPercent() {
        if (this.maxProgress == 0) {
            return 0;
        }
        return this.progress * 100 / this.maxProgress;
    }

    private void processCrafting() {
        Random random = new Random();
        int processedCount = 0;
        for (int i = 0; i < 6 && processedCount < 5; ++i) {
            OreProcessingResult result;
            ItemStack inputStack = this.itemHandler.getStackInSlot(i);
            if (inputStack.m_41619_() || !this.isOre(inputStack) || (result = this.processOre(inputStack, random)) == null) continue;
            inputStack.m_41774_(1);
            this.addItemToModule(result.mainOutput, 12, 18);
            this.addItemToModule(result.byproduct, 6, 12);
            if (random.nextFloat() < 0.2f) {
                this.addItemToModule(new ItemStack((ItemLike)inputStack.m_41720_(), 1), 6, 12);
            }
            ++processedCount;
        }
        System.out.println("DEBUG: Processed " + processedCount + " ores in this batch");
        this.m_6596_();
    }

    private OreProcessingResult processOre(ItemStack oreStack, Random random) {
        int mainAmount = 1 + random.nextInt(4);
        if (oreStack.m_150930_(Items.f_41835_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42413_, mainAmount), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150963_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42413_, mainAmount), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_41834_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_151050_, mainAmount), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150964_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_151050_, mainAmount), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_41833_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_151053_, mainAmount), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150967_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_151053_, mainAmount), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_42010_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42415_, mainAmount), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150994_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42415_, mainAmount), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_42107_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42616_, mainAmount), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150969_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42616_, mainAmount), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_41853_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42534_, mainAmount * 2), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150993_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42534_, mainAmount * 2), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_41977_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42451_, mainAmount * 3), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150968_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42451_, mainAmount * 3), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_150965_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_151051_, mainAmount), new ItemStack((ItemLike)Items.f_42594_, 1));
        }
        if (oreStack.m_150930_(Items.f_150966_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_151051_, mainAmount), new ItemStack((ItemLike)Items.f_151035_, 1));
        }
        if (oreStack.m_150930_(Items.f_41836_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42587_, mainAmount * 4), new ItemStack((ItemLike)Items.f_42048_, 1));
        }
        if (oreStack.m_150930_(Items.f_42154_)) {
            return new OreProcessingResult(new ItemStack((ItemLike)Items.f_42692_, mainAmount), new ItemStack((ItemLike)Items.f_42048_, 1));
        }
        return null;
    }

    private void addItemToModule(ItemStack stack, int startSlot, int endSlot) {
        if (stack.m_41619_()) {
            return;
        }
        for (int i = startSlot; i < endSlot; ++i) {
            int canAdd;
            ItemStack slotStack = this.itemHandler.getStackInSlot(i);
            if (slotStack.m_41619_()) {
                this.itemHandler.setStackInSlot(i, stack.m_41777_());
                return;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack) || (canAdd = Math.min(stack.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_())) <= 0) continue;
            slotStack.m_41769_(canAdd);
            stack.m_41774_(canAdd);
            if (!stack.m_41619_()) continue;
            return;
        }
    }

    public void setClientData(boolean isWorking, int progress, int maxProgress) {
        this.clientIsWorking = isWorking;
        this.clientProgress = progress;
        this.clientMaxProgress = maxProgress;
    }

    public boolean isWorkingForClient() {
        return this.f_58857_ != null && this.f_58857_.f_46443_ ? this.clientIsWorking : this.isWorking;
    }

    public int getProgressForClient() {
        return this.f_58857_ != null && this.f_58857_.f_46443_ ? this.clientProgress : this.progress;
    }

    public int getProgressPercentForClient() {
        int currentMaxProgress;
        int currentProgress = this.getProgressForClient();
        int n = currentMaxProgress = this.f_58857_ != null && this.f_58857_.f_46443_ ? this.clientMaxProgress : this.maxProgress;
        if (currentMaxProgress == 0) {
            return 0;
        }
        return currentProgress * 100 / currentMaxProgress;
    }

    private void syncToClients() {
        Level level;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SyncMachineDataPacket packet = new SyncMachineDataPacket(this.f_58858_, this.isWorking, this.progress, this.maxProgress);
            for (ServerPlayer player : serverLevel.m_6907_()) {
                if (!(player.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) < 4096.0)) continue;
                NetworkHandler.INSTANCE.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    private static class OreProcessingResult {
        public final ItemStack mainOutput;
        public final ItemStack byproduct;

        public OreProcessingResult(ItemStack mainOutput, ItemStack byproduct) {
            this.mainOutput = mainOutput;
            this.byproduct = byproduct;
        }
    }
}

