/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.SurvivalBlock;
import com.example.examplemod.SurvivalManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GolemBehavior {
    public static void improveIronGolemBehavior(IronGolem golem, ServerLevel level) {
        LivingEntity currentTarget = golem.m_5448_();
        List nearbyCreepers = level.m_45976_(Creeper.class, new AABB(golem.m_20183_()).m_82400_(16.0));
        if (!nearbyCreepers.isEmpty()) {
            Creeper nearestCreeper = null;
            double nearestDistance = Double.MAX_VALUE;
            for (Creeper creeper : nearbyCreepers) {
                double distance = golem.m_20280_((Entity)creeper);
                if (!(distance < nearestDistance)) continue;
                nearestCreeper = creeper;
                nearestDistance = distance;
            }
            if (nearestCreeper != null) {
                boolean shouldTarget = false;
                if (currentTarget == null) {
                    shouldTarget = true;
                } else if (currentTarget instanceof Creeper) {
                    double currentDistance = golem.m_20280_((Entity)currentTarget);
                    if (nearestDistance < currentDistance) {
                        shouldTarget = true;
                    }
                } else if (nearestDistance <= 64.0) {
                    shouldTarget = true;
                }
                if (shouldTarget) {
                    golem.m_6710_((LivingEntity)nearestCreeper);
                    golem.m_21573_().m_5624_((Entity)nearestCreeper, 1.5);
                }
            }
        }
    }

    public static void improveSnowGolemBehavior(SnowGolem golem, ServerLevel level) {
        LivingEntity currentTarget = golem.m_5448_();
        List nearbyCreepers = level.m_45976_(Creeper.class, new AABB(golem.m_20183_()).m_82400_(12.0));
        if (!nearbyCreepers.isEmpty()) {
            Creeper nearestCreeper = null;
            double nearestDistance = Double.MAX_VALUE;
            for (Creeper creeper : nearbyCreepers) {
                double distance = golem.m_20280_((Entity)creeper);
                if (!(distance < nearestDistance)) continue;
                nearestCreeper = creeper;
                nearestDistance = distance;
            }
            if (nearestCreeper != null) {
                boolean shouldTarget = false;
                if (currentTarget == null) {
                    shouldTarget = true;
                } else if (currentTarget instanceof Creeper) {
                    double currentDistance = golem.m_20280_((Entity)currentTarget);
                    if (nearestDistance < currentDistance) {
                        shouldTarget = true;
                    }
                } else if (nearestDistance <= 36.0) {
                    shouldTarget = true;
                }
                if (shouldTarget) {
                    double deltaZ;
                    double deltaX;
                    double distance;
                    golem.m_6710_((LivingEntity)nearestCreeper);
                    if (nearestDistance > 16.0) {
                        golem.m_21573_().m_5624_((Entity)nearestCreeper, 1.0);
                    } else if (nearestDistance < 9.0 && (distance = Math.sqrt((deltaX = golem.m_20185_() - nearestCreeper.m_20185_()) * deltaX + (deltaZ = golem.m_20189_() - nearestCreeper.m_20189_()) * deltaZ)) > 0.0) {
                        BlockPos retreatPos = golem.m_20183_().m_7918_((int)((deltaX /= distance) * 2.0), 0, (int)((deltaZ /= distance) * 2.0));
                        golem.m_21573_().m_26519_((double)retreatPos.m_123341_(), (double)retreatPos.m_123342_(), (double)retreatPos.m_123343_(), 1.2);
                    }
                }
            }
        }
    }

    private static BlockPos findNearestSurvivalBlock(LivingEntity entity, ServerLevel level) {
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return null;
        }
        BlockPos entityPos = entity.m_20183_();
        BlockPos nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (BlockPos blockPos : manager.survivalBlocks) {
            double distance;
            if (!(level.m_8055_(blockPos).m_60734_() instanceof SurvivalBlock) || !((distance = entityPos.m_123331_((Vec3i)blockPos)) < nearestDistance)) continue;
            nearest = blockPos;
            nearestDistance = distance;
        }
        return nearest;
    }
}

