/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.BlockHealthData;
import com.example.examplemod.IconNotificationManager;
import com.example.examplemod.ScreenNotificationManager;
import com.example.examplemod.SurvivalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class HealthBoostBlock
extends Block {
    public HealthBoostBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50268_).m_284180_(MapColor.f_283812_).m_60913_(2.0f, 6.0f).m_222994_().m_60955_().m_60918_(SoundType.f_56742_));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos survivalBlock = this.findNearbySurvivalBlock(level, pos);
            if (survivalBlock != null) {
                int healthBlocksCount = this.countNearbyHealthBlocks(level, survivalBlock);
                if (healthBlocksCount <= 10) {
                    BlockHealthData.increaseMaxHealth(survivalBlock, 20);
                    IconNotificationManager.showSafe(serverLevel);
                    level.m_5594_(null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    level.m_7471_(pos, false);
                    IconNotificationManager.showIconToAll(serverLevel, IconNotificationManager.IconType.RED, 3);
                }
            } else {
                level.m_7471_(pos, false);
                IconNotificationManager.showIconToAll(serverLevel, IconNotificationManager.IconType.YELLOW, 3);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos survivalBlock = this.findNearbySurvivalBlock(level, pos);
            if (survivalBlock != null) {
                BlockHealthData.increaseMaxHealth(survivalBlock, -20);
                IconNotificationManager.showIconToAll(serverLevel, IconNotificationManager.IconType.YELLOW, 3);
            }
        }
    }

    private BlockPos findNearbySurvivalBlock(Level level, BlockPos pos) {
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    if (!(level.m_8055_(checkPos).m_60734_() instanceof SurvivalBlock)) continue;
                    return checkPos;
                }
            }
        }
        return null;
    }

    private int countNearbyHealthBlocks(Level level, BlockPos survivalBlockPos) {
        int count = 0;
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos checkPos = survivalBlockPos.m_7918_(x, y, z);
                    if (!(level.m_8055_(checkPos).m_60734_() instanceof HealthBoostBlock)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos survivalBlock = this.findNearbySurvivalBlock(level, pos);
            if (survivalBlock != null) {
                int healthBlocksCount = this.countNearbyHealthBlocks(level, survivalBlock);
                int currentHealth = BlockHealthData.getHealth(survivalBlock);
                int maxHealth = BlockHealthData.getMaxHealth(survivalBlock);
                ScreenNotificationManager.showNotificationToPlayer(serverPlayer, "\u00a76\ud83d\udcca \u0421\u0422\u0410\u0422\u0423\u0421 \u0411\u041b\u041e\u041a\u0410 \u0417\u0414\u041e\u0420\u041e\u0412\u042c\u042f", "\u00a7e\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435: " + currentHealth + "/" + maxHealth + " | \u0411\u043b\u043e\u043a\u043e\u0432: " + healthBlocksCount + "/10");
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

