/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ClientIconRenderer;
import com.example.examplemod.IconNotificationManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class HideIconPacket {
    private final IconNotificationManager.IconType iconType;

    public HideIconPacket(IconNotificationManager.IconType iconType) {
        this.iconType = iconType;
    }

    public static void encode(HideIconPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.iconType.ordinal());
    }

    public static HideIconPacket decode(FriendlyByteBuf buffer) {
        int iconTypeOrdinal = buffer.readInt();
        IconNotificationManager.IconType iconType = IconNotificationManager.IconType.values()[iconTypeOrdinal];
        return new HideIconPacket(iconType);
    }

    public static void handle(HideIconPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientIconRenderer.hideIcon(packet.iconType));
        context.setPacketHandled(true);
    }
}

