/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.HideIconPacket;
import com.example.examplemod.NetworkHandler;
import com.example.examplemod.OpenDifficultyGUIPacket;
import com.example.examplemod.ShowIconPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;

public class IconNotificationManager {
    private static final Map<String, Map<IconType, Long>> activeIcons = new ConcurrentHashMap<String, Map<IconType, Long>>();

    public static void showIcon(ServerPlayer player, IconType iconType, int durationSeconds) {
        String playerId = player.m_20148_().toString();
        Map playerIcons = activeIcons.computeIfAbsent(playerId, k -> new HashMap());
        long endTime = System.currentTimeMillis() + (long)durationSeconds * 1000L;
        playerIcons.put(iconType, endTime);
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ShowIconPacket(iconType, durationSeconds));
    }

    public static void showIconToAll(ServerLevel level, IconType iconType, int durationSeconds) {
        for (ServerPlayer player : level.m_6907_()) {
            IconNotificationManager.showIcon(player, iconType, durationSeconds);
        }
    }

    public static void hideIcon(ServerPlayer player, IconType iconType) {
        String playerId = player.m_20148_().toString();
        Map<IconType, Long> playerIcons = activeIcons.get(playerId);
        if (playerIcons != null) {
            playerIcons.remove((Object)iconType);
            if (playerIcons.isEmpty()) {
                activeIcons.remove(playerId);
            }
        }
        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new HideIconPacket(iconType));
    }

    public static void hideAllIcons(ServerPlayer player) {
        String playerId = player.m_20148_().toString();
        Map<IconType, Long> playerIcons = activeIcons.remove(playerId);
        if (playerIcons != null) {
            for (IconType iconType : playerIcons.keySet()) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new HideIconPacket(iconType));
            }
        }
    }

    public static void cleanupExpiredIcons(ServerLevel level) {
        long currentTime = System.currentTimeMillis();
        for (ServerPlayer player : level.m_6907_()) {
            String playerId = player.m_20148_().toString();
            Map<IconType, Long> playerIcons = activeIcons.get(playerId);
            if (playerIcons == null) continue;
            playerIcons.entrySet().removeIf(entry -> {
                if ((Long)entry.getValue() <= currentTime) {
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new HideIconPacket((IconType)((Object)((Object)entry.getKey()))));
                    return true;
                }
                return false;
            });
            if (!playerIcons.isEmpty()) continue;
            activeIcons.remove(playerId);
        }
    }

    public static void showDifficultySelection(ServerLevel level) {
        for (ServerPlayer player : level.m_6907_()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenDifficultyGUIPacket());
        }
    }

    public static void hideDifficultySelection(ServerLevel level) {
    }

    public static void showBlockAttacked(ServerLevel level) {
        IconNotificationManager.showIconToAll(level, IconType.RED, 5);
    }

    public static void showCreeperExplosion(ServerLevel level) {
        IconNotificationManager.showIconToAll(level, IconType.RED, 3);
    }

    public static void showZombieBreaking(ServerLevel level) {
        IconNotificationManager.showIconToAll(level, IconType.YELLOW, 4);
    }

    public static void showLowHealth(ServerLevel level, int healthPercent) {
        if (healthPercent <= 25) {
            IconNotificationManager.showIconToAll(level, IconType.RED, 6);
        } else if (healthPercent <= 50) {
            IconNotificationManager.showIconToAll(level, IconType.YELLOW, 4);
        }
    }

    public static void showSafe(ServerLevel level) {
        IconNotificationManager.showIconToAll(level, IconType.GREEN, 2);
    }

    public static void clearAll() {
        activeIcons.clear();
    }

    public static enum IconType {
        RED,
        YELLOW,
        GREEN;

    }
}

