/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.SurvivalManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.level.Level;

public class NightBossBar {
    private static NightBossBar instance;
    private CustomBossEvent bossEvent;
    private ServerLevel level;
    private int currentNight;
    private int maxMobs;
    private int spawnedMobs;
    private int aliveMobs;
    private int killedMobs;
    private boolean isActive = false;

    private NightBossBar() {
    }

    public static NightBossBar getInstance() {
        if (instance == null) {
            instance = new NightBossBar();
        }
        return instance;
    }

    public void startNight(ServerLevel level, int nightNumber, int maxMobCount) {
        this.level = level;
        this.currentNight = nightNumber;
        this.maxMobs = maxMobCount;
        this.spawnedMobs = 0;
        this.aliveMobs = 0;
        this.killedMobs = 0;
        this.isActive = true;
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager != null) {
            manager.markNightStarted();
        }
        this.createBossBar();
        for (ServerPlayer player : level.m_6907_()) {
            this.bossEvent.m_6543_(player);
        }
        this.updateDisplay();
        if (level != null) {
            for (ServerPlayer player : level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7b[BOSS_BAR] \u0417\u0430\u043f\u0443\u0449\u0435\u043d! \u041d\u043e\u0447\u044c: " + nightNumber + ", \u041b\u0438\u043c\u0438\u0442: " + maxMobCount + ", \u0410\u043a\u0442\u0438\u0432\u0435\u043d: " + this.isActive)));
            }
        }
    }

    private void createBossBar() {
        if (this.bossEvent != null) {
            this.cleanup();
        }
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)("night_" + this.currentNight));
        this.bossEvent = new CustomBossEvent(id, (Component)Component.m_237113_((String)("\u041d\u043e\u0447\u044c " + this.currentNight)));
        this.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
        this.bossEvent.m_5648_(BossEvent.BossBarOverlay.PROGRESS);
        this.bossEvent.m_142711_(1.0f);
        this.bossEvent.m_8321_(true);
        this.bossEvent.m_7003_(false);
        this.bossEvent.m_7006_(false);
    }

    public void onMobSpawned() {
        if (!this.isActive || this.bossEvent == null) {
            return;
        }
        ++this.spawnedMobs;
        ++this.aliveMobs;
        this.updateDisplay();
        if (this.level != null) {
            for (ServerPlayer player : this.level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[DEBUG] \u041c\u043e\u0431 \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d! \u0417\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e: " + this.spawnedMobs + "/" + this.maxMobs + ", \u0416\u0438\u0432\u044b\u0445: " + this.aliveMobs)));
            }
        }
    }

    public void onMobDied() {
        boolean condition3;
        if (!this.isActive || this.bossEvent == null) {
            return;
        }
        this.aliveMobs = Math.max(0, this.aliveMobs - 1);
        if (this.killedMobs < this.maxMobs) {
            ++this.killedMobs;
        }
        this.updateDisplay();
        if (this.level != null) {
            for (ServerPlayer player : this.level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[DEBUG] \u041c\u043e\u0431 \u0443\u0431\u0438\u0442! \u0423\u0431\u0438\u0442\u043e: " + this.killedMobs + "/" + this.maxMobs + ", \u0416\u0438\u0432\u044b\u0445: " + this.aliveMobs)));
            }
        }
        boolean condition1 = this.killedMobs >= this.maxMobs;
        boolean condition2 = this.maxMobs > 0;
        boolean bl = condition3 = this.spawnedMobs > 0;
        if (this.level != null) {
            for (ServerPlayer player : this.level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7d[CHECK] \u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f: \u0443\u0431\u0438\u0442\u043e=" + this.killedMobs + ">=" + this.maxMobs + "? " + condition1 + ", \u043b\u0438\u043c\u0438\u0442>0? " + condition2 + ", \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e>0? " + condition3)));
            }
        }
        if (condition1 && condition2 && condition3) {
            if (this.level != null) {
                for (ServerPlayer player : this.level.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[VICTORY] \u0412\u0441\u0435 \u043c\u043e\u0431\u044b \u0443\u0431\u0438\u0442\u044b! \u0423\u0431\u0438\u0442\u043e: " + this.killedMobs + "/" + this.maxMobs + " - \u041d\u043e\u0447\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430!")));
                }
            }
            this.endNight();
        }
    }

    public void updateAliveMobs(int alive) {
        if (!this.isActive || this.bossEvent == null) {
            return;
        }
        if (Math.abs(this.aliveMobs - alive) > 2 || alive == 0) {
            int previousAlive = this.aliveMobs;
            this.aliveMobs = Math.max(0, alive);
            if (this.level != null && previousAlive != this.aliveMobs) {
                for (ServerPlayer player : this.level.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a76[SYNC_ONLY] \u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0436\u0438\u0432\u044b\u0445: " + previousAlive + " \u2192 " + this.aliveMobs + " (\u041d\u0415 \u0432\u043b\u0438\u044f\u0435\u0442 \u043d\u0430 \u0441\u0447\u0435\u0442\u0447\u0438\u043a \u0443\u0431\u0438\u0442\u044b\u0445)")));
                }
            }
            this.updateDisplay();
            if (this.level != null && Math.abs(previousAlive - alive) > 5) {
                for (ServerPlayer player : this.level.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a76[SYNC] \u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f: " + alive + " \u0436\u0438\u0432\u044b\u0445, " + this.killedMobs + " \u0443\u0431\u0438\u0442\u043e")));
                }
            }
        }
    }

    private void updateDisplay() {
        float killedRatio;
        if (!this.isActive || this.bossEvent == null) {
            return;
        }
        String title = String.format("\ud83c\udf19 \u041d\u043e\u0447\u044c %d | %d/%d \u043c\u043e\u0431\u043e\u0432 \u0443\u0431\u0438\u0442\u043e", this.currentNight, this.killedMobs, this.maxMobs);
        this.bossEvent.m_6456_((Component)Component.m_237113_((String)title));
        float progress = this.maxMobs > 0 ? (float)this.killedMobs / (float)this.maxMobs : 0.0f;
        this.bossEvent.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
        float f = killedRatio = this.maxMobs > 0 ? (float)this.killedMobs / (float)this.maxMobs : 0.0f;
        if (killedRatio < 0.25f) {
            this.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
        } else if (killedRatio < 0.5f) {
            this.bossEvent.m_6451_(BossEvent.BossBarColor.YELLOW);
        } else if (killedRatio < 0.9f) {
            this.bossEvent.m_6451_(BossEvent.BossBarColor.GREEN);
        } else {
            this.bossEvent.m_6451_(BossEvent.BossBarColor.BLUE);
        }
    }

    public void endNight() {
        if (!this.isActive) {
            return;
        }
        if (this.level != null) {
            for (ServerPlayer player : this.level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u2713 \u041d\u043e\u0447\u044c " + this.currentNight + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430!")));
            }
        }
        if (this.bossEvent != null) {
            this.bossEvent.m_6456_((Component)Component.m_237113_((String)("\ud83c\udf89 \u041d\u043e\u0447\u044c " + this.currentNight + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430!")));
            this.bossEvent.m_142711_(0.0f);
            this.bossEvent.m_6451_(BossEvent.BossBarColor.GREEN);
            new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                    this.cleanup();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
        this.isActive = false;
    }

    public void addPlayer(ServerPlayer player) {
        if (this.isActive && this.bossEvent != null) {
            this.bossEvent.m_6543_(player);
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (this.bossEvent != null) {
            this.bossEvent.m_6539_(player);
        }
    }

    public void cleanup() {
        if (this.bossEvent != null) {
            this.bossEvent.m_7706_();
            this.bossEvent.m_8321_(false);
            this.bossEvent = null;
        }
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getCurrentNight() {
        return this.currentNight;
    }

    public int getAliveMobs() {
        return this.aliveMobs;
    }

    public int getSpawnedMobs() {
        return this.spawnedMobs;
    }

    public int getMaxMobs() {
        return this.maxMobs;
    }

    public int getKilledMobs() {
        return this.killedMobs;
    }

    public boolean canSpawnMore() {
        return this.isActive && this.spawnedMobs < this.maxMobs && this.maxMobs > 0;
    }

    public void updateMaxMobs(int newMaxMobs) {
        if (!this.isActive || newMaxMobs <= 0) {
            return;
        }
        this.maxMobs = newMaxMobs;
        this.updateDisplay();
        if (this.level != null) {
            for (ServerPlayer player : this.level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7e[UPDATE] \u041b\u0438\u043c\u0438\u0442 \u043c\u043e\u0431\u043e\u0432 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d: " + this.maxMobs)));
            }
        }
    }

    public void forceEndNight() {
        if (this.isActive) {
            if (this.level != null) {
                for (ServerPlayer player : this.level.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[FORCE] \u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0447\u0438 " + this.currentNight)));
                }
            }
            this.endNight();
        }
    }

    public void resetCounters() {
        this.killedMobs = 0;
        this.spawnedMobs = 0;
        this.aliveMobs = 0;
        this.updateDisplay();
        if (this.level != null) {
            for (ServerPlayer player : this.level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e[RESET] \u0421\u0447\u0435\u0442\u0447\u0438\u043a\u0438 \u0441\u0431\u0440\u043e\u0448\u0435\u043d\u044b: \u0443\u0431\u0438\u0442\u043e=0, \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e=0, \u0436\u0438\u0432\u044b\u0445=0"));
            }
        }
    }
}

