/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.DifficultyManager;
import java.util.Map;

public class NightMobConfig {
    private static final Map<DifficultyManager.Difficulty, Integer> FINAL_NIGHT_TARGETS = Map.of(DifficultyManager.Difficulty.NOVICE, 1500, DifficultyManager.Difficulty.EXPERIENCED, 5000, DifficultyManager.Difficulty.MONSTER, 10000, DifficultyManager.Difficulty.DEATH, 15000, DifficultyManager.Difficulty.TEST, 100);
    private static final Map<DifficultyManager.Difficulty, Integer> FIRST_NIGHT_BASE = Map.of(DifficultyManager.Difficulty.NOVICE, 10, DifficultyManager.Difficulty.EXPERIENCED, 15, DifficultyManager.Difficulty.MONSTER, 25, DifficultyManager.Difficulty.DEATH, 35, DifficultyManager.Difficulty.TEST, 5);

    public static int getMobCountForNight(int night, DifficultyManager.Difficulty difficulty) {
        if (difficulty == null) {
            difficulty = DifficultyManager.Difficulty.NOVICE;
        }
        int firstNight = FIRST_NIGHT_BASE.get((Object)difficulty);
        int finalNight = FINAL_NIGHT_TARGETS.get((Object)difficulty);
        night = Math.max(1, Math.min(100, night));
        double progress = ((double)night - 1.0) / 99.0;
        double exponentialProgress = Math.pow(progress, 1.5);
        int mobCount = (int)Math.round((double)firstNight + exponentialProgress * (double)(finalNight - firstNight));
        if (NightMobConfig.isBigWaveNight(night)) {
            mobCount = (int)Math.round((double)mobCount * 1.2);
        }
        return Math.max(firstNight, mobCount);
    }

    @Deprecated
    public static int getMobCountForNight(int night) {
        return NightMobConfig.getMobCountForNight(night, DifficultyManager.Difficulty.NOVICE);
    }

    @Deprecated
    public static int getMobCountWithDifficulty(int night, DifficultyManager.Difficulty difficulty) {
        return NightMobConfig.getMobCountForNight(night, difficulty);
    }

    public static boolean isBigWaveNight(int night) {
        return night % 10 == 0;
    }

    public static String getNightDescription(int night, DifficultyManager.Difficulty difficulty) {
        int mobCount = NightMobConfig.getMobCountForNight(night, difficulty);
        String waveType = NightMobConfig.isBigWaveNight(night) ? "\u0411\u043e\u043b\u044c\u0448\u0430\u044f \u0432\u043e\u043b\u043d\u0430" : "\u041e\u0431\u044b\u0447\u043d\u0430\u044f \u043d\u043e\u0447\u044c";
        return String.format("\u041d\u043e\u0447\u044c %d (%s): %d \u043c\u043e\u0431\u043e\u0432 [%s]", night, waveType, mobCount, difficulty.getDisplayName());
    }

    public static String getProgressionInfo(DifficultyManager.Difficulty difficulty) {
        int[] keyNights;
        StringBuilder info = new StringBuilder();
        info.append(String.format("=== \u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0438\u044f \u043c\u043e\u0431\u043e\u0432 [%s] ===\n", difficulty.getDisplayName()));
        for (int night : keyNights = new int[]{1, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100}) {
            int mobCount = NightMobConfig.getMobCountForNight(night, difficulty);
            String waveType = NightMobConfig.isBigWaveNight(night) ? " (\u0411\u043e\u043b\u044c\u0448\u0430\u044f)" : "";
            info.append(String.format("\u041d\u043e\u0447\u044c %d: %d \u043c\u043e\u0431\u043e\u0432%s\n", night, mobCount, waveType));
        }
        return info.toString();
    }

    public static int getFinalNightTarget(DifficultyManager.Difficulty difficulty) {
        return FINAL_NIGHT_TARGETS.getOrDefault((Object)difficulty, 1500);
    }

    public static int getFirstNightBase(DifficultyManager.Difficulty difficulty) {
        return FIRST_NIGHT_BASE.getOrDefault((Object)difficulty, 10);
    }

    public static boolean validateProgression(DifficultyManager.Difficulty difficulty) {
        int firstNight = NightMobConfig.getMobCountForNight(1, difficulty);
        int finalNight = NightMobConfig.getMobCountForNight(100, difficulty);
        int expectedFinal = NightMobConfig.getFinalNightTarget(difficulty);
        double tolerance = (double)expectedFinal * 0.05;
        return (double)Math.abs(finalNight - expectedFinal) <= tolerance;
    }
}

