/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.NightTestContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class NightTestScreen
extends AbstractContainerScreen<NightTestContainer> {
    private static final int BUTTONS_PER_ROW = 10;
    private static final int BUTTON_WIDTH = 30;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 2;
    private int scrollOffset = 0;
    private final int maxScrollOffset;

    public NightTestScreen(NightTestContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.f_97726_ = 320;
        this.f_97727_ = 240;
        int totalRows = 10;
        int visibleRows = 8;
        this.maxScrollOffset = Math.max(0, totalRows - visibleRows);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.createNightButtons();
    }

    private void createNightButtons() {
        this.m_169413_();
        int startX = this.f_97735_ + 10;
        int startY = this.f_97736_ + 30;
        for (int night = 1; night <= 100; ++night) {
            int row = (night - 1) / 10;
            int col = (night - 1) % 10;
            int displayRow = row - this.scrollOffset;
            if (displayRow < 0 || displayRow >= 8) continue;
            int buttonX = startX + col * 32;
            int buttonY = startY + displayRow * 22;
            int nightNumber = night;
            String buttonText = this.getButtonText(night);
            Button nightButton = Button.m_253074_((Component)Component.m_237113_((String)buttonText), button -> this.startNight(nightNumber)).m_252987_(buttonX, buttonY, 30, 20).m_253136_();
            this.m_142416_((GuiEventListener)nightButton);
        }
        if (this.scrollOffset > 0) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25b2"), button -> this.scrollUp()).m_252987_(this.f_97735_ + this.f_97726_ - 30, this.f_97736_ + 10, 20, 15).m_253136_());
        }
        if (this.scrollOffset < this.maxScrollOffset) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25bc"), button -> this.scrollDown()).m_252987_(this.f_97735_ + this.f_97726_ - 30, this.f_97736_ + this.f_97727_ - 25, 20, 15).m_253136_());
        }
    }

    private String getButtonText(int night) {
        if (night % 10 == 0) {
            return "\u00a76" + night;
        }
        if (night % 7 == 0) {
            return "\u00a74" + night;
        }
        return "\u00a7f" + night;
    }

    private void startNight(int night) {
        this.m_7379_();
        if (this.f_96541_.f_91074_ != null && this.f_96541_.f_91074_.f_108617_ != null) {
            this.f_96541_.f_91074_.m_213846_((Component)Component.m_237113_((String)("\u00a7e[\u0422\u0415\u0421\u0422] \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c " + night + "-\u044e \u043d\u043e\u0447\u044c...")));
            this.f_96541_.f_91074_.f_108617_.m_246623_("survival test forcenight " + night);
        }
    }

    private void scrollUp() {
        if (this.scrollOffset > 0) {
            --this.scrollOffset;
            this.createNightButtons();
        }
    }

    private void scrollDown() {
        if (this.scrollOffset < this.maxScrollOffset) {
            ++this.scrollOffset;
            this.createNightButtons();
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            this.scrollUp();
        } else if (delta < 0.0) {
            this.scrollDown();
        }
        return true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -1072689136);
        guiGraphics.m_280509_(this.f_97735_ - 1, this.f_97736_ - 1, this.f_97735_ + this.f_97726_ + 1, this.f_97736_, -1);
        guiGraphics.m_280509_(this.f_97735_ - 1, this.f_97736_ + this.f_97727_, this.f_97735_ + this.f_97726_ + 1, this.f_97736_ + this.f_97727_ + 1, -1);
        guiGraphics.m_280509_(this.f_97735_ - 1, this.f_97736_, this.f_97735_, this.f_97736_ + this.f_97727_, -1);
        guiGraphics.m_280509_(this.f_97735_ + this.f_97726_, this.f_97736_, this.f_97735_ + this.f_97726_ + 1, this.f_97736_ + this.f_97727_, -1);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280137_(this.f_96547_, "\u00a76\u00a7l\u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0431\u043b\u043e\u043a \u043d\u043e\u0447\u0435\u0439", this.f_97726_ / 2, 6, 0xFFFFFF);
        guiGraphics.m_280137_(this.f_96547_, "\u00a77\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u0447\u044c \u0434\u043b\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430", this.f_97726_ / 2, 18, 0xAAAAAA);
        guiGraphics.m_280488_(this.f_96547_, "\u00a7f\u2022 \u041e\u0431\u044b\u0447\u043d\u044b\u0435", 10, this.f_97727_ - 40, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a74\u2022 \u041a\u0440\u043e\u0432\u0430\u0432\u044b\u0435 (x7)", 80, this.f_97727_ - 40, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, "\u00a76\u2022 \u0411\u043e\u043b\u044c\u0448\u0438\u0435 (x10)", 170, this.f_97727_ - 40, 0xFFFFFF);
        int startNight = this.scrollOffset * 10 + 1;
        int endNight = Math.min(100, (this.scrollOffset + 8) * 10);
        guiGraphics.m_280488_(this.f_96547_, "\u00a77\u041d\u043e\u0447\u0438 " + startNight + "-" + endNight, 10, this.f_97727_ - 28, 0xAAAAAA);
    }
}

