/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.phys.AABB;

public class PerformanceManager {
    public static final int MAX_MOBS_PER_CHUNK = Integer.MAX_VALUE;
    public static final int MAX_PARTICLES_PER_TICK = 15;
    public static final int CACHE_CLEANUP_INTERVAL = 45000;
    public static final int MOB_SEARCH_RADIUS = 80;
    private static final Map<String, Long> lastOperationTime = new ConcurrentHashMap<String, Long>();
    private static final Map<String, Object> operationCache = new ConcurrentHashMap<String, Object>();
    private static long lastCacheCleanup = 0L;

    public static boolean canPerformOperation(String operationKey, long cooldownMs) {
        long currentTime = System.currentTimeMillis();
        Long lastTime = lastOperationTime.get(operationKey);
        if (lastTime == null || currentTime - lastTime >= cooldownMs) {
            lastOperationTime.put(operationKey, currentTime);
            return true;
        }
        return false;
    }

    public static <T> T getCachedOrCompute(String key, Supplier<T> supplier, long cacheTimeMs) {
        PerformanceManager.cleanupCacheIfNeeded();
        CacheEntry entry = (CacheEntry)operationCache.get(key);
        long currentTime = System.currentTimeMillis();
        if (entry != null && currentTime - entry.timestamp < cacheTimeMs) {
            return entry.value;
        }
        T newValue = supplier.get();
        operationCache.put(key, new CacheEntry<T>(newValue, currentTime));
        return newValue;
    }

    public static int countMobsInArea(ServerLevel level, BlockPos center, int radius) {
        String cacheKey = "mobCount_" + center.m_123341_() + "_" + center.m_123343_() + "_" + radius;
        return PerformanceManager.getCachedOrCompute(cacheKey, () -> {
            AABB area = new AABB((double)(center.m_123341_() - radius), (double)(center.m_123342_() - 25), (double)(center.m_123343_() - radius), (double)(center.m_123341_() + radius), (double)(center.m_123342_() + 25), (double)(center.m_123343_() + radius));
            return level.m_45976_(Monster.class, area).size();
        }, 2000L);
    }

    public static boolean isMobLimitExceeded(ServerLevel level, BlockPos pos) {
        return false;
    }

    public static List<Monster> getNearbyMobs(ServerLevel level, BlockPos center, int radius, int maxCount) {
        String cacheKey = "nearbyMobs_" + center.m_123341_() + "_" + center.m_123343_() + "_" + radius;
        return PerformanceManager.getCachedOrCompute(cacheKey, () -> {
            AABB area = new AABB((double)(center.m_123341_() - radius), (double)(center.m_123342_() - 25), (double)(center.m_123343_() - radius), (double)(center.m_123341_() + radius), (double)(center.m_123342_() + 25), (double)(center.m_123343_() + radius));
            List allMobs = level.m_45976_(Monster.class, area);
            ArrayList<Monster> result = new ArrayList<Monster>();
            for (int i = 0; i < Math.min(maxCount, allMobs.size()); ++i) {
                result.add((Monster)allMobs.get(i));
            }
            return result;
        }, 1000L);
    }

    private static void cleanupCacheIfNeeded() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCacheCleanup > 45000L) {
            lastCacheCleanup = currentTime;
            lastOperationTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 45000L);
            operationCache.entrySet().removeIf(entry -> {
                if (entry.getValue() instanceof CacheEntry) {
                    CacheEntry cacheEntry = (CacheEntry)entry.getValue();
                    return currentTime - cacheEntry.timestamp > 45000L;
                }
                return false;
            });
        }
    }

    public static void clearCache() {
        lastOperationTime.clear();
        operationCache.clear();
        lastCacheCleanup = System.currentTimeMillis();
    }

    public static String getPerformanceStats() {
        return String.format("\u041a\u044d\u0448 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439: %d, \u041a\u044d\u0448 \u0434\u0430\u043d\u043d\u044b\u0445: %d", lastOperationTime.size(), operationCache.size());
    }

    public static boolean isServerUnderHighLoad() {
        return lastOperationTime.size() > 1000 || operationCache.size() > 500;
    }

    public static int getAdaptiveInterval(int baseInterval) {
        if (PerformanceManager.isServerUnderHighLoad()) {
            return baseInterval * 2;
        }
        return baseInterval;
    }

    private static class CacheEntry<T> {
        final T value;
        final long timestamp;

        CacheEntry(T value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }
}

