/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ProtectionZone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="citadelguard")
public class PersistentProtectionZoneManager
extends SavedData {
    private static final String DATA_NAME = "citadelguard_protection_zones";
    private final List<ProtectionZone> protectionZones = new ArrayList<ProtectionZone>();
    private int tickCounter = 0;
    private int initialParticleBoost = 0;

    public static PersistentProtectionZoneManager get(ServerLevel level) {
        return (PersistentProtectionZoneManager)level.m_8895_().m_164861_(PersistentProtectionZoneManager::load, PersistentProtectionZoneManager::new, DATA_NAME);
    }

    public static PersistentProtectionZoneManager load(CompoundTag tag) {
        PersistentProtectionZoneManager manager = new PersistentProtectionZoneManager();
        ListTag zonesList = tag.m_128437_("ProtectionZones", 10);
        for (int i = 0; i < zonesList.size(); ++i) {
            CompoundTag zoneTag = zonesList.m_128728_(i);
            int x = zoneTag.m_128451_("CenterX");
            int y = zoneTag.m_128451_("CenterY");
            int z = zoneTag.m_128451_("CenterZ");
            int radius = zoneTag.m_128451_("Radius");
            BlockPos centerPos = new BlockPos(x, y, z);
            ProtectionZone zone = new ProtectionZone(centerPos, radius);
            manager.protectionZones.add(zone);
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag zonesList = new ListTag();
        for (ProtectionZone zone : this.protectionZones) {
            CompoundTag zoneTag = new CompoundTag();
            BlockPos center = zone.getCenterBlock();
            zoneTag.m_128405_("CenterX", center.m_123341_());
            zoneTag.m_128405_("CenterY", center.m_123342_());
            zoneTag.m_128405_("CenterZ", center.m_123343_());
            zoneTag.m_128405_("Radius", zone.getRadius());
            zonesList.add((Object)zoneTag);
        }
        tag.m_128365_("ProtectionZones", (Tag)zonesList);
        return tag;
    }

    public void addProtectionZone(ProtectionZone zone) {
        this.protectionZones.add(zone);
        this.m_77762_();
    }

    public void removeProtectionZone(BlockPos centerPos) {
        this.protectionZones.removeIf(zone -> zone.getCenterBlock().equals((Object)centerPos));
        this.m_77762_();
    }

    public List<ProtectionZone> getProtectionZones() {
        return new ArrayList<ProtectionZone>(this.protectionZones);
    }

    public boolean hasProtectionZone(BlockPos pos) {
        return this.protectionZones.stream().anyMatch(zone -> zone.isInZone(pos));
    }

    public ProtectionZone getProtectionZone(BlockPos centerPos) {
        return this.protectionZones.stream().filter(zone -> zone.getCenterBlock().equals((Object)centerPos)).findFirst().orElse(null);
    }

    public void updateParticles(ServerLevel level) {
        for (ProtectionZone zone : this.protectionZones) {
            zone.spawnParticles((Level)level);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel level : event.getServer().m_129785_()) {
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(level);
            ++manager.tickCounter;
            boolean shouldUpdate = false;
            if (manager.initialParticleBoost > 0) {
                --manager.initialParticleBoost;
                shouldUpdate = manager.tickCounter % 5 == 0;
            } else {
                boolean bl = shouldUpdate = manager.tickCounter >= 10;
            }
            if (!shouldUpdate) continue;
            manager.updateParticles(level);
            if (manager.initialParticleBoost > 0) continue;
            manager.tickCounter = 0;
        }
    }

    public void activateParticleBoost() {
        this.initialParticleBoost = 200;
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(serverLevel);
            if (!manager.protectionZones.isEmpty()) {
                serverLevel.m_7654_().m_6846_().m_11314_().forEach(player -> player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Citadel Guard] \u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + manager.protectionZones.size() + " \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0437\u043e\u043d"))));
                manager.updateParticles(serverLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ServerLevel level = player2.m_284548_();
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(level);
            if (!manager.protectionZones.isEmpty()) {
                manager.activateParticleBoost();
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        manager.updateParticles(level);
                        player2.m_213846_((Component)Component.m_237113_((String)("\u00a7a[Citadel Guard] \u0427\u0430\u0441\u0442\u0438\u0446\u044b \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0437\u043e\u043d \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u044b (" + manager.protectionZones.size() + " \u0437\u043e\u043d)")));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }).start();
            }
        }
    }
}

