/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.DifficultyManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ProgressionManager
extends SavedData {
    private static final String DATA_NAME = "citadelguard_progression";
    private final Map<UUID, CompletedDifficulties> playerProgress = new HashMap<UUID, CompletedDifficulties>();

    public static ProgressionManager get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (ProgressionManager)storage.m_164861_(ProgressionManager::load, ProgressionManager::new, DATA_NAME);
    }

    public static ProgressionManager load(CompoundTag tag) {
        ProgressionManager manager = new ProgressionManager();
        CompoundTag playersTag = tag.m_128469_("players");
        for (String uuidString : playersTag.m_128431_()) {
            try {
                UUID playerUUID = UUID.fromString(uuidString);
                CompletedDifficulties progress = new CompletedDifficulties();
                progress.load(playersTag.m_128469_(uuidString));
                manager.playerProgress.put(playerUUID, progress);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return manager;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag playersTag = new CompoundTag();
        for (Map.Entry<UUID, CompletedDifficulties> entry : this.playerProgress.entrySet()) {
            playersTag.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().save());
        }
        tag.m_128365_("players", (Tag)playersTag);
        return tag;
    }

    public boolean isDifficultyUnlocked(UUID playerUUID, DifficultyManager.Difficulty difficulty) {
        if (difficulty == DifficultyManager.Difficulty.TEST) {
            return true;
        }
        CompletedDifficulties progress = this.playerProgress.getOrDefault(playerUUID, new CompletedDifficulties());
        switch (difficulty) {
            case NOVICE: {
                return true;
            }
            case EXPERIENCED: {
                return progress.noviceCompleted;
            }
            case MONSTER: {
                return progress.experiencedCompleted;
            }
            case DEATH: {
                return progress.monsterCompleted;
            }
        }
        return false;
    }

    public void completeDifficulty(UUID playerUUID, DifficultyManager.Difficulty difficulty) {
        CompletedDifficulties progress = this.playerProgress.computeIfAbsent(playerUUID, k -> new CompletedDifficulties());
        switch (difficulty) {
            case NOVICE: {
                if (progress.noviceCompleted) break;
                progress.noviceCompleted = true;
                this.m_77762_();
                break;
            }
            case EXPERIENCED: {
                if (progress.experiencedCompleted) break;
                progress.experiencedCompleted = true;
                this.m_77762_();
                break;
            }
            case MONSTER: {
                if (progress.monsterCompleted) break;
                progress.monsterCompleted = true;
                this.m_77762_();
                break;
            }
            case DEATH: {
                if (progress.deathCompleted) break;
                progress.deathCompleted = true;
                this.m_77762_();
            }
        }
    }

    public CompletedDifficulties getPlayerProgress(UUID playerUUID) {
        return this.playerProgress.getOrDefault(playerUUID, new CompletedDifficulties());
    }

    public void showAvailableDifficulties(ServerPlayer player) {
        String status;
        UUID playerUUID = player.m_20148_();
        CompletedDifficulties progress = this.getPlayerProgress(playerUUID);
        player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l=== \u0414\u041e\u0421\u0422\u0423\u041f\u041d\u042b\u0415 \u0423\u0420\u041e\u0412\u041d\u0418 \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u0418 ==="));
        if (this.isDifficultyUnlocked(playerUUID, DifficultyManager.Difficulty.NOVICE)) {
            status = progress.noviceCompleted ? "\u00a7a\u2713 \u041f\u0420\u041e\u0419\u0414\u0415\u041d" : "\u00a7e\u25ef \u0414\u041e\u0421\u0422\u0423\u041f\u0415\u041d";
            player.m_213846_((Component)Component.m_237113_((String)("\u00a771. \u00a7f\ud83d\udfe2 \u041d\u043e\u0432\u0438\u0447\u043e\u043a " + status)));
        }
        if (this.isDifficultyUnlocked(playerUUID, DifficultyManager.Difficulty.EXPERIENCED)) {
            status = progress.experiencedCompleted ? "\u00a7a\u2713 \u041f\u0420\u041e\u0419\u0414\u0415\u041d" : "\u00a7e\u25ef \u0414\u041e\u0421\u0422\u0423\u041f\u0415\u041d";
            player.m_213846_((Component)Component.m_237113_((String)("\u00a772. \u00a7f\ud83d\udfe1 \u041e\u043f\u044b\u0442\u043d\u044b\u0439 " + status)));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a772. \u00a78\ud83d\udd12 \u041e\u043f\u044b\u0442\u043d\u044b\u0439 \u00a7c\u2717 \u0417\u0410\u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u0410\u041d \u00a77(\u043f\u0440\u043e\u0439\u0434\u0438\u0442\u0435 \u041d\u043e\u0432\u0438\u0447\u043e\u043a)"));
        }
        if (this.isDifficultyUnlocked(playerUUID, DifficultyManager.Difficulty.MONSTER)) {
            status = progress.monsterCompleted ? "\u00a7a\u2713 \u041f\u0420\u041e\u0419\u0414\u0415\u041d" : "\u00a7e\u25ef \u0414\u041e\u0421\u0422\u0423\u041f\u0415\u041d";
            player.m_213846_((Component)Component.m_237113_((String)("\u00a773. \u00a7f\ud83d\udd34 \u041c\u043e\u043d\u0441\u0442\u0440 " + status)));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a773. \u00a78\ud83d\udd12 \u041c\u043e\u043d\u0441\u0442\u0440 \u00a7c\u2717 \u0417\u0410\u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u0410\u041d \u00a77(\u043f\u0440\u043e\u0439\u0434\u0438\u0442\u0435 \u041e\u043f\u044b\u0442\u043d\u044b\u0439)"));
        }
        if (this.isDifficultyUnlocked(playerUUID, DifficultyManager.Difficulty.DEATH)) {
            status = progress.deathCompleted ? "\u00a7a\u2713 \u041f\u0420\u041e\u0419\u0414\u0415\u041d" : "\u00a7e\u25ef \u0414\u041e\u0421\u0422\u0423\u041f\u0415\u041d";
            player.m_213846_((Component)Component.m_237113_((String)("\u00a774. \u00a7f\u26ab \u0421\u043c\u0435\u0440\u0442\u044c " + status)));
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a774. \u00a78\ud83d\udd12 \u0421\u043c\u0435\u0440\u0442\u044c \u00a7c\u2717 \u0417\u0410\u0411\u041b\u041e\u041a\u0418\u0420\u041e\u0412\u0410\u041d \u00a77(\u043f\u0440\u043e\u0439\u0434\u0438\u0442\u0435 \u041c\u043e\u043d\u0441\u0442\u0440)"));
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a775. \u00a7f\ud83e\uddea \u0422\u0435\u0441\u0442 \u00a7b\u25ef \u0412\u0421\u0415\u0413\u0414\u0410 \u0414\u041e\u0421\u0422\u0423\u041f\u0415\u041d"));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l================================"));
        if (!progress.noviceCompleted) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\ud83d\udca1 \u0421\u043e\u0432\u0435\u0442: \u041d\u0430\u0447\u043d\u0438\u0442\u0435 \u0441 \u0443\u0440\u043e\u0432\u043d\u044f '\u041d\u043e\u0432\u0438\u0447\u043e\u043a' \u0434\u043b\u044f \u0438\u0437\u0443\u0447\u0435\u043d\u0438\u044f \u043c\u0435\u0445\u0430\u043d\u0438\u043a!"));
        }
    }

    public boolean canSelectDifficulty(UUID playerUUID, DifficultyManager.Difficulty difficulty) {
        return this.isDifficultyUnlocked(playerUUID, difficulty);
    }

    public void resetPlayerProgress(UUID playerUUID) {
        this.playerProgress.remove(playerUUID);
        this.m_77762_();
    }

    public void unlockAllDifficulties(UUID playerUUID) {
        CompletedDifficulties progress = this.playerProgress.computeIfAbsent(playerUUID, k -> new CompletedDifficulties());
        progress.noviceCompleted = true;
        progress.experiencedCompleted = true;
        progress.monsterCompleted = true;
        progress.deathCompleted = true;
        this.m_77762_();
    }

    public static class CompletedDifficulties {
        public boolean noviceCompleted = false;
        public boolean experiencedCompleted = false;
        public boolean monsterCompleted = false;
        public boolean deathCompleted = false;

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("novice", this.noviceCompleted);
            tag.m_128379_("experienced", this.experiencedCompleted);
            tag.m_128379_("monster", this.monsterCompleted);
            tag.m_128379_("death", this.deathCompleted);
            return tag;
        }

        public void load(CompoundTag tag) {
            this.noviceCompleted = tag.m_128471_("novice");
            this.experiencedCompleted = tag.m_128471_("experienced");
            this.monsterCompleted = tag.m_128471_("monster");
            this.deathCompleted = tag.m_128471_("death");
        }
    }
}

