/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ProtectionZone {
    private final BlockPos centerBlock;
    private int radius;
    private int radiusSquared;

    public ProtectionZone(BlockPos centerBlock) {
        this.centerBlock = centerBlock;
        this.radius = 10;
        this.radiusSquared = this.radius * this.radius;
    }

    public ProtectionZone(BlockPos centerBlock, int radius) {
        this.centerBlock = centerBlock;
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    public BlockPos getCenterBlock() {
        return this.centerBlock;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getZoneRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    public boolean isInZone(BlockPos pos) {
        return this.isInSquareZone(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public boolean isInZone(int x, int y, int z) {
        return this.isInSquareZone(x, y, z);
    }

    private boolean isInSquareZone(int x, int y, int z) {
        int centerX = this.centerBlock.m_123341_();
        int centerZ = this.centerBlock.m_123343_();
        return x >= centerX - this.radius && x <= centerX + this.radius && z >= centerZ - this.radius && z <= centerZ + this.radius;
    }

    public boolean isInProtectedZone(BlockPos pos) {
        return this.isInZone(pos);
    }

    public boolean canMobSpawn(BlockPos pos, boolean isHostile) {
        return !this.isInZone(pos);
    }

    public void createZone(Level level) {
    }

    public void removeZone(Level level) {
    }

    public void expandZone(Level level, int radiusIncrease) {
        this.radius += radiusIncrease;
        this.radiusSquared = this.radius * this.radius;
    }

    public void spawnParticles(Level level) {
        if (level.f_46443_) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int centerX = this.centerBlock.m_123341_();
            int centerY = this.centerBlock.m_123342_();
            int centerZ = this.centerBlock.m_123343_();
            this.spawnBorderParticles(serverLevel, centerX, centerY, centerZ);
            this.spawnCornerMarkers(serverLevel, centerX, centerY, centerZ);
        }
    }

    public void spawnIntenseRedstoneParticles(Level level) {
        if (level.f_46443_) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int centerX = this.centerBlock.m_123341_();
            int centerY = this.centerBlock.m_123342_();
            int centerZ = this.centerBlock.m_123343_();
            int zoneRadius = this.radius;
            int particleCount = 0;
            int maxParticlesPerTick = 150;
            for (int x = centerX - zoneRadius; x <= centerX + zoneRadius && particleCount < maxParticlesPerTick; ++x) {
                for (int z = centerZ - zoneRadius; z <= centerZ + zoneRadius && particleCount < maxParticlesPerTick; particleCount += 4, ++z) {
                    int surfaceY = this.getSurfaceHeight(serverLevel, x, z);
                    double particleX = (double)x + 0.3 + serverLevel.f_46441_.m_188500_() * 0.4;
                    double particleY = (double)surfaceY + 0.2 + serverLevel.f_46441_.m_188500_() * 0.3;
                    double particleZ = (double)z + 0.3 + serverLevel.f_46441_.m_188500_() * 0.4;
                    DustParticleOptions redDust = new DustParticleOptions(Vec3.m_82501_((int)0xFF0000).m_252839_(), 1.0f);
                    serverLevel.m_8767_((ParticleOptions)redDust, particleX, particleY, particleZ, 4, 0.15, 0.1, 0.15, 0.0);
                }
            }
            this.spawnBorderParticles(serverLevel, centerX, centerY, centerZ);
            this.spawnCornerMarkers(serverLevel, centerX, centerY, centerZ);
        }
    }

    private void spawnBorderParticles(ServerLevel serverLevel, int centerX, int centerY, int centerZ) {
        int z;
        double particleY;
        double particleZ;
        double particleX;
        int x;
        int zoneRadius = this.radius;
        int minX = centerX - zoneRadius;
        int maxX = centerX + zoneRadius;
        int minZ = centerZ - zoneRadius;
        int maxZ = centerZ + zoneRadius;
        for (x = minX; x <= maxX; ++x) {
            particleX = (double)x + 0.5;
            particleZ = (double)minZ + 0.5;
            particleY = (double)this.getSurfaceHeight(serverLevel, x, minZ) + 0.5;
            this.spawnRedstoneParticles(serverLevel, particleX, particleY, particleZ);
        }
        for (x = minX; x <= maxX; ++x) {
            particleX = (double)x + 0.5;
            particleZ = (double)maxZ + 0.5;
            particleY = (double)this.getSurfaceHeight(serverLevel, x, maxZ) + 0.5;
            this.spawnRedstoneParticles(serverLevel, particleX, particleY, particleZ);
        }
        for (z = minZ + 1; z < maxZ; ++z) {
            particleX = (double)minX + 0.5;
            particleZ = (double)z + 0.5;
            particleY = (double)this.getSurfaceHeight(serverLevel, minX, z) + 0.5;
            this.spawnRedstoneParticles(serverLevel, particleX, particleY, particleZ);
        }
        for (z = minZ + 1; z < maxZ; ++z) {
            particleX = (double)maxX + 0.5;
            particleZ = (double)z + 0.5;
            particleY = (double)this.getSurfaceHeight(serverLevel, maxX, z) + 0.5;
            this.spawnRedstoneParticles(serverLevel, particleX, particleY, particleZ);
        }
        this.spawnCornerRedstoneMarkers(serverLevel, minX, maxX, minZ, maxZ);
    }

    private void spawnRedstoneParticles(ServerLevel serverLevel, double x, double y, double z) {
        DustParticleOptions redDust = new DustParticleOptions(Vec3.m_82501_((int)0xFF0000).m_252839_(), 1.0f);
        serverLevel.m_8767_((ParticleOptions)redDust, x, y, z, 5, 0.1, 0.1, 0.1, 0.0);
    }

    private void spawnCornerRedstoneMarkers(ServerLevel serverLevel, int minX, int maxX, int minZ, int maxZ) {
        int[][] corners;
        for (int[] corner : corners = new int[][]{{minX, minZ}, {maxX, minZ}, {maxX, maxZ}, {minX, maxZ}}) {
            int x = corner[0];
            int z = corner[1];
            double particleX = (double)x + 0.5;
            double particleZ = (double)z + 0.5;
            double particleY = (double)this.getSurfaceHeight(serverLevel, x, z) + 0.5;
            for (int height = 0; height < 2; ++height) {
                double currentY = particleY + (double)height * 0.5;
                DustParticleOptions redDust = new DustParticleOptions(Vec3.m_82501_((int)0xFF0000).m_252839_(), 1.0f);
                serverLevel.m_8767_((ParticleOptions)redDust, particleX, currentY, particleZ, 8, 0.15, 0.1, 0.15, 0.0);
            }
        }
    }

    private void spawnCornerMarkers(ServerLevel serverLevel, int centerX, int centerY, int centerZ) {
    }

    private int getSurfaceHeight(ServerLevel level, int x, int z) {
        for (int y = level.m_151558_() - 1; y >= level.m_141937_(); --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (level.m_8055_(pos).m_60795_() || !level.m_8055_(pos).m_60804_((BlockGetter)level, pos)) continue;
            return y + 1;
        }
        return this.centerBlock.m_123342_();
    }

    public void spawnIntenseParticles(Level level) {
        if (level.f_46443_) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int centerX = this.centerBlock.m_123341_();
            int centerY = this.centerBlock.m_123342_();
            int centerZ = this.centerBlock.m_123343_();
            this.spawnBorderParticles(serverLevel, centerX, centerY, centerZ);
            int zoneRadius = this.radius;
            int particleCount = 0;
            int maxParticles = 50;
            for (int x = centerX - zoneRadius; x <= centerX + zoneRadius && particleCount < maxParticles; x += 2) {
                for (int z = centerZ - zoneRadius; z <= centerZ + zoneRadius && particleCount < maxParticles; z += 2) {
                    if (!(serverLevel.f_46441_.m_188501_() < 0.3f)) continue;
                    int surfaceY = this.getSurfaceHeight(serverLevel, x, z);
                    double particleX = (double)x + 0.5;
                    double particleY = (double)surfaceY + 0.3;
                    double particleZ = (double)z + 0.5;
                    DustParticleOptions redDust = new DustParticleOptions(Vec3.m_82501_((int)0xFF0000).m_252839_(), 1.0f);
                    serverLevel.m_8767_((ParticleOptions)redDust, particleX, particleY, particleZ, 3, 0.1, 0.1, 0.1, 0.0);
                    particleCount += 3;
                }
            }
        }
    }

    public void handleCreeperExplosion(Level level, BlockPos explosionPos) {
        if (this.isInZone(explosionPos)) {
            // empty if block
        }
    }
}

