/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ProtectionZoneParticleManager {
    public static void spawnRedstoneSquareBorder(Level level, BlockPos centerPos) {
        int z;
        int x;
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int centerX = centerPos.m_123341_();
        int centerZ = centerPos.m_123343_();
        int zoneRadius = 10;
        int minX = centerX - zoneRadius;
        int maxX = centerX + zoneRadius;
        int minZ = centerZ - zoneRadius;
        int maxZ = centerZ + zoneRadius;
        for (x = minX; x <= maxX; ++x) {
            ProtectionZoneParticleManager.spawnRedstoneParticleColumn(serverLevel, x, minZ);
        }
        for (x = minX; x <= maxX; ++x) {
            ProtectionZoneParticleManager.spawnRedstoneParticleColumn(serverLevel, x, maxZ);
        }
        for (z = minZ + 1; z < maxZ; ++z) {
            ProtectionZoneParticleManager.spawnRedstoneParticleColumn(serverLevel, minX, z);
        }
        for (z = minZ + 1; z < maxZ; ++z) {
            ProtectionZoneParticleManager.spawnRedstoneParticleColumn(serverLevel, maxX, z);
        }
    }

    private static void spawnRedstoneParticleColumn(ServerLevel serverLevel, int x, int z) {
        int surfaceY = ProtectionZoneParticleManager.getSurfaceHeight(serverLevel, x, z);
        double particleX = (double)x + 0.5;
        double particleZ = (double)z + 0.5;
        double particleY = (double)surfaceY + 0.5;
        DustParticleOptions redDust = new DustParticleOptions(Vec3.m_82501_((int)0xFF0000).m_252839_(), 1.0f);
        serverLevel.m_8767_((ParticleOptions)redDust, particleX, particleY, particleZ, 4, 0.1, 0.1, 0.1, 0.0);
    }

    private static int getSurfaceHeight(ServerLevel level, int x, int z) {
        for (int y = level.m_151558_() - 1; y >= level.m_141937_(); --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (level.m_8055_(pos).m_60795_() || !level.m_8055_(pos).m_60804_((BlockGetter)level, pos)) continue;
            return y + 1;
        }
        return level.m_5736_();
    }

    public static void spawnFilledRedstoneSquare(Level level, BlockPos centerPos) {
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int centerX = centerPos.m_123341_();
        int centerZ = centerPos.m_123343_();
        int zoneRadius = 10;
        int particleCount = 0;
        int maxParticles = 200;
        for (int x = centerX - zoneRadius; x <= centerX + zoneRadius && particleCount < maxParticles; ++x) {
            for (int z = centerZ - zoneRadius; z <= centerZ + zoneRadius && particleCount < maxParticles; ++z) {
                if (!(serverLevel.f_46441_.m_188501_() < 0.3f)) continue;
                int surfaceY = ProtectionZoneParticleManager.getSurfaceHeight(serverLevel, x, z);
                double particleX = (double)x + 0.2 + serverLevel.f_46441_.m_188500_() * 0.6;
                double particleY = (double)surfaceY + 0.1 + serverLevel.f_46441_.m_188500_() * 0.4;
                double particleZ = (double)z + 0.2 + serverLevel.f_46441_.m_188500_() * 0.6;
                DustParticleOptions redDust = new DustParticleOptions(Vec3.m_82501_((int)0xFF0000).m_252839_(), 1.0f);
                serverLevel.m_8767_((ParticleOptions)redDust, particleX, particleY, particleZ, 3, 0.1, 0.1, 0.1, 0.0);
                particleCount += 3;
            }
        }
        ProtectionZoneParticleManager.spawnRedstoneSquareBorder(level, centerPos);
    }
}

