/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.BlockHealthData;
import com.example.examplemod.ExampleMod;
import com.example.examplemod.HealthBoostBlock;
import com.example.examplemod.RepairBlockContainer;
import com.example.examplemod.SurvivalManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RepairBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final int INVENTORY_SIZE = 9;
    private static final int REPAIR_INTERVAL = 100;
    private static final int RESOURCE_COST = 5;
    private static final int HEALTH_RESTORE = 5;
    private static final int MAX_RANGE = 20;
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            RepairBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    private int repairTimer = 0;

    public RepairBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ExampleMod.REPAIR_BLOCK_ENTITY.get(), pos, blockState);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"\u0411\u043b\u043e\u043a \u0440\u0435\u043c\u043e\u043d\u0442\u0430");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new RepairBlockContainer(containerId, playerInventory, this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RepairBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++blockEntity.repairTimer;
            if (blockEntity.repairTimer >= 100) {
                blockEntity.repairTimer = 0;
                blockEntity.performRepair(serverLevel);
            }
        }
    }

    private void performRepair(ServerLevel level) {
        ItemStack resourceStack = this.findRepairResource();
        if (resourceStack.m_41619_() || resourceStack.m_41613_() < 5) {
            return;
        }
        List<BlockPos> blocksToRepair = this.findBlocksToRepair(level);
        if (blocksToRepair.isEmpty()) {
            return;
        }
        boolean repairPerformed = false;
        for (BlockPos repairPos : blocksToRepair) {
            if (!this.repairBlock(level, repairPos)) continue;
            repairPerformed = true;
            break;
        }
        if (repairPerformed) {
            resourceStack.m_41774_(5);
            this.m_6596_();
            this.showRepairEffect(level);
        }
    }

    private ItemStack findRepairResource() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || !this.isValidRepairResource(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private boolean isValidRepairResource(ItemStack stack) {
        return !stack.m_41619_();
    }

    private List<BlockPos> findBlocksToRepair(ServerLevel level) {
        ArrayList<BlockPos> blocksToRepair = new ArrayList<BlockPos>();
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager != null) {
            for (BlockPos survivalPos : manager.survivalBlocks) {
                if (!(this.m_58899_().m_123331_((Vec3i)survivalPos) <= 400.0) || !this.needsRepair(level, survivalPos)) continue;
                blocksToRepair.add(survivalPos);
            }
        }
        for (int x = -20; x <= 20; ++x) {
            for (int y = -20; y <= 20; ++y) {
                for (int z = -20; z <= 20; ++z) {
                    BlockPos checkPos = this.m_58899_().m_7918_(x, y, z);
                    if (!(level.m_8055_(checkPos).m_60734_() instanceof HealthBoostBlock) || !this.needsRepair(level, checkPos)) continue;
                    blocksToRepair.add(checkPos);
                }
            }
        }
        return blocksToRepair;
    }

    private boolean needsRepair(ServerLevel level, BlockPos pos) {
        int maxHealth;
        int currentHealth = BlockHealthData.getHealth(pos);
        return currentHealth < (maxHealth = BlockHealthData.getMaxHealth(pos));
    }

    private boolean repairBlock(ServerLevel level, BlockPos pos) {
        int maxHealth;
        int currentHealth = BlockHealthData.getHealth(pos);
        if (currentHealth < (maxHealth = BlockHealthData.getMaxHealth(pos))) {
            BlockHealthData.healBlock(pos, 5);
            int newHealth = BlockHealthData.getHealth(pos);
            for (ServerPlayer player : level.m_6907_()) {
                if (!(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= 100.0)) continue;
                player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a7a[\u0420\u0415\u041c\u041e\u041d\u0422] \u0411\u043b\u043e\u043a \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d: %d/%d HP", newHealth, maxHealth)));
            }
            return true;
        }
        return false;
    }

    private void showRepairEffect(ServerLevel level) {
        double x = (double)this.m_58899_().m_123341_() + 0.5;
        double y = (double)this.m_58899_().m_123342_() + 1.0;
        double z = (double)this.m_58899_().m_123343_() + 0.5;
        level.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 10, 0.5, 0.5, 0.5, 0.1);
    }

    public boolean isInValidRange() {
        ServerLevel serverLevel;
        SurvivalManager manager;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel && (manager = SurvivalManager.get((Level)(serverLevel = (ServerLevel)level))) != null) {
            for (BlockPos survivalPos : manager.survivalBlocks) {
                if (!(this.m_58899_().m_123331_((Vec3i)survivalPos) <= 400.0)) continue;
                return true;
            }
        }
        return false;
    }

    public int getResourceCount() {
        int totalResources = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || !this.isValidRepairResource(stack)) continue;
            totalResources += stack.m_41613_();
        }
        return totalResources;
    }

    public void dropContents() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.repairTimer = tag.m_128451_("repairTimer");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("repairTimer", this.repairTimer);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

