/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class ScreenNotificationManager {
    private static final Map<String, Thread> activeNotifications = new ConcurrentHashMap<String, Thread>();

    public static void showDifficultySelection(ServerLevel level) {
        MutableComponent title = Component.m_237113_((String)"\u00a76\u00a7l\u2699 \u0412\u042b\u0411\u041e\u0420 \u0421\u041b\u041e\u0416\u041d\u041e\u0421\u0422\u0418 \u2699");
        MutableComponent subtitle = Component.m_237113_((String)"\u00a7e1-\u041d\u043e\u0432\u0438\u0447\u043e\u043a \u00a7f| \u00a7e2-\u041e\u043f\u044b\u0442\u043d\u044b\u0439 \u00a7f| \u00a7c3-\u041c\u043e\u043d\u0441\u0442\u0440 \u00a7f| \u00a744-\u0421\u043c\u0435\u0440\u0442\u044c \u00a7f| \u00a7d5-\u0422\u0435\u0441\u0442");
        for (ServerPlayer player : level.m_6907_()) {
            String playerId = player.m_20148_().toString();
            ScreenNotificationManager.cancelNotification(playerId);
            ScreenNotificationManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 10, 200, 20);
            Thread notificationThread = new Thread(() -> {
                try {
                    Thread.sleep(10000L);
                    if (!Thread.currentThread().isInterrupted()) {
                        ScreenNotificationManager.clearPlayerNotification(player);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            activeNotifications.put(playerId, notificationThread);
            notificationThread.start();
        }
    }

    public static void hideDifficultySelection(ServerLevel level) {
        for (ServerPlayer player : level.m_6907_()) {
            String playerId = player.m_20148_().toString();
            ScreenNotificationManager.cancelNotification(playerId);
            ScreenNotificationManager.clearPlayerNotification(player);
        }
    }

    public static void showNotification(ServerLevel level, String titleText, String subtitleText) {
        MutableComponent title = Component.m_237113_((String)titleText);
        MutableComponent subtitle = Component.m_237113_((String)subtitleText);
        for (ServerPlayer player : level.m_6907_()) {
            String playerId = player.m_20148_().toString();
            ScreenNotificationManager.cancelNotification(playerId);
            ScreenNotificationManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 10, 60, 10);
            Thread notificationThread = new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                    if (!Thread.currentThread().isInterrupted()) {
                        ScreenNotificationManager.clearPlayerNotification(player);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            activeNotifications.put(playerId, notificationThread);
            notificationThread.start();
        }
    }

    public static void showNotificationToPlayer(ServerPlayer player, String titleText, String subtitleText) {
        MutableComponent title = Component.m_237113_((String)titleText);
        MutableComponent subtitle = Component.m_237113_((String)subtitleText);
        String playerId = player.m_20148_().toString();
        ScreenNotificationManager.cancelNotification(playerId);
        ScreenNotificationManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 10, 60, 10);
        Thread notificationThread = new Thread(() -> {
            try {
                Thread.sleep(3000L);
                if (!Thread.currentThread().isInterrupted()) {
                    ScreenNotificationManager.clearPlayerNotification(player);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        activeNotifications.put(playerId, notificationThread);
        notificationThread.start();
    }

    public static void showWaveNotification(ServerLevel level, int day, boolean isBigWave, boolean isApocalypse) {
        String subtitleText;
        String titleText;
        if (isApocalypse) {
            titleText = "\u00a74\u00a7l\ud83d\udc80 \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0422\u0418\u0427\u0415\u0421\u041a\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + " \ud83d\udc80";
            subtitleText = "\u00a7c\u00a7l\u0411\u0415\u0421\u041a\u041e\u041d\u0415\u0427\u041d\u0410\u042f \u041d\u041e\u0427\u042c \u041d\u0410\u0427\u0410\u041b\u0410\u0421\u042c!";
        } else if (isBigWave) {
            titleText = "\u00a75\u00a7l\u26a1 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + " \u26a1";
            subtitleText = "\u00a7e\u00a7l\u0412\u0420\u0415\u041c\u042f \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d\u041e! \u041f\u043e\u0431\u0435\u0434\u0438\u0442\u0435 \u0432\u0441\u0435\u0445 \u043c\u043e\u0431\u043e\u0432!";
        } else {
            titleText = "\u00a7c\u00a7l\u0412\u041e\u041b\u041d\u0410 " + day + " \u041d\u0410\u0427\u0410\u041b\u0410\u0421\u042c";
            subtitleText = "\u00a7e\u041f\u0440\u0438\u0433\u043e\u0442\u043e\u0432\u044c\u0442\u0435\u0441\u044c \u043a \u0430\u0442\u0430\u043a\u0435 \u043c\u043e\u0431\u043e\u0432!";
        }
        ScreenNotificationManager.showNotification(level, titleText, subtitleText);
    }

    public static void showWaveComplete(ServerLevel level, int day, int duration, boolean isBigWave) {
        String subtitleText;
        String titleText;
        if (isBigWave) {
            titleText = "\u00a7a\u00a7l\ud83c\udf89 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 \u041f\u041e\u0411\u0415\u0416\u0414\u0415\u041d\u0410! \ud83c\udf89";
            subtitleText = "\u00a7e\u0412\u043e\u043b\u043d\u0430 " + day + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0437\u0430 \u00a7a" + duration + " \u00a7e\u0441\u0435\u043a\u0443\u043d\u0434! \u00a7a\u0412\u0440\u0435\u043c\u044f \u0442\u0435\u0447\u0435\u0442 \u0441\u043d\u043e\u0432\u0430!";
        } else {
            titleText = "\u00a7a\u00a7l\u2713 \u0412\u041e\u041b\u041d\u0410 \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d\u0410";
            subtitleText = "\u00a7e\u0412\u043e\u043b\u043d\u0430 " + day + " \u043f\u043e\u0431\u0435\u0436\u0434\u0435\u043d\u0430 \u0437\u0430 \u00a7a" + duration + " \u00a7e\u0441\u0435\u043a\u0443\u043d\u0434!";
        }
        ScreenNotificationManager.showNotification(level, titleText, subtitleText);
    }

    public static void showMilestone(ServerLevel level, int day) {
        String titleText = "\u00a76\u00a7l\ud83c\udfc6 \u0412\u0410\u0416\u041d\u0410\u042f \u0412\u0415\u0425\u0410 \ud83c\udfc6";
        String subtitleText = ScreenNotificationManager.getMilestoneMessage(day);
        if (subtitleText != null) {
            ScreenNotificationManager.showNotification(level, titleText, subtitleText);
        }
    }

    public static void showBuildingNotification(ServerLevel level, String message) {
        String titleText = "\u00a76\u00a7l\ud83c\udfd7 \u0421\u0422\u0420\u041e\u0418\u0422\u0415\u041b\u042c\u0421\u0422\u0412\u041e \ud83c\udfd7";
        String subtitleText = message;
        ScreenNotificationManager.showNotification(level, titleText, subtitleText);
    }

    public static void showMobAttackNotification(ServerPlayer player, String message) {
        String titleText = "\u00a7c\u00a7l\u2694 \u0410\u0422\u0410\u041a\u0410 \u041c\u041e\u0411\u041e\u0412 \u2694";
        String subtitleText = message;
        ScreenNotificationManager.showNotificationToPlayer(player, titleText, subtitleText);
    }

    private static void cancelNotification(String playerId) {
        Thread activeThread = activeNotifications.get(playerId);
        if (activeThread != null && activeThread.isAlive()) {
            activeThread.interrupt();
            activeNotifications.remove(playerId);
        }
    }

    private static void clearPlayerNotification(ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)new ClientboundClearTitlesPacket(false));
    }

    private static void sendTitleToPlayer(ServerPlayer player, Component title, Component subtitle, int fadeIn, int stay, int fadeOut) {
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut));
        if (title != null) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(title));
        }
        if (subtitle != null) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket(subtitle));
        }
    }

    private static String getMilestoneMessage(int day) {
        return switch (day) {
            case 10 -> "\u00a7e10 \u0434\u043d\u0435\u0439 \u0432\u044b\u0436\u0438\u0442\u043e! \u0421\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0443\u0432\u0435\u043b\u0438\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f!";
            case 25 -> "\u00a7e\u0427\u0435\u0442\u0432\u0435\u0440\u0442\u044c \u043f\u0443\u0442\u0438 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430! (25/100 \u0434\u043d\u0435\u0439)";
            case 50 -> "\u00a7e\u041f\u043e\u043b\u043e\u0432\u0438\u043d\u0430 \u043f\u0443\u0442\u0438! \u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c 50 \u0434\u043d\u0435\u0439!";
            case 75 -> "\u00a7c\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0447\u0435\u0442\u0432\u0435\u0440\u0442\u044c! \u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c 25 \u0434\u043d\u0435\u0439!";
            case 90 -> "\u00a74\u0424\u0438\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0434\u0435\u043a\u0430\u0434\u0430! \u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c 10 \u0434\u043d\u0435\u0439!";
            case 99 -> "\u00a74\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0434\u0435\u043d\u044c! \u0417\u0430\u0432\u0442\u0440\u0430 - \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421!";
            default -> null;
        };
    }

    public static void clearAllNotifications() {
        for (Thread thread : activeNotifications.values()) {
            if (!thread.isAlive()) continue;
            thread.interrupt();
        }
        activeNotifications.clear();
    }
}

