/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ClientIconRenderer;
import com.example.examplemod.IconNotificationManager;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ShowIconPacket {
    private final IconNotificationManager.IconType iconType;
    private final int durationSeconds;

    public ShowIconPacket(IconNotificationManager.IconType iconType, int durationSeconds) {
        this.iconType = iconType;
        this.durationSeconds = durationSeconds;
    }

    public static void encode(ShowIconPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.iconType.ordinal());
        buffer.writeInt(packet.durationSeconds);
    }

    public static ShowIconPacket decode(FriendlyByteBuf buffer) {
        int iconTypeOrdinal = buffer.readInt();
        int durationSeconds = buffer.readInt();
        IconNotificationManager.IconType iconType = IconNotificationManager.IconType.values()[iconTypeOrdinal];
        return new ShowIconPacket(iconType, durationSeconds);
    }

    public static void handle(ShowIconPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> ClientIconRenderer.showIcon(packet.iconType, packet.durationSeconds));
        context.setPacketHandled(true);
    }
}

