/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.IconNotificationManager;
import com.example.examplemod.SurvivalBlock;
import com.example.examplemod.SurvivalManager;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SmartMobBehavior {
    private static final Random random = new Random();

    public static void improveSkeletonBehavior(Skeleton skeleton, ServerLevel level) {
        double distance;
        if (skeleton.m_5448_() != null) {
            return;
        }
        BlockPos targetBlock = SmartMobBehavior.findNearestSurvivalBlock((Monster)skeleton, level);
        if (targetBlock != null && (distance = skeleton.m_20275_((double)targetBlock.m_123341_(), (double)targetBlock.m_123342_(), (double)targetBlock.m_123343_())) <= 400.0) {
            skeleton.m_21563_().m_24946_((double)targetBlock.m_123341_() + 0.5, (double)targetBlock.m_123342_() + 0.5, (double)targetBlock.m_123343_() + 0.5);
            if (skeleton.f_19797_ % 40 == 0) {
                SmartMobBehavior.shootArrowAtBlock(skeleton, targetBlock, level);
            }
        }
    }

    private static void shootArrowAtBlock(Skeleton skeleton, BlockPos targetBlock, ServerLevel level) {
        Arrow arrow = new Arrow((Level)level, (LivingEntity)skeleton);
        double deltaX = (double)targetBlock.m_123341_() + 0.5 - skeleton.m_20185_();
        double deltaY = (double)targetBlock.m_123342_() + 0.5 - skeleton.m_20186_();
        double deltaZ = (double)targetBlock.m_123343_() + 0.5 - skeleton.m_20189_();
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        arrow.m_6034_(skeleton.m_20185_(), skeleton.m_20188_() - 0.1, skeleton.m_20189_());
        double speed = 1.6;
        arrow.m_20334_((deltaX /= distance) * speed, (deltaY /= distance) * speed, (deltaZ /= distance) * speed);
        level.m_7967_((Entity)arrow);
        level.m_5594_(null, skeleton.m_20183_(), SoundEvents.f_12382_, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    public static void improveZombieBehavior(Zombie zombie, ServerLevel level) {
        double distance;
        if (zombie.m_5448_() != null) {
            return;
        }
        BlockPos targetBlock = SmartMobBehavior.findNearestSurvivalBlock((Monster)zombie, level);
        if (targetBlock != null && (distance = zombie.m_20275_((double)targetBlock.m_123341_(), (double)targetBlock.m_123342_(), (double)targetBlock.m_123343_())) <= 900.0) {
            boolean canNavigate = zombie.m_21573_().m_26519_((double)targetBlock.m_123341_(), (double)targetBlock.m_123342_(), (double)targetBlock.m_123343_(), 1.0);
            if (zombie.f_19797_ % 40 == 0 && (!canNavigate || SmartMobBehavior.isZombieStuck(zombie))) {
                SmartMobBehavior.breakBlocksInPath(zombie, targetBlock, level);
            }
        }
    }

    private static boolean isZombieStuck(Zombie zombie) {
        Vec3 deltaMovement = zombie.m_20184_();
        double speed = deltaMovement.m_165924_();
        return speed < 0.02;
    }

    private static void breakBlocksInPath(Zombie zombie, BlockPos targetBlock, ServerLevel level) {
        BlockPos zombiePos = zombie.m_20183_();
        Vec3 direction = new Vec3((double)(targetBlock.m_123341_() - zombiePos.m_123341_()), 0.0, (double)(targetBlock.m_123343_() - zombiePos.m_123343_())).m_82541_();
        for (int i = 1; i <= 2; ++i) {
            boolean lowerBlocked;
            BlockPos basePos = zombiePos.m_7918_((int)(direction.f_82479_ * (double)i), 0, (int)(direction.f_82481_ * (double)i));
            BlockPos upperPos = basePos.m_7494_();
            BlockPos lowerPos = basePos;
            BlockState upperState = level.m_8055_(upperPos);
            BlockState lowerState = level.m_8055_(lowerPos);
            boolean upperBlocked = !upperState.m_60795_() && SmartMobBehavior.canBreakBlock(upperState);
            boolean bl = lowerBlocked = !lowerState.m_60795_() && SmartMobBehavior.canBreakBlock(lowerState);
            if (!upperBlocked && !lowerBlocked || zombie.f_19797_ % 40 != 0) continue;
            BlockPos targetPos = null;
            BlockState targetState = null;
            if (upperBlocked) {
                targetPos = upperPos;
                targetState = upperState;
            } else if (lowerBlocked) {
                targetPos = lowerPos;
                targetState = lowerState;
            }
            if (targetPos == null || targetState == null) continue;
            level.m_46961_(targetPos, true);
            level.m_5594_(null, targetPos, SoundEvents.f_12601_, SoundSource.HOSTILE, 1.0f, 0.8f);
            level.m_46796_(2001, targetPos, Block.m_49956_((BlockState)targetState));
            IconNotificationManager.showZombieBreaking(level);
            return;
        }
    }

    private static boolean canBreakBlock(BlockState blockState) {
        return !blockState.m_60795_() && blockState.m_60734_() != Blocks.f_50752_ && blockState.m_60734_() != Blocks.f_50080_ && !(blockState.m_60734_() instanceof SurvivalBlock);
    }

    public static void improveCreeperBehavior(Creeper creeper, ServerLevel level) {
        double distance;
        if (creeper.m_5448_() != null) {
            return;
        }
        BlockPos targetBlock = SmartMobBehavior.findNearestSurvivalBlock((Monster)creeper, level);
        if (targetBlock != null && (distance = creeper.m_20275_((double)targetBlock.m_123341_(), (double)targetBlock.m_123342_(), (double)targetBlock.m_123343_())) <= 225.0) {
            boolean canNavigate = creeper.m_21573_().m_26519_((double)targetBlock.m_123341_(), (double)targetBlock.m_123342_(), (double)targetBlock.m_123343_(), 1.2);
            if (creeper.f_19797_ % 40 == 0 && (!canNavigate || SmartMobBehavior.isCreeperStuck(creeper) && SmartMobBehavior.hasNoPassage(creeper, level, targetBlock))) {
                SmartMobBehavior.moveToWallAndExplode(creeper, level, targetBlock);
            }
        }
    }

    private static boolean isCreeperStuck(Creeper creeper) {
        Vec3 deltaMovement = creeper.m_20184_();
        double speed = deltaMovement.m_165924_();
        return speed < 0.02;
    }

    private static boolean hasNoPassage(Creeper creeper, ServerLevel level, BlockPos targetBlock) {
        BlockPos creeperPos = creeper.m_20183_();
        Vec3 direction = new Vec3((double)(targetBlock.m_123341_() - creeperPos.m_123341_()), 0.0, (double)(targetBlock.m_123343_() - creeperPos.m_123343_())).m_82541_();
        for (int i = 1; i <= 3; ++i) {
            BlockPos checkPos = creeperPos.m_7918_((int)(direction.f_82479_ * (double)i), 0, (int)(direction.f_82481_ * (double)i));
            BlockState lowerBlock = level.m_8055_(checkPos);
            BlockState upperBlock = level.m_8055_(checkPos.m_7494_());
            if ((lowerBlock.m_60795_() || !lowerBlock.m_60804_((BlockGetter)level, checkPos)) && (upperBlock.m_60795_() || !upperBlock.m_60804_((BlockGetter)level, checkPos.m_7494_()))) continue;
            return true;
        }
        return false;
    }

    private static void moveToWallAndExplode(Creeper creeper, ServerLevel level, BlockPos targetBlock) {
        BlockPos creeperPos = creeper.m_20183_();
        Vec3 direction = new Vec3((double)(targetBlock.m_123341_() - creeperPos.m_123341_()), 0.0, (double)(targetBlock.m_123343_() - creeperPos.m_123343_())).m_82541_();
        for (int i = 1; i <= 5; ++i) {
            BlockPos checkPos = creeperPos.m_7918_((int)(direction.f_82479_ * (double)i), 0, (int)(direction.f_82481_ * (double)i));
            BlockState blockState = level.m_8055_(checkPos);
            if (blockState.m_60795_() || !blockState.m_60804_((BlockGetter)level, checkPos)) continue;
            BlockPos explodePos = creeperPos.m_7918_((int)(direction.f_82479_ * (double)(i - 1)), 0, (int)(direction.f_82481_ * (double)(i - 1)));
            creeper.m_6027_((double)explodePos.m_123341_() + 0.5, (double)explodePos.m_123342_(), (double)explodePos.m_123343_() + 0.5);
            creeper.m_32312_();
            IconNotificationManager.showCreeperExplosion(level);
            return;
        }
        creeper.m_32312_();
    }

    private static BlockPos findNearestSurvivalBlock(Monster mob, ServerLevel level) {
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return null;
        }
        BlockPos mobPos = mob.m_20183_();
        BlockPos nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (BlockPos blockPos : manager.survivalBlocks) {
            double distance;
            if (!(level.m_8055_(blockPos).m_60734_() instanceof SurvivalBlock) || !((distance = mobPos.m_123331_((Vec3i)blockPos)) < nearestDistance)) continue;
            nearest = blockPos;
            nearestDistance = distance;
        }
        return nearest;
    }
}

