/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.BlockHealthData;
import com.example.examplemod.BlockUpgradeData;
import com.example.examplemod.ExampleMod;
import com.example.examplemod.SurvivalBlockEntity;
import com.example.examplemod.SurvivalConfig;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class SurvivalBlock
extends BaseEntityBlock {
    public SurvivalBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283947_).m_60913_(2.0f, 6.0f).m_222994_().m_60955_().m_60918_(SoundType.f_56742_));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && !newState.m_60713_((Block)this) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SurvivalConfig config = SurvivalConfig.getInstance();
            String message = config.getMessage("block_destroyed", Map.of());
            for (ServerPlayer player : serverLevel.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)message));
            }
            level.m_5594_(null, pos, SoundEvents.f_11668_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            BlockHealthData.removeBlock(pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.f_46443_) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u042d\u0442\u043e\u0442 \u0431\u043b\u043e\u043a \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u043b\u043e\u043c\u0430\u0442\u044c!"));
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.f_46443_) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u042d\u0442\u043e\u0442 \u0431\u043b\u043e\u043a \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u043b\u043e\u043c\u0430\u0442\u044c!"));
            return;
        }
        super.m_5707_(level, pos, state, player);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof SurvivalBlockEntity) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)((SurvivalBlockEntity)entity), (BlockPos)pos);
                return InteractionResult.SUCCESS;
            }
            this.openUpgradeMenu(serverPlayer, level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void openUpgradeMenu(ServerPlayer player, Level level, BlockPos pos) {
        BlockUpgradeData upgradeData = this.getUpgradeData(level, pos);
        if (upgradeData.canUpgrade()) {
            BlockUpgradeData.UpgradeRequirement requirement = upgradeData.getNextUpgradeRequirement();
            if (requirement != null) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u00a7l=== \u041c\u0415\u041d\u042e \u0423\u041b\u0423\u0427\u0428\u0415\u041d\u0418\u0419 \u0411\u041b\u041e\u041a\u0410 ==="));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c: " + upgradeData.getUpgradeLevel())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c: " + (upgradeData.getUpgradeLevel() + 1))));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u0437\u043e\u043d\u044b: +" + requirement.getRadiusIncrease() + " \u0431\u043b\u043e\u043a\u043e\u0432")));
                player.m_213846_((Component)Component.m_237113_((String)"\u00a76\u0422\u0440\u0435\u0431\u0443\u0435\u043c\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b:"));
                for (Map.Entry<Item, Integer> entry : requirement.getResources().entrySet()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a77- " + entry.getKey().m_41466_().getString() + ": " + String.valueOf(entry.getValue()))));
                }
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u041d\u0430\u0436\u043c\u0438\u0442\u0435 \u041f\u041a\u041c \u0435\u0449\u0435 \u0440\u0430\u0437 \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f!"));
                player.getPersistentData().m_128405_("upgrade_block_x", pos.m_123341_());
                player.getPersistentData().m_128405_("upgrade_block_y", pos.m_123342_());
                player.getPersistentData().m_128405_("upgrade_block_z", pos.m_123343_());
            }
        } else {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u00a7l\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u0432\u0435\u043d\u044c \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442!"));
        }
    }

    private BlockUpgradeData getUpgradeData(Level level, BlockPos pos) {
        return new BlockUpgradeData();
    }

    public void explodeAfter100Days(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (ServerPlayer player : serverLevel.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u00a7l\u0412\u042b \u0412\u042b\u0416\u0418\u041b\u0418! :)"));
                }
            }
            level.m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 4.0f, Level.ExplosionInteraction.BLOCK);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SurvivalBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SurvivalBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)ExampleMod.SURVIVAL_BLOCK_ENTITY.get()), SurvivalBlockEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

