/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ExampleMod;
import com.example.examplemod.ProtectionZone;
import com.example.examplemod.SurvivalBlockContainer;
import com.example.examplemod.SurvivalManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SurvivalBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public SurvivalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExampleMod.SURVIVAL_BLOCK_ENTITY.get(), pos, state);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                SurvivalBlockEntity.this.m_6596_();
                SurvivalBlockEntity.this.checkExpansionResources();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return SurvivalBlockEntity.this.isExpansionResource(stack);
            }
        };
    }

    private boolean isExpansionResource(ItemStack stack) {
        return stack.m_41720_() == Items.f_42416_ || stack.m_41720_() == Items.f_42417_ || stack.m_41720_() == Items.f_42415_ || stack.m_41720_() == Items.f_42616_ || stack.m_41720_() == Items.f_42418_ || stack.m_41720_() == Items.f_41905_ || stack.m_41720_() == Items.f_42594_ || stack.m_41720_() == Items.f_41999_;
    }

    private void checkExpansionResources() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int totalValue = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            totalValue += this.getResourceValue(stack) * stack.m_41613_();
        }
        int newRadius = this.calculateRadius(totalValue);
        this.updateProtectionZone(newRadius);
    }

    private int getResourceValue(ItemStack stack) {
        if (stack.m_41720_() == Items.f_41905_ || stack.m_41720_() == Items.f_42594_) {
            return 1;
        }
        if (stack.m_41720_() == Items.f_42416_) {
            return 5;
        }
        if (stack.m_41720_() == Items.f_42417_) {
            return 10;
        }
        if (stack.m_41720_() == Items.f_42415_) {
            return 25;
        }
        if (stack.m_41720_() == Items.f_42616_) {
            return 30;
        }
        if (stack.m_41720_() == Items.f_41999_) {
            return 15;
        }
        if (stack.m_41720_() == Items.f_42418_) {
            return 100;
        }
        return 0;
    }

    private int calculateRadius(int totalValue) {
        int baseRadius = 10;
        int bonusRadius = totalValue / 100 * 5;
        return Math.min(baseRadius + bonusRadius, 50);
    }

    private void updateProtectionZone(int newRadius) {
        SurvivalManager manager = SurvivalManager.get(this.f_58857_);
        if (manager != null) {
            for (ProtectionZone zone : manager.getProtectionZones()) {
                if (!zone.getCenterBlock().equals((Object)this.m_58899_())) continue;
                zone.setRadius(newRadius);
                for (Player player : this.f_58857_.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415] \u0420\u0430\u0434\u0438\u0443\u0441 \u0437\u0430\u0449\u0438\u0442\u044b: \u00a7e" + newRadius + " \u00a7a\u0431\u043b\u043e\u043a\u043e\u0432")));
                }
            }
        }
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"\u0411\u043b\u043e\u043a \u0412\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new SurvivalBlockContainer(windowId, inv, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public void drops() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SurvivalBlockEntity blockEntity) {
    }
}

