/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ActiveWave;
import com.example.examplemod.BloodNightManager;
import com.example.examplemod.DebugManager;
import com.example.examplemod.DifficultyManager;
import com.example.examplemod.NightMobConfig;
import com.example.examplemod.ParticleTestCommand;
import com.example.examplemod.ProgressionManager;
import com.example.examplemod.ProtectionZone;
import com.example.examplemod.SurvivalManager;
import com.example.examplemod.TestParticlesCommand;
import com.example.examplemod.WaveBossBar;
import com.example.examplemod.WaveManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SurvivalCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        SurvivalCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        TestParticlesCommand.register(dispatcher);
        ParticleTestCommand.register(dispatcher);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"error").executes(context -> {
            Entity patt1181$temp = ((CommandSourceStack)context.getSource()).m_81373_();
            if (patt1181$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt1181$temp;
                DebugManager.toggleDebug(player);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0430\u043c!"));
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"survival").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"test").then(Commands.m_82127_((String)"bossbar").executes(context -> SurvivalCommands.testBossBar((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"wave").executes(context -> SurvivalCommands.testWave((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"particles").executes(context -> SurvivalCommands.testParticles((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"bloodnight").executes(context -> SurvivalCommands.testBloodNight((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"sounds").executes(context -> SurvivalCommands.testSounds((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"night").executes(context -> SurvivalCommands.testNightWave((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"forcewave").executes(context -> SurvivalCommands.forceSpawnWave((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"forcenight").then(Commands.m_82129_((String)"night", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> SurvivalCommands.forceSpawnNight((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"night")))))).then(Commands.m_82127_((String)"mobcount").executes(context -> SurvivalCommands.showMobProgression((CommandSourceStack)context.getSource()))))).then(Commands.m_82127_((String)"status").executes(context -> SurvivalCommands.showStatus((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"progression").then(Commands.m_82127_((String)"show").executes(context -> SurvivalCommands.showProgression((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> SurvivalCommands.resetProgression((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.string()).executes(context -> SurvivalCommands.unlockAllProgression((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"complete").then(Commands.m_82129_((String)"difficulty", (ArgumentType)StringArgumentType.string()).executes(context -> SurvivalCommands.completeDifficulty((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"difficulty")))))));
    }

    private static int testBossBar(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel) {
            ServerLevel level = source.m_81372_();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[\u0422\u0415\u0421\u0422] \u0421\u043e\u0437\u0434\u0430\u0435\u043c \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 CustomBossEvent..."), false);
            WaveBossBar testBar = new WaveBossBar("\u00a7c\u00a7l\u0422\u0415\u0421\u0422\u041e\u0412\u042b\u0419 BOSS BAR", 999, level);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[\u0422\u0415\u0421\u0422] CustomBossEvent \u0441\u043e\u0437\u0434\u0430\u043d! \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0441\u0432\u0435\u0440\u0445\u0443 \u044d\u043a\u0440\u0430\u043d\u0430."), false);
            new Thread(() -> {
                try {
                    for (int i = 75; i >= 0; i -= 5) {
                        float progress = (float)i / 100.0f;
                        testBar.setProgress(progress);
                        testBar.setName("\u00a7c\u00a7l\u0422\u0415\u0421\u0422\u041e\u0412\u042b\u0419 BOSS BAR \u00a7f(\u00a7e" + i + "%\u00a7f)");
                        if (progress > 0.75f) {
                            testBar.setColor("red");
                        } else if (progress > 0.5f) {
                            testBar.setColor("yellow");
                        } else if (progress > 0.25f) {
                            testBar.setColor("green");
                        } else {
                            testBar.setColor("blue");
                        }
                        Thread.sleep(500L);
                    }
                    testBar.setName("\u00a7a\u00a7l\u2713 BOSS BAR \u0422\u0415\u0421\u0422 \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d");
                    testBar.setColor("green");
                    Thread.sleep(5000L);
                    testBar.cleanup();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[\u0422\u0415\u0421\u0422] CustomBossEvent \u0430\u043d\u0438\u043c\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430! \u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0441\u0432\u0435\u0440\u0445\u0443 \u044d\u043a\u0440\u0430\u043d\u0430."), false);
        }
        return 1;
    }

    private static int testWave(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[\u0422\u0415\u0421\u0422] \u0421\u043e\u0437\u0434\u0430\u0435\u043c \u0442\u0435\u0441\u0442\u043e\u0432\u0443\u044e \u0432\u043e\u043b\u043d\u0443..."), false);
            BlockPos playerPos = player.m_20183_();
            ActiveWave testWave = new ActiveWave(5, playerPos, false, level);
            for (int i = 0; i < 10; ++i) {
                testWave.addMob(null);
            }
            new Thread(() -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[\u0422\u0415\u0421\u0422] \u0422\u0435\u0441\u0442\u043e\u0432\u0430\u044f \u0432\u043e\u043b\u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0430!"), false);
        }
        return 1;
    }

    private static int showStatus(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel) {
            ServerLevel level = source.m_81372_();
            SurvivalManager manager = SurvivalManager.get((Level)level);
            if (manager != null) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a78\u00a7l=== \u0421\u0422\u0410\u0422\u0423\u0421 \u0418\u0413\u0420\u042b ==="), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77\u0418\u0433\u0440\u0430 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430: " + (manager.isGameStarted() ? "\u00a7a\u0414\u0430" : "\u00a7c\u041d\u0435\u0442"))), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77\u0420\u0435\u0436\u0438\u043c \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430: " + (manager.isApocalypseMode() ? "\u00a7c\u0414\u0430" : "\u00a7a\u041d\u0435\u0442"))), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0432\u043e\u043b\u043d: \u00a7e" + manager.getActiveWaves().size())), false);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77\u0411\u043b\u043e\u043a\u043e\u0432 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f: \u00a7e" + manager.survivalBlocks.size())), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a78\u00a7l=================="), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7c\u041c\u0435\u043d\u0435\u0434\u0436\u0435\u0440 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"), false);
            }
        }
        return 1;
    }

    private static int testParticles(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[\u0422\u0415\u0421\u0422] \u0421\u043e\u0437\u0434\u0430\u0435\u043c \u0442\u0435\u0441\u0442\u043e\u0432\u0443\u044e \u0437\u0430\u0449\u0438\u0442\u043d\u0443\u044e \u0437\u043e\u043d\u0443 \u0441 \u0447\u0430\u0441\u0442\u0438\u0446\u0430\u043c\u0438..."), false);
            BlockPos playerPos = player.m_20183_();
            ProtectionZone testZone = new ProtectionZone(playerPos, 15);
            new Thread(() -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        testZone.spawnParticles((Level)level);
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[\u0422\u0415\u0421\u0422] \u0417\u0430\u0449\u0438\u0442\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0430! \u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043a\u0440\u0430\u0441\u043d\u044b\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u044b \u0432\u043e\u043a\u0440\u0443\u0433."), false);
        }
        return 1;
    }

    private static int testBloodNight(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a74[\u0422\u0415\u0421\u0422] \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u043a\u0440\u043e\u0432\u0430\u0432\u0443\u044e \u043d\u043e\u0447\u044c..."), false);
            BlockPos playerPos = player.m_20183_();
            BloodNightManager.startBloodNight(level, 7);
            ActiveWave bloodWave = new ActiveWave(7, playerPos, true, level);
            for (int i = 0; i < 5; ++i) {
                bloodWave.addMob(null);
            }
            new Thread(() -> {
                try {
                    Thread.sleep(15000L);
                    BloodNightManager.endBloodNight(level, 7);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a74[\u0422\u0415\u0421\u0422] \u041a\u0440\u043e\u0432\u0430\u0432\u0430\u044f \u043d\u043e\u0447\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430! \u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 15 \u0441\u0435\u043a\u0443\u043d\u0434."), false);
        }
        return 1;
    }

    private static int testSounds(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[\u0422\u0415\u0421\u0422] \u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0432\u0441\u0435 \u0437\u0432\u0443\u043a\u0438 \u043c\u043e\u0434\u0430..."), false);
            new Thread(() -> {
                try {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a741. \u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0440\u043e\u0432\u0430\u0432\u043e\u0439 \u043d\u043e\u0447\u0438"));
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_12563_, SoundSource.MASTER, 0.8f, 0.3f);
                    Thread.sleep(3000L);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a742. \u041c\u0443\u0437\u044b\u043a\u0430 \u043a\u0440\u043e\u0432\u0430\u0432\u043e\u0439 \u043d\u043e\u0447\u0438 (\u043a\u0430\u0441\u0442\u043e\u043c\u043d\u0430\u044f)"));
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_12149_, SoundSource.MASTER, 0.7f, 1.0f);
                    Thread.sleep(3000L);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7a3. \u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043a\u0440\u043e\u0432\u0430\u0432\u043e\u0439 \u043d\u043e\u0447\u0438"));
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.MASTER, 1.0f, 1.0f);
                    Thread.sleep(2000L);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a754. \u0411\u043e\u043b\u044c\u0448\u0430\u044f \u0432\u043e\u043b\u043d\u0430"));
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_11894_, SoundSource.MASTER, 0.3f, 1.0f);
                    Thread.sleep(2000L);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7e5. \u041e\u0431\u044b\u0447\u043d\u0430\u044f \u0432\u043e\u043b\u043d\u0430"));
                    level.m_5594_(null, player.m_20183_(), (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(0)).m_203334_(), SoundSource.MASTER, 0.6f, 1.0f);
                    Thread.sleep(2000L);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c6. \u0410\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441"));
                    level.m_5594_(null, player.m_20183_(), SoundEvents.f_12563_, SoundSource.MASTER, 0.5f, 0.5f);
                    Thread.sleep(2000L);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u2713 \u0422\u0435\u0441\u0442 \u0437\u0432\u0443\u043a\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d!"));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[\u0422\u0415\u0421\u0422] \u0417\u0432\u0443\u043a\u0438 \u0431\u0443\u0434\u0443\u0442 \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u0441 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u043e\u043c 2-3 \u0441\u0435\u043a\u0443\u043d\u0434\u044b"), false);
        }
        return 1;
    }

    private static int testNightWave(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[\u0422\u0415\u0421\u0422] \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u043d\u043e\u0447\u043d\u0443\u044e \u0432\u043e\u043b\u043d\u0443 \u0441 boss bar..."), false);
            BlockPos playerPos = player.m_20183_();
            SurvivalManager manager = SurvivalManager.get((Level)level);
            if (manager != null) {
                long daysElapsed = manager.getDaysElapsed((Level)level);
                int currentDay = (int)daysElapsed + 1;
                WaveManager.spawnWaveForDay(level, playerPos, currentDay);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7a[\u0422\u0415\u0421\u0422] \u041d\u043e\u0447\u043d\u0430\u044f \u0432\u043e\u043b\u043d\u0430 \u0434\u043d\u044f " + currentDay + " \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430! \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 boss bar \u0441\u0432\u0435\u0440\u0445\u0443.")), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7c[\u041e\u0428\u0418\u0411\u041a\u0410] SurvivalManager \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"), false);
            }
        }
        return 1;
    }

    private static int forceSpawnWave(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7c[\u041f\u0420\u0418\u041d\u0423\u0414\u0418\u0422\u0415\u041b\u042c\u041d\u041e] \u0421\u043f\u0430\u0432\u043d\u0438\u043c \u0432\u043e\u043b\u043d\u0443 \u043f\u0440\u044f\u043c\u043e \u0441\u0435\u0439\u0447\u0430\u0441..."), false);
            BlockPos playerPos = player.m_20183_();
            SurvivalManager manager = SurvivalManager.get((Level)level);
            if (manager != null) {
                long daysElapsed = manager.getDaysElapsed((Level)level);
                int currentDay = (int)daysElapsed + 1;
                WaveManager.spawnWaveForDay(level, playerPos, currentDay);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7a[\u041f\u0420\u0418\u041d\u0423\u0414\u0418\u0422\u0415\u041b\u042c\u041d\u041e] \u0412\u043e\u043b\u043d\u0430 \u0434\u043d\u044f " + currentDay + " \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u0430! Boss bar \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u043e\u044f\u0432\u0438\u0442\u044c\u0441\u044f.")), false);
                long timeOfDay = level.m_46468_() % 24000L;
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77\u0412\u0440\u0435\u043c\u044f \u0434\u043d\u044f: " + timeOfDay + " \u0442\u0438\u043a\u043e\u0432")), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7c[\u041e\u0428\u0418\u0411\u041a\u0410] SurvivalManager \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"), false);
            }
        }
        return 1;
    }

    private static int showProgression(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            ProgressionManager progression = ProgressionManager.get(level);
            progression.showAvailableDifficulties(player);
        }
        return 1;
    }

    private static int resetProgression(CommandSourceStack source, String playerName) {
        if (source.m_81372_() instanceof ServerLevel) {
            ServerLevel level = source.m_81372_();
            ServerPlayer targetPlayer = level.m_7654_().m_6846_().m_11255_(playerName);
            if (targetPlayer != null) {
                ProgressionManager progression = ProgressionManager.get(level);
                progression.resetPlayerProgress(targetPlayer.m_20148_());
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7a[\u0410\u0414\u041c\u0418\u041d] \u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441 \u0438\u0433\u0440\u043e\u043a\u0430 " + playerName + " \u0441\u0431\u0440\u043e\u0448\u0435\u043d!")), false);
                targetPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7e[\u0421\u0418\u0421\u0422\u0415\u041c\u0410] \u0412\u0430\u0448 \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441 \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0443\u0440\u043e\u0432\u043d\u0435\u0439 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0431\u044b\u043b \u0441\u0431\u0440\u043e\u0448\u0435\u043d \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c."));
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7c[\u041e\u0428\u0418\u0411\u041a\u0410] \u0418\u0433\u0440\u043e\u043a " + playerName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!")), false);
            }
        }
        return 1;
    }

    private static int unlockAllProgression(CommandSourceStack source, String playerName) {
        if (source.m_81372_() instanceof ServerLevel) {
            ServerLevel level = source.m_81372_();
            ServerPlayer targetPlayer = level.m_7654_().m_6846_().m_11255_(playerName);
            if (targetPlayer != null) {
                ProgressionManager progression = ProgressionManager.get(level);
                progression.unlockAllDifficulties(targetPlayer.m_20148_());
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7a[\u0410\u0414\u041c\u0418\u041d] \u0412\u0441\u0435 \u0443\u0440\u043e\u0432\u043d\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u0434\u043b\u044f " + playerName + "!")), false);
                targetPlayer.m_213846_((Component)Component.m_237113_((String)"\u00a7e[\u0421\u0418\u0421\u0422\u0415\u041c\u0410] \u0412\u0441\u0435 \u0443\u0440\u043e\u0432\u043d\u0438 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c!"));
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7c[\u041e\u0428\u0418\u0411\u041a\u0410] \u0418\u0433\u0440\u043e\u043a " + playerName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!")), false);
            }
        }
        return 1;
    }

    private static int completeDifficulty(CommandSourceStack source, String difficultyName) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            try {
                DifficultyManager.Difficulty difficulty = DifficultyManager.Difficulty.valueOf(difficultyName.toUpperCase());
                ProgressionManager progression = ProgressionManager.get(level);
                progression.completeDifficulty(player.m_20148_(), difficulty);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7a[\u0422\u0415\u0421\u0422] \u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438 " + difficulty.getDisplayName() + " \u043e\u0442\u043c\u0435\u0447\u0435\u043d \u043a\u0430\u043a \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u043d\u044b\u0439!")), false);
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76\ud83c\udfc6 \u0423\u0440\u043e\u0432\u0435\u043d\u044c " + difficulty.getDisplayName() + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d! (\u0422\u0435\u0441\u0442\u043e\u0432\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430)")));
            }
            catch (IllegalArgumentException e) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7c[\u041e\u0428\u0418\u0411\u041a\u0410] \u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u0438! \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435: NOVICE, EXPERIENCED, MONSTER, DEATH"), false);
            }
        }
        return 1;
    }

    private static int showMobProgression(CommandSourceStack source) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            int[] keyNights;
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            DifficultyManager.Difficulty currentDifficulty = DifficultyManager.getSelectedDifficulty();
            if (currentDifficulty == null) {
                currentDifficulty = DifficultyManager.Difficulty.NOVICE;
            }
            DifficultyManager.Difficulty finalDifficulty = currentDifficulty;
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e=== \u041f\u0420\u041e\u0413\u0420\u0415\u0421\u0421\u0418\u042f \u041c\u041e\u0411\u041e\u0412 ==="), false);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a77\u0421\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c: \u00a7a" + finalDifficulty.getDisplayName())), false);
            for (int night : keyNights = new int[]{1, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100}) {
                String waveType;
                int mobCount = NightMobConfig.getMobCountForNight(night, finalDifficulty);
                String string = waveType = NightMobConfig.isBigWaveNight(night) ? " \u00a7c(\u0411\u043e\u043b\u044c\u0448\u0430\u044f)" : "";
                String color = night == 100 ? "\u00a76" : (night % 10 == 0 ? "\u00a7e" : "\u00a77");
                int finalNight = night;
                int finalMobCount = mobCount;
                String finalWaveType = waveType;
                String finalColor = color;
                source.m_288197_(() -> Component.m_237113_((String)String.format("%s\u041d\u043e\u0447\u044c %d: \u00a7f%d \u043c\u043e\u0431\u043e\u0432%s", finalColor, finalNight, finalMobCount, finalWaveType)), false);
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7e=== \u0426\u0415\u041b\u0415\u0412\u042b\u0415 \u0417\u041d\u0410\u0427\u0415\u041d\u0418\u042f (100-\u044f \u043d\u043e\u0447\u044c) ==="), false);
            for (DifficultyManager.Difficulty diff : DifficultyManager.Difficulty.values()) {
                int target = NightMobConfig.getFinalNightTarget(diff);
                String color = diff == finalDifficulty ? "\u00a7a" : "\u00a77";
                DifficultyManager.Difficulty finalDiff = diff;
                int finalTarget = target;
                String finalColor2 = color;
                source.m_288197_(() -> Component.m_237113_((String)String.format("%s%s: \u00a7f%d \u043c\u043e\u0431\u043e\u0432", finalColor2, finalDiff.getDisplayName(), finalTarget)), false);
            }
            boolean bl = NightMobConfig.validateProgression(finalDifficulty);
            String validationColor = bl ? "\u00a7a" : "\u00a7c";
            String validationText = bl ? "\u2713 \u041a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430" : "\u2717 \u041e\u0448\u0438\u0431\u043a\u0430";
            String finalValidationColor = validationColor;
            String finalValidationText = validationText;
            source.m_288197_(() -> Component.m_237113_((String)String.format("\u00a77\u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0438\u044f: %s%s", finalValidationColor, finalValidationText)), false);
        }
        return 1;
    }

    private static int forceSpawnNight(CommandSourceStack source, int night) {
        if (source.m_81372_() instanceof ServerLevel && source.m_81373_() instanceof ServerPlayer) {
            ServerLevel level = source.m_81372_();
            ServerPlayer player = (ServerPlayer)source.m_81373_();
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7c[\u041f\u0420\u0418\u041d\u0423\u0414\u0418\u0422\u0415\u041b\u042c\u041d\u041e] \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c " + night + "-\u044e \u043d\u043e\u0447\u044c...")), false);
            BlockPos playerPos = player.m_20183_();
            WaveManager.spawnWaveForDay(level, playerPos, night);
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7a[\u041f\u0420\u0418\u041d\u0423\u0414\u0418\u0422\u0415\u041b\u042c\u041d\u041e] " + night + "-\u044f \u043d\u043e\u0447\u044c \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430!")), false);
            DifficultyManager.Difficulty difficulty = DifficultyManager.getSelectedDifficulty();
            if (difficulty != null) {
                int mobCount = NightMobConfig.getMobCountForNight(night, difficulty);
                String nightType = "";
                if (night % 10 == 0) {
                    nightType = " \u00a76(\u0411\u043e\u043b\u044c\u0448\u0430\u044f \u0432\u043e\u043b\u043d\u0430)";
                } else if (night % 7 == 0) {
                    nightType = " \u00a74(\u041a\u0440\u043e\u0432\u0430\u0432\u0430\u044f \u043d\u043e\u0447\u044c)";
                }
                int finalMobCount = mobCount;
                String finalNightType = nightType;
                source.m_288197_(() -> Component.m_237113_((String)("\u00a77\u041c\u043e\u0431\u043e\u0432: \u00a7e" + finalMobCount + finalNightType)), false);
            }
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7c[\u041e\u0428\u0418\u0411\u041a\u0410] \u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0430\u043c!"), false);
        }
        return 1;
    }
}

