/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class SurvivalConfig
implements ResourceManagerReloadListener {
    private static final Gson GSON = new Gson();
    private static SurvivalConfig instance;
    private int maxHealth = 100;
    private int damagePerAttack = 20;
    private int regenerationPerDay = 0;
    private Map<String, WaveConfig> waves = new HashMap<String, WaveConfig>();
    private Map<String, UpgradeConfig> upgrades = new HashMap<String, UpgradeConfig>();
    private Map<String, String> messages = new HashMap<String, String>();

    public static SurvivalConfig getInstance() {
        if (instance == null) {
            instance = new SurvivalConfig();
        }
        return instance;
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.loadConfig(resourceManager);
    }

    private void loadConfig(ResourceManager resourceManager) {
        block15: {
            try {
                ResourceLocation configLocation = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)"survival_config.json");
                Optional resource = resourceManager.m_213713_(configLocation);
                if (!resource.isPresent()) break block15;
                try (InputStream inputStream = ((Resource)resource.get()).m_215507_();){
                    JsonObject config = JsonParser.parseReader((Reader)new InputStreamReader(inputStream)).getAsJsonObject();
                    if (config.has("block_health")) {
                        JsonObject healthConfig = config.getAsJsonObject("block_health");
                        this.maxHealth = healthConfig.get("max_health").getAsInt();
                        this.damagePerAttack = healthConfig.get("damage_per_attack").getAsInt();
                        this.regenerationPerDay = healthConfig.get("regeneration_per_day").getAsInt();
                    }
                    if (config.has("waves")) {
                        JsonObject wavesConfig = config.getAsJsonObject("waves");
                        this.waves.clear();
                        for (String day : wavesConfig.keySet()) {
                            WaveConfig wave = (WaveConfig)GSON.fromJson(wavesConfig.get(day), WaveConfig.class);
                            this.waves.put(day, wave);
                        }
                    }
                    if (config.has("upgrade_requirements")) {
                        JsonObject upgradeConfig = config.getAsJsonObject("upgrade_requirements");
                        this.upgrades.clear();
                        for (String level : upgradeConfig.keySet()) {
                            UpgradeConfig upgrade = (UpgradeConfig)GSON.fromJson(upgradeConfig.get(level), UpgradeConfig.class);
                            this.upgrades.put(level, upgrade);
                        }
                    }
                    if (config.has("messages")) {
                        JsonObject messagesConfig = config.getAsJsonObject("messages");
                        this.messages.clear();
                        for (String key : messagesConfig.keySet()) {
                            this.messages.put(key, messagesConfig.get(key).getAsString());
                        }
                    }
                }
            }
            catch (Exception e) {
                System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: " + e.getMessage());
            }
        }
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public int getDamagePerAttack() {
        return this.damagePerAttack;
    }

    public int getRegenerationPerDay() {
        return this.regenerationPerDay;
    }

    public WaveConfig getWaveForDay(int day) {
        String dayKey = "day_" + day;
        return this.waves.getOrDefault(dayKey, new WaveConfig());
    }

    public UpgradeConfig getUpgradeForLevel(int level) {
        String levelKey = level <= 20 ? "level_1_20" : (level <= 50 ? "level_21_50" : "level_51_100");
        return this.upgrades.getOrDefault(levelKey, new UpgradeConfig());
    }

    public String getMessage(String key, Map<String, String> replacements) {
        String message = this.messages.getOrDefault(key, this.getDefaultMessage(key));
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return message;
    }

    private String getDefaultMessage(String key) {
        return switch (key) {
            case "block_destroyed" -> "\u00a74\u0412\u042b \u041f\u0420\u041e\u0418\u0413\u0420\u0410\u041b\u0418! :(";
            case "survival_win" -> "\u00a7a\u0412\u042b \u0412\u042b\u0416\u0418\u041b\u0418! :)";
            case "wave_start" -> "\u00a7e\u041d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u0432\u043e\u043b\u043d\u0430 \u043c\u043e\u0431\u043e\u0432 \u043d\u0430 \u0434\u0435\u043d\u044c {day}!";
            case "block_damaged" -> "\u00a7e\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435 \u0431\u043b\u043e\u043a\u0430: {health}%";
            default -> "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e: " + key;
        };
    }

    public static class WaveConfig {
        public List<MobConfig> mobs = new ArrayList<MobConfig>();
    }

    public static class UpgradeConfig {
        public int radius_increase;
        public List<ResourceConfig> resources = new ArrayList<ResourceConfig>();
    }

    public static class ResourceConfig {
        public String item;
        public int count;

        public Item getItem() {
            switch (this.item.toLowerCase()) {
                case "dirt": {
                    return Items.f_42329_;
                }
                case "cobblestone": {
                    return Items.f_42594_;
                }
                case "iron_ingot": {
                    return Items.f_42416_;
                }
                case "gold_ingot": {
                    return Items.f_42417_;
                }
                case "diamond": {
                    return Items.f_42415_;
                }
                case "emerald": {
                    return Items.f_42616_;
                }
                case "netherite_ingot": {
                    return Items.f_42418_;
                }
            }
            return Items.f_42329_;
        }
    }

    public static class MobConfig {
        public String type;
        public int count;
        public int spawn_radius;
    }
}

