/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ActiveWave;
import com.example.examplemod.AutoDefenseBuilder;
import com.example.examplemod.BlockHealthData;
import com.example.examplemod.BlockHealthMonitor;
import com.example.examplemod.DebugManager;
import com.example.examplemod.DifficultyManager;
import com.example.examplemod.ExampleMod;
import com.example.examplemod.GolemBehavior;
import com.example.examplemod.HealthBoostBlock;
import com.example.examplemod.IconNotificationManager;
import com.example.examplemod.NightBossBar;
import com.example.examplemod.NightMobConfig;
import com.example.examplemod.PerformanceManager;
import com.example.examplemod.ProtectionZone;
import com.example.examplemod.ScreenNotificationManager;
import com.example.examplemod.SmartMobBehavior;
import com.example.examplemod.SurvivalBlock;
import com.example.examplemod.SurvivalManager;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="citadelguard")
public class SurvivalEventHandler {
    private static final Random random = new Random();
    private static long lastGolemCheck = 0L;
    private static final List<IronGolem> cachedIronGolems = new CopyOnWriteArrayList<IronGolem>();
    private static final List<SnowGolem> cachedSnowGolems = new CopyOnWriteArrayList<SnowGolem>();
    private static final Map<String, List<BlockPos>> survivalBlocksCache = new ConcurrentHashMap<String, List<BlockPos>>();
    private static long lastSurvivalBlocksCacheUpdate = 0L;
    private static long lastZoneCleanCheck = 0L;
    private static final long ZONE_CLEAN_CACHE_TIME = 5000L;
    private static long lastMobCountCheck = 0L;
    private static int cachedMobCount = 0;
    private static final long MOB_COUNT_CACHE_TIME = 1000L;
    private static final Map<String, Boolean> protectionZoneCache = new ConcurrentHashMap<String, Boolean>();
    private static long lastProtectionCacheClean = 0L;
    private static final Queue<BlockPos> blockPosPool = new ConcurrentLinkedQueue<BlockPos>();
    private static final List<ParticleRequest> pendingParticles = new ArrayList<ParticleRequest>();

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player;
        Level level;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SurvivalManager manager = SurvivalManager.get(level);
            if (manager != null) {
                String playerUUID = player.m_20148_().toString();
                manager.restoreProtectionZones(level);
                if (manager.isPermanentlyDead(playerUUID)) {
                    player.m_143403_(GameType.SPECTATOR);
                    ScreenNotificationManager.showNotificationToPlayer(player, "\u00a7c\u00a7l\u2620 \u041f\u0415\u0420\u041c\u0410\u041d\u0415\u041d\u0422\u041d\u0410\u042f \u0421\u041c\u0415\u0420\u0422\u042c \u2620", "\u00a77\u0411\u043b\u043e\u043a \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0431\u044b\u043b \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d \u0434\u043e \u0432\u0430\u0448\u0435\u0439 \u0441\u043c\u0435\u0440\u0442\u0438");
                    return;
                }
                if (!manager.isGameStarted()) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u00a7l\ud83c\udff0 \u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c \u0432 Citadel Guard!"));
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u0412\u0430\u0448\u0430 \u043a\u0440\u0435\u043f\u043e\u0441\u0442\u044c \u0431\u0443\u0434\u0435\u0442 \u0430\u0442\u0430\u043a\u043e\u0432\u0430\u043d\u0430 \u0441 \u043d\u0430\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u0435\u043c \u043d\u043e\u0447\u0438."));
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u041f\u043e\u0441\u0442\u0440\u043e\u0439\u0442\u0435 \u043e\u0431\u043e\u0440\u043e\u043d\u0443 \u0438 \u0437\u0430\u0449\u0438\u0442\u0438\u0442\u0435 \u0431\u043b\u043e\u043a \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f!"));
                } else {
                    List<ActiveWave> activeWaves;
                    boolean hasGameProgressed;
                    long timeOfDay = level.m_46468_() % 24000L;
                    boolean isNight = timeOfDay >= 13000L || timeOfDay <= 1000L;
                    long daysElapsed = manager.getDaysElapsed(level);
                    boolean bl = hasGameProgressed = daysElapsed > 0L || manager.hasNightEverStarted();
                    if (isNight && !NightBossBar.getInstance().isActive() && hasGameProgressed) {
                        DifficultyManager.Difficulty difficulty;
                        int maxMobs;
                        int currentDay = (int)daysElapsed + 1;
                        if (manager.isApocalypseMode()) {
                            currentDay = 80 + random.nextInt(20);
                        }
                        if ((maxMobs = NightMobConfig.getMobCountWithDifficulty(currentDay, difficulty = DifficultyManager.getSelectedDifficulty())) < 5) {
                            maxMobs = 5;
                        }
                        long nightLength = 12000L;
                        long currentNightTime = timeOfDay >= 13000L ? timeOfDay - 13000L : 11000L + timeOfDay;
                        double nightProgress = (double)currentNightTime / (double)nightLength;
                        int expectedSpawned = (int)((double)maxMobs * nightProgress * 0.8);
                        NightBossBar.getInstance().startNight(serverLevel, currentDay, maxMobs);
                        for (int i = 0; i < expectedSpawned; ++i) {
                            NightBossBar.getInstance().onMobSpawned();
                        }
                        NightBossBar.getInstance().addPlayer(player);
                        ScreenNotificationManager.showNotificationToPlayer(player, "\u00a7c\u00a7l\u2694 \u041d\u041e\u0427\u041d\u0410\u042f \u0410\u0422\u0410\u041a\u0410 \u0412\u041e\u0421\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d\u0410 \u2694", "\u00a7e\u041d\u043e\u0447\u044c " + currentDay + " \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0435\u0442\u0441\u044f!");
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[RESTORE] \u041d\u043e\u0447\u043d\u0430\u044f \u0430\u0442\u0430\u043a\u0430 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430! \u041d\u043e\u0447\u044c " + currentDay)));
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[RESTORE] \u041d\u0443\u0436\u043d\u043e \u0443\u0431\u0438\u0442\u044c: " + maxMobs + " \u043c\u043e\u0431\u043e\u0432")));
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[RESTORE] \u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441 \u043d\u043e\u0447\u0438: " + (int)(nightProgress * 100.0) + "%")));
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[RESTORE] \u041e\u0436\u0438\u0434\u0430\u0435\u043c\u043e \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e: " + expectedSpawned + " \u043c\u043e\u0431\u043e\u0432")));
                    }
                    if (!(activeWaves = manager.getActiveWaves()).isEmpty()) {
                        ScreenNotificationManager.showNotificationToPlayer(player, "\u00a7a\u00a7l\ud83c\udfae \u0414\u041e\u0411\u0420\u041e \u041f\u041e\u0416\u0410\u041b\u041e\u0412\u0410\u0422\u042c! \ud83c\udfae", "\u00a7e\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0432\u043e\u043b\u043d: " + activeWaves.size());
                        for (ActiveWave wave : activeWaves) {
                            if (wave.getBossBar() == null) continue;
                            wave.getBossBar().addPlayer(player);
                        }
                    }
                    if (NightBossBar.getInstance().isActive()) {
                        NightBossBar.getInstance().addPlayer(player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        SurvivalManager manager;
        LevelAccessor levelAccessor;
        if (event.getState().m_60734_() instanceof SurvivalBlock && (levelAccessor = event.getLevel()) instanceof ServerLevel && (manager = SurvivalManager.get((Level)(serverLevel = (ServerLevel)levelAccessor))) != null) {
            manager.removeSurvivalBlock(event.getPos(), (Level)serverLevel);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        long tickCount;
        if (event.phase == TickEvent.Phase.END && (tickCount = (long)event.getServer().m_129921_()) % 40L == 0L) {
            for (ServerLevel level : event.getServer().m_129785_()) {
                boolean isDay;
                boolean isStartOfNight;
                boolean hasActiveMobs;
                int baseParticleInterval;
                int particleInterval;
                SurvivalManager manager = SurvivalManager.get((Level)level);
                if (manager == null) continue;
                manager.tick((Level)level);
                if (tickCount % 200L == 0L) {
                    manager.cleanupInvalidBlocks((Level)level);
                }
                if (tickCount % (long)(particleInterval = PerformanceManager.getAdaptiveInterval(baseParticleInterval = (hasActiveMobs = NightBossBar.getInstance().isActive() && NightBossBar.getInstance().getAliveMobs() > 15) ? 120 : 80)) == 0L) {
                    manager.spawnZoneParticles((Level)level);
                }
                if (tickCount % 40L == 0L) {
                    SurvivalEventHandler.processPendingParticles();
                }
                if (tickCount % 1200L == 0L) {
                    PerformanceManager.canPerformOperation("cache_cleanup_trigger", 0L);
                }
                if (tickCount % 200L == 0L) {
                    IconNotificationManager.cleanupExpiredIcons(level);
                }
                if (tickCount % 80L == 0L) {
                    for (BlockPos blockPos : manager.survivalBlocks) {
                        BlockHealthMonitor.checkBlockHealth(level, blockPos);
                    }
                }
                if (tickCount % 200L == 0L) {
                    DifficultyManager.checkCompletionConditions(level);
                }
                if (tickCount % 400L == 0L) {
                    SurvivalEventHandler.checkNightEnd(level);
                }
                if (tickCount % 200L == 0L) {
                    SurvivalEventHandler.syncNightBossBar(level);
                }
                if (!manager.isGameStarted() && DifficultyManager.isDifficultyChosen()) {
                    for (ServerPlayer p : level.m_6907_()) {
                        BlockPos playerPos = p.m_20183_();
                        BlockPos blockPos = playerPos.m_7918_(2, 0, 0);
                        if (!level.m_46859_(blockPos)) continue;
                        level.m_7731_(blockPos, ((Block)ExampleMod.SURVIVAL_BLOCK.get()).m_49966_(), 3);
                        manager.addSurvivalBlock(blockPos, (Level)level);
                        BlockHealthData.initializeBlock(blockPos);
                        if (DifficultyManager.getSelectedDifficulty() == DifficultyManager.Difficulty.TEST) {
                            ScreenNotificationManager.showBuildingNotification(level, "\u00a7e\u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c: \u0421\u0442\u0440\u043e\u0438\u043c \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u043e\u0431\u043e\u0440\u043e\u043d\u0443...");
                            ServerLevel finalLevel = level;
                            BlockPos finalBlockPos = blockPos;
                            new Thread(() -> {
                                try {
                                    Thread.sleep(2000L);
                                    AutoDefenseBuilder.buildTestDefense(finalLevel, finalBlockPos);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                            }).start();
                            continue;
                        }
                        IconNotificationManager.showSafe(level);
                    }
                    manager.startGame((Level)level);
                }
                long timeOfDay = level.m_46468_() % 24000L;
                long dayNumber = level.m_46468_() / 24000L;
                boolean isNight = timeOfDay >= 13000L || timeOfDay <= 1000L;
                boolean bl = isStartOfNight = timeOfDay >= 13000L && timeOfDay <= 13100L;
                if (isStartOfNight && !NightBossBar.getInstance().isActive()) {
                    DifficultyManager.Difficulty difficulty;
                    int maxMobs;
                    long daysElapsed = manager.getDaysElapsed((Level)level);
                    int currentDay = (int)daysElapsed + 1;
                    if (manager.isApocalypseMode()) {
                        currentDay = 80 + random.nextInt(20);
                    }
                    if ((maxMobs = NightMobConfig.getMobCountWithDifficulty(currentDay, difficulty = DifficultyManager.getSelectedDifficulty())) < 5) {
                        maxMobs = 5;
                        for (ServerPlayer player : level.m_6907_()) {
                            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[FIX] \u041b\u0438\u043c\u0438\u0442 \u043c\u043e\u0431\u043e\u0432 \u0431\u044b\u043b \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043c\u0438\u043d\u0438\u043c\u0443\u043c: " + maxMobs)));
                        }
                    }
                    NightBossBar.getInstance().startNight(level, currentDay, maxMobs);
                    for (ServerPlayer player : level.m_6907_()) {
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7e\ud83c\udf19 \u041d\u043e\u0447\u044c " + currentDay + " \u043d\u0430\u0447\u0430\u043b\u0430\u0441\u044c!")));
                        DebugManager.sendDebugMessage(player, "\u041d\u0443\u0436\u043d\u043e \u0443\u0431\u0438\u0442\u044c: " + maxMobs + " \u043c\u043e\u0431\u043e\u0432");
                        DebugManager.sendDebugMessage(player, "\u041c\u043e\u0431\u044b \u0431\u0443\u0434\u0443\u0442 \u0441\u043f\u0430\u0432\u043d\u0438\u0442\u044c\u0441\u044f \u043f\u043e\u0441\u0442\u0435\u043f\u0435\u043d\u043d\u043e");
                        DebugManager.sendDebugMessage(player, "\u0411\u043e\u0441\u0441 \u0431\u0430\u0440 \u0430\u043a\u0442\u0438\u0432\u0435\u043d: " + NightBossBar.getInstance().isActive());
                    }
                }
                timeOfDay = level.m_46468_() % 24000L;
                dayNumber = level.m_46468_() / 24000L;
                isStartOfNight = timeOfDay >= 13000L && timeOfDay <= 13100L;
                boolean bl2 = isDay = timeOfDay >= 1000L && timeOfDay <= 13000L;
                if (isDay && NightBossBar.getInstance().isActive()) {
                    NightBossBar.getInstance().endNight();
                    for (ServerPlayer player : level.m_6907_()) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7e[DAY] \u041d\u0430\u0441\u0442\u0443\u043f\u0438\u043b \u0434\u0435\u043d\u044c! \u0411\u043e\u0441\u0441 \u0431\u0430\u0440 \u0441\u043a\u0440\u044b\u0442."));
                    }
                }
                if (!isNight || !NightBossBar.getInstance().isActive() || tickCount % 40L != 0L) continue;
                SurvivalEventHandler.spawnContinuousMobs(level, manager);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Monster monster;
        Level level;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Monster && (level = (monster = (Monster)livingEntity).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SurvivalManager manager = SurvivalManager.get(level);
            if (manager != null) {
                for (ActiveWave wave : manager.getActiveWaves()) {
                    wave.removeMob(monster.m_20148_());
                }
                if (NightBossBar.getInstance().isActive()) {
                    NightBossBar.getInstance().onMobDied();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player;
        Level level;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SurvivalManager manager = SurvivalManager.get(level);
            if (manager != null && manager.isGameStarted()) {
                boolean hasValidBlocks;
                String playerUUID = player.m_20148_().toString();
                if (manager.isPermanentlyDead(playerUUID)) {
                    player.m_143403_(GameType.SPECTATOR);
                    ScreenNotificationManager.showNotificationToPlayer(player, "\u00a7c\u00a7l\u2620 \u041f\u0415\u0420\u041c\u0410\u041d\u0415\u041d\u0422\u041d\u0410\u042f \u0421\u041c\u0415\u0420\u0422\u042c \u2620", "\u00a7c\u0412\u044b \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0441\u0442\u0430\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0437\u0440\u0438\u0442\u0435\u043b\u044f");
                    return;
                }
                manager.cleanupInvalidBlocks(level);
                boolean bl = hasValidBlocks = !manager.survivalBlocks.isEmpty();
                if (!hasValidBlocks) {
                    manager.addPermanentlyDeadPlayer(playerUUID);
                    player.m_143403_(GameType.SPECTATOR);
                    ScreenNotificationManager.showNotificationToPlayer(player, "\u00a7c\u00a7l\u2620 \u2620 \u2620 \u041f\u0415\u0420\u041c\u0410\u041d\u0415\u041d\u0422\u041d\u0410\u042f \u0421\u041c\u0415\u0420\u0422\u042c \u2620 \u2620 \u2620", "\u00a7c\u0411\u043b\u043e\u043a \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d! \u0418\u0433\u0440\u0430 \u043e\u043a\u043e\u043d\u0447\u0435\u043d\u0430...");
                } else {
                    ScreenNotificationManager.showNotificationToPlayer(player, "\u00a7a\u00a7l\u2713 \u0412\u041e\u0417\u0420\u041e\u0416\u0414\u0415\u041d\u0418\u0415 \u2713", "\u00a7a\u0411\u043b\u043e\u043a \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u0432\u0441\u0435 \u0435\u0449\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d!");
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawn(LivingEvent.LivingTickEvent event) {
        ServerLevel serverLevel;
        SurvivalManager manager;
        Creeper creeper;
        LivingEntity level;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Monster) {
            long currentTime;
            Monster monster = (Monster)livingEntity;
            level = monster.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel2 = (ServerLevel)level;
                if (monster.f_19797_ == 1) {
                    monster.f_21345_.m_25352_(1, (Goal)new AttackSurvivalBlockGoal(monster));
                    monster.m_6710_(null);
                }
                if (monster.f_19797_ % 40 == 0) {
                    if (monster instanceof Skeleton) {
                        Skeleton skeleton = (Skeleton)monster;
                        SmartMobBehavior.improveSkeletonBehavior(skeleton, serverLevel2);
                    } else if (monster instanceof Zombie) {
                        Zombie zombie = (Zombie)monster;
                        SmartMobBehavior.improveZombieBehavior(zombie, serverLevel2);
                    } else if (monster instanceof Creeper) {
                        Creeper creeper2 = (Creeper)monster;
                        SmartMobBehavior.improveCreeperBehavior(creeper2, serverLevel2);
                    }
                }
            }
            if ((currentTime = System.currentTimeMillis()) - lastGolemCheck > 2000L) {
                lastGolemCheck = currentTime;
                cachedIronGolems.clear();
                cachedIronGolems.addAll(level.m_45976_(IronGolem.class, new AABB(0.0, 0.0, 0.0, (double)level.m_151558_(), (double)level.m_151558_(), (double)level.m_151558_())));
                cachedSnowGolems.clear();
                cachedSnowGolems.addAll(level.m_45976_(SnowGolem.class, new AABB(0.0, 0.0, 0.0, (double)level.m_151558_(), (double)level.m_151558_(), (double)level.m_151558_())));
            }
            if (monster.f_19797_ % 60 == 0) {
                cachedIronGolems.removeIf(golem -> !golem.m_6084_());
                cachedSnowGolems.removeIf(golem -> !golem.m_6084_());
                for (IronGolem ironGolem : cachedIronGolems) {
                    GolemBehavior.improveIronGolemBehavior(ironGolem, (ServerLevel)level);
                }
                for (SnowGolem snowGolem : cachedSnowGolems) {
                    GolemBehavior.improveSnowGolemBehavior(snowGolem, (ServerLevel)level);
                }
            }
        }
        if ((level = event.getEntity()) instanceof Creeper && (level = (creeper = (Creeper)level).m_9236_()) instanceof ServerLevel && (manager = SurvivalManager.get((Level)(serverLevel = (ServerLevel)level))) != null) {
            for (ProtectionZone zone : manager.getProtectionZones()) {
                double distance = creeper.m_20275_((double)zone.getCenterBlock().m_123341_(), (double)zone.getCenterBlock().m_123342_(), (double)zone.getCenterBlock().m_123343_());
                if (!(distance < 16.0)) continue;
                zone.handleCreeperExplosion((Level)level, creeper.m_20183_());
                creeper.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onMobSpawnPlacementCheck(MobSpawnEvent.SpawnPlacementCheck event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            boolean gameStarted;
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            long timeOfDay = serverLevel.m_46468_() % 24000L;
            boolean isNight = timeOfDay >= 13000L || timeOfDay <= 1000L;
            SurvivalManager manager = SurvivalManager.get((Level)serverLevel);
            boolean bl = gameStarted = manager != null && manager.isGameStarted();
            if (!gameStarted || !isNight) {
                event.setResult(Event.Result.DENY);
            }
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onMobSpawnAttempt(MobSpawnEvent.FinalizeSpawn event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            boolean gameStarted;
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            long timeOfDay = serverLevel.m_46468_() % 24000L;
            boolean isNight = timeOfDay >= 13000L || timeOfDay <= 1000L;
            SurvivalManager manager = SurvivalManager.get((Level)serverLevel);
            boolean bl = gameStarted = manager != null && manager.isGameStarted();
            if (!gameStarted || !isNight) {
                event.setResult(Event.Result.DENY);
            }
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onMobSpawnPositionCheck(MobSpawnEvent.PositionCheck event) {
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (serverLevelAccessor instanceof ServerLevel) {
            boolean gameStarted;
            ServerLevel serverLevel = (ServerLevel)serverLevelAccessor;
            long timeOfDay = serverLevel.m_46468_() % 24000L;
            boolean isNight = timeOfDay >= 13000L || timeOfDay <= 1000L;
            SurvivalManager manager = SurvivalManager.get((Level)serverLevel);
            boolean bl = gameStarted = manager != null && manager.isGameStarted();
            if (!gameStarted || !isNight) {
                event.setResult(Event.Result.DENY);
            }
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                boolean isDay;
                boolean gameStarted;
                ServerLevel serverLevel = (ServerLevel)entity;
                SurvivalManager manager = SurvivalManager.get((Level)serverLevel);
                boolean bl = gameStarted = manager != null && manager.isGameStarted();
                if (!gameStarted) {
                    return;
                }
                long timeOfDay = serverLevel.m_46468_() % 24000L;
                boolean bl2 = isDay = timeOfDay >= 1000L && timeOfDay <= 13000L;
                if (!monster.m_19880_().contains("CITADEL_GUARD_MOB")) {
                    if (isDay) {
                        monster.m_142687_(Entity.RemovalReason.DISCARDED);
                        for (ServerPlayer player : serverLevel.m_6907_()) {
                            DebugManager.sendDebugMessage(player, "\u0423\u0434\u0430\u043b\u0435\u043d \u0447\u0443\u0436\u043e\u0439 \u043c\u043e\u0431 \u0434\u043d\u0435\u043c: " + monster.m_6095_().m_20676_().getString());
                        }
                    }
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        int removedCount;
        Level level;
        NightBossBar bossBar;
        String message = event.getMessage().getString().toLowerCase();
        ServerPlayer player = event.getPlayer();
        if (message.equals("!\u043d\u043e\u0447\u044c") || message.equals("!night")) {
            event.setCanceled(true);
            bossBar = NightBossBar.getInstance();
            if (bossBar.isActive()) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l=== \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u042f \u041e \u041d\u041e\u0427\u0418 ==="));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u041d\u043e\u0447\u044c: \u00a7e" + bossBar.getCurrentNight())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0423\u0431\u0438\u0442\u043e: \u00a7a" + bossBar.getKilledMobs() + "\u00a77/\u00a7e" + bossBar.getMaxMobs())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0417\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e: \u00a7e" + bossBar.getSpawnedMobs() + "\u00a77/\u00a7e" + bossBar.getMaxMobs())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0416\u0438\u0432\u044b\u0445: \u00a7c" + bossBar.getAliveMobs())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u041c\u043e\u0436\u043d\u043e \u0441\u043f\u0430\u0432\u043d\u0438\u0442\u044c: \u00a7e" + bossBar.canSpawnMore())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0410\u043a\u0442\u0438\u0432\u0435\u043d: \u00a7e" + bossBar.isActive())));
                boolean condition1 = bossBar.getKilledMobs() >= bossBar.getMaxMobs();
                boolean condition2 = bossBar.getMaxMobs() > 0;
                boolean condition3 = bossBar.getSpawnedMobs() > 0;
                DebugManager.sendDebugMessage(player, "\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f: " + condition1 + " && " + condition2 + " && " + condition3);
                player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l========================"));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u041d\u043e\u0447\u043d\u043e\u0439 \u0431\u043e\u0441\u0441 \u0431\u0430\u0440 \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d"));
            }
        }
        if (message.equals("!\u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c") || message.equals("!end")) {
            event.setCanceled(true);
            if (NightBossBar.getInstance().isActive()) {
                NightBossBar.getInstance().forceEndNight();
                DebugManager.sendDebugMessage(player, "\u041d\u043e\u0447\u044c \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u041d\u043e\u0447\u043d\u043e\u0439 \u0431\u043e\u0441\u0441 \u0431\u0430\u0440 \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d"));
            }
        }
        if (message.equals("!\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c") || message.equals("!clear")) {
            event.setCanceled(true);
            level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                removedCount = 0;
                for (Monster monster : serverLevel.m_45976_(Monster.class, new AABB(-1000.0, -256.0, -1000.0, 1000.0, 256.0, 1000.0))) {
                    if (monster.m_19880_().contains("CITADEL_GUARD_MOB")) continue;
                    monster.m_142687_(Entity.RemovalReason.DISCARDED);
                    ++removedCount;
                }
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[CLEAR] \u0423\u0434\u0430\u043b\u0435\u043d\u043e " + removedCount + " \u0447\u0443\u0436\u0438\u0445 \u043c\u043e\u0431\u043e\u0432")));
            }
        }
        if (message.equals("!\u0443\u0431\u0440\u0430\u0442\u044c") || message.equals("!killall")) {
            event.setCanceled(true);
            level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                removedCount = 0;
                BlockPos playerPos = player.m_20183_();
                AABB searchArea = new AABB((double)(playerPos.m_123341_() - 150), (double)(playerPos.m_123342_() - 75), (double)(playerPos.m_123343_() - 150), (double)(playerPos.m_123341_() + 150), (double)(playerPos.m_123342_() + 75), (double)(playerPos.m_123343_() + 150));
                for (Monster monster : serverLevel.m_45976_(Monster.class, searchArea)) {
                    monster.m_142687_(Entity.RemovalReason.DISCARDED);
                    ++removedCount;
                }
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[KILLALL] \u0423\u0434\u0430\u043b\u0435\u043d\u043e " + removedCount + " \u043c\u043e\u0431\u043e\u0432 \u0432 \u0440\u0430\u0434\u0438\u0443\u0441\u0435 150 \u0431\u043b\u043e\u043a\u043e\u0432")));
            }
        }
        if (message.equals("!\u0441\u0431\u0440\u043e\u0441") || message.equals("!reset")) {
            event.setCanceled(true);
            bossBar = NightBossBar.getInstance();
            if (bossBar.isActive()) {
                bossBar.resetCounters();
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7e[RESET] \u0421\u0447\u0435\u0442\u0447\u0438\u043a\u0438 \u0431\u043e\u0441\u0441 \u0431\u0430\u0440\u0430 \u0441\u0431\u0440\u043e\u0448\u0435\u043d\u044b"));
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u041d\u043e\u0447\u043d\u043e\u0439 \u0431\u043e\u0441\u0441 \u0431\u0430\u0440 \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d"));
            }
        }
        if (message.equals("!\u0442\u0435\u0441\u0442_\u043d\u043e\u0447\u044c") || message.equals("!test_night")) {
            event.setCanceled(true);
            if (DifficultyManager.getSelectedDifficulty() != DifficultyManager.Difficulty.TEST) {
                player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[ERROR] \u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 TEST!"));
                return;
            }
            level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (NightBossBar.getInstance().isActive()) {
                    NightBossBar.getInstance().forceEndNight();
                }
                int testNight = 1 + random.nextInt(10);
                int testMobCount = 3 + random.nextInt(8);
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[TEST] \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u0435\u043c \u0442\u0435\u0441\u0442\u043e\u0432\u0443\u044e \u043d\u043e\u0447\u044c " + testNight + " \u0441 " + testMobCount + " \u043c\u043e\u0431\u0430\u043c\u0438")));
                NightBossBar.getInstance().startNight(serverLevel, testNight, testMobCount);
                Object manager = SurvivalManager.get((Level)serverLevel);
                if (manager != null) {
                    int n = Math.min(testMobCount, 3);
                    SurvivalEventHandler.spawnWaveOfMobs(serverLevel, manager, n);
                }
            }
        }
        if (message.equals("!\u0432\u043e\u043b\u043d\u0430") || message.equals("!wave")) {
            event.setCanceled(true);
            level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SurvivalManager manager = SurvivalManager.get(level);
                if (manager != null) {
                    List<ActiveWave> activeWaves = manager.getActiveWaves();
                    if (activeWaves.isEmpty()) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0432\u043e\u043b\u043d \u043d\u0435\u0442"));
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l=== \u0410\u041a\u0422\u0418\u0412\u041d\u042b\u0415 \u0412\u041e\u041b\u041d\u042b ==="));
                        for (ActiveWave activeWave : activeWaves) {
                            int remainingMobs = activeWave.getRemainingMobCount();
                            player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0412\u043e\u043b\u043d\u0430 " + activeWave.getDay() + ": \u00a7e" + remainingMobs + " \u00a77\u043c\u043e\u0431\u043e\u0432")));
                        }
                    }
                }
            }
        }
        if (message.equals("!\u043c\u043e\u0431\u044b") || message.equals("!mobs")) {
            event.setCanceled(true);
            level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SurvivalManager manager = SurvivalManager.get(level);
                if (manager != null) {
                    List<ActiveWave> activeWaves = manager.getActiveWaves();
                    if (activeWaves.isEmpty()) {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0432\u043e\u043b\u043d \u043d\u0435\u0442"));
                    } else {
                        int totalMobs = 0;
                        for (ActiveWave wave : activeWaves) {
                            int remainingMobs = wave.getRemainingMobCount();
                            totalMobs += remainingMobs;
                            String waveType = wave.isBigWave() ? "\u00a74\u0411\u043e\u043b\u044c\u0448\u0430\u044f" : "\u00a7a\u041e\u0431\u044b\u0447\u043d\u0430\u044f";
                            player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0412\u043e\u043b\u043d\u0430 " + wave.getDay() + " (" + waveType + "\u00a77): \u00a7e" + remainingMobs + " \u00a77\u043c\u043e\u0431\u043e\u0432")));
                        }
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a76\u0412\u0441\u0435\u0433\u043e \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043c\u043e\u0431\u043e\u0432: \u00a7e" + totalMobs)));
                    }
                }
            }
        }
        if (message.equals("!\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c") || message.equals("!perf")) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l=== \u041f\u0420\u041e\u0418\u0417\u0412\u041e\u0414\u0418\u0422\u0415\u041b\u042c\u041d\u041e\u0421\u0422\u042c ==="));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a77" + PerformanceManager.getPerformanceStats())));
            player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u0412\u044b\u0441\u043e\u043a\u0430\u044f \u043d\u0430\u0433\u0440\u0443\u0437\u043a\u0430: \u00a7" + (PerformanceManager.isServerUnderHighLoad() ? "c\u2717" : "a\u2713"))));
            BlockPos playerPos = player.m_20183_();
            int nearbyMobs = PerformanceManager.countMobsInArea((ServerLevel)player.m_9236_(), playerPos, 100);
            player.m_213846_((Component)Component.m_237113_((String)("\u00a77\u041c\u043e\u0431\u043e\u0432 \u0432 \u0440\u0430\u0434\u0438\u0443\u0441\u0435 100 \u0431\u043b\u043e\u043a\u043e\u0432: \u00a7e" + nearbyMobs)));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l========================"));
        }
        if (message.equals("!\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c_\u043a\u044d\u0448") || message.equals("!clearcache")) {
            event.setCanceled(true);
            PerformanceManager.clearCache();
            survivalBlocksCache.clear();
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[CACHE] \u041a\u044d\u0448 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0447\u0438\u0449\u0435\u043d"));
        }
        if (message.equals("!\u043e\u0442\u043b\u0430\u0434\u043a\u0430") || message.equals("!debug")) {
            event.setCanceled(true);
            DebugManager.toggleDebug(player);
        }
        if (message.equals("!\u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c") || message.equals("!restore")) {
            event.setCanceled(true);
            level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SurvivalManager manager = SurvivalManager.get(level);
                if (manager != null && manager.isGameStarted()) {
                    boolean bl;
                    long timeOfDay = level.m_46468_() % 24000L;
                    boolean bl2 = bl = timeOfDay >= 13000L || timeOfDay <= 1000L;
                    if (bl) {
                        DifficultyManager.Difficulty difficulty;
                        long daysElapsed;
                        int currentDay;
                        int maxMobs;
                        if (NightBossBar.getInstance().isActive()) {
                            NightBossBar.getInstance().forceEndNight();
                        }
                        if ((maxMobs = NightMobConfig.getMobCountWithDifficulty(currentDay = (int)(daysElapsed = manager.getDaysElapsed(level)) + 1, difficulty = DifficultyManager.getSelectedDifficulty())) < 5) {
                            maxMobs = 5;
                        }
                        NightBossBar.getInstance().startNight(serverLevel, currentDay, maxMobs);
                        NightBossBar.getInstance().addPlayer(player);
                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7a[RESTORE] \u041d\u043e\u0447\u044c " + currentDay + " \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430!")));
                    } else {
                        player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[ERROR] \u0421\u0435\u0439\u0447\u0430\u0441 \u0434\u0435\u043d\u044c! \u041d\u043e\u0447\u044c \u043c\u043e\u0436\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u043e\u0447\u044c\u044e."));
                    }
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[ERROR] \u0418\u0433\u0440\u0430 \u043d\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u0430!"));
                }
            }
        }
        if (message.equals("!\u043f\u043e\u043c\u043e\u0449\u044c") || message.equals("!help")) {
            event.setCanceled(true);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l=== \u041a\u041e\u041c\u0410\u041d\u0414\u042b \u0412\u042b\u0416\u0418\u0412\u0410\u041d\u0418\u042f ==="));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e!\u0432\u043e\u043b\u043d\u0430 \u00a77- \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0432\u043e\u043b\u043d\u0430\u0445"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e!\u043c\u043e\u0431\u044b \u00a77- \u041a\u0440\u0430\u0442\u043a\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043c\u043e\u0431\u0430\u0445"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e!\u043d\u043e\u0447\u044c \u00a77- \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043d\u043e\u0447\u043d\u043e\u043c \u0431\u043e\u0441\u0441 \u0431\u0430\u0440\u0435"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e!\u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u00a77- \u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u043d\u043e\u0447\u044c"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c!\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u00a77- \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0447\u0443\u0436\u0438\u0445 \u043c\u043e\u0431\u043e\u0432"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a74!\u0443\u0431\u0440\u0430\u0442\u044c \u00a77- \u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0412\u0421\u0415\u0425 \u043c\u043e\u0431\u043e\u0432"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a76!\u0441\u0431\u0440\u043e\u0441 \u00a77- \u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0441\u0447\u0435\u0442\u0447\u0438\u043a\u0438 \u0431\u043e\u0441\u0441 \u0431\u0430\u0440\u0430"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7b!\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u00a77- \u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7d!\u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c_\u043a\u044d\u0448 \u00a77- \u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043a\u044d\u0448 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a79!\u043e\u0442\u043b\u0430\u0434\u043a\u0430 \u00a77- \u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c/\u0432\u044b\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043e\u0442\u043b\u0430\u0434\u043e\u0447\u043d\u044b\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a75!\u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u00a77- \u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0447\u043d\u0443\u044e \u0430\u0442\u0430\u043a\u0443"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e!\u043f\u043e\u043c\u043e\u0449\u044c \u00a77- \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u044d\u0442\u0443 \u0441\u043f\u0440\u0430\u0432\u043a\u0443"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l========================"));
        }
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof Arrow) {
            Arrow arrow = (Arrow)projectile;
            projectile = event.getRayTraceResult();
            if (projectile instanceof BlockHitResult) {
                BlockPos hitPos;
                BlockHitResult blockHit = (BlockHitResult)projectile;
                Level level = arrow.m_9236_();
                if (level.m_8055_(hitPos = blockHit.m_82425_()).m_60734_() instanceof SurvivalBlock && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (BlockHealthData.damageBlock(hitPos, (Level)serverLevel)) {
                        level.m_7471_(hitPos, false);
                        IconNotificationManager.showBlockAttacked(serverLevel);
                    } else {
                        int currentHealth = BlockHealthData.getHealth(hitPos);
                        for (ServerPlayer player : serverLevel.m_6907_()) {
                            player.m_213846_((Component)Component.m_237113_((String)("\u00a7e\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435: " + currentHealth + "%")));
                        }
                        BlockHealthMonitor.forceShowHealthIcon(serverLevel, hitPos);
                    }
                    arrow.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemTossed(ItemTossEvent event) {
        ServerLevel serverLevel;
        SurvivalManager manager;
        ServerPlayer player;
        Level level;
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && (level = (player = (ServerPlayer)player2).m_9236_()) instanceof ServerLevel && (manager = SurvivalManager.get((Level)(serverLevel = (ServerLevel)level))) != null) {
            BlockPos itemPos = event.getEntity().m_20183_();
            for (BlockPos blockPos : manager.survivalBlocks) {
                ItemStack itemStack;
                int value;
                double distance = itemPos.m_123331_((Vec3i)blockPos);
                if (!(distance <= 9.0) || (value = SurvivalEventHandler.getResourceValue(itemStack = event.getEntity().m_32055_())) <= 0) continue;
                event.getEntity().m_142687_(Entity.RemovalReason.DISCARDED);
                SurvivalEventHandler.addResourcePoints(serverLevel, blockPos, value, itemStack.m_41613_());
                int totalValue = value * itemStack.m_41613_();
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7a+" + totalValue + " \u043e\u0447\u043a\u043e\u0432 \u00a77(" + itemStack.m_41611_().getString() + " x" + itemStack.m_41613_() + ")")));
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (event.getLevel().m_8055_(event.getPos()).m_60734_() instanceof SurvivalBlock && player2.m_6144_()) {
                event.setCanceled(true);
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l=== \u0418\u041d\u0424\u041e\u0420\u041c\u0410\u0426\u0418\u042f \u041e \u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0418 ==="));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a77\u0426\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432:"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u2022 \u041a\u0430\u043c\u0435\u043d\u044c/\u0411\u0443\u043b\u044b\u0436\u043d\u0438\u043a: \u00a771 \u043e\u0447\u043a\u043e"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u2022 \u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0439 \u0441\u043b\u0438\u0442\u043e\u043a: \u00a775 \u043e\u0447\u043a\u043e\u0432"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u2022 \u0417\u043e\u043b\u043e\u0442\u043e\u0439 \u0441\u043b\u0438\u0442\u043e\u043a: \u00a7610 \u043e\u0447\u043a\u043e\u0432"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u2022 \u0410\u043b\u043c\u0430\u0437: \u00a7b25 \u043e\u0447\u043a\u043e\u0432"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u2022 \u0418\u0437\u0443\u043c\u0440\u0443\u0434: \u00a7a30 \u043e\u0447\u043a\u043e\u0432"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u2022 \u041e\u0431\u0441\u0438\u0434\u0438\u0430\u043d: \u00a7515 \u043e\u0447\u043a\u043e\u0432"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u2022 \u041d\u0435\u0437\u0435\u0440\u0438\u0442\u043e\u0432\u044b\u0439 \u0441\u043b\u0438\u0442\u043e\u043a: \u00a7d100 \u043e\u0447\u043a\u043e\u0432"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l=============================="));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a7e\u041a\u0430\u0436\u0434\u044b\u0435 100 \u043e\u0447\u043a\u043e\u0432 = +5 \u0431\u043b\u043e\u043a\u043e\u0432 \u0440\u0430\u0434\u0438\u0443\u0441\u0430"));
                player2.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u041f\u0440\u043e\u0441\u0442\u043e \u043a\u0438\u0434\u0430\u0439\u0442\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b \u0432 \u0431\u043b\u043e\u043a!"));
                return;
            }
        }
    }

    private static int getResourceValue(ItemStack stack) {
        if (stack.m_41720_() == Items.f_41905_ || stack.m_41720_() == Items.f_42594_) {
            return 1;
        }
        if (stack.m_41720_() == Items.f_42416_) {
            return 5;
        }
        if (stack.m_41720_() == Items.f_42417_) {
            return 10;
        }
        if (stack.m_41720_() == Items.f_42415_) {
            return 25;
        }
        if (stack.m_41720_() == Items.f_42616_) {
            return 30;
        }
        if (stack.m_41720_() == Items.f_41999_) {
            return 15;
        }
        if (stack.m_41720_() == Items.f_42418_) {
            return 100;
        }
        return 0;
    }

    private static void addResourcePoints(ServerLevel level, BlockPos blockPos, int valuePerItem, int count) {
        int currentRadius;
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return;
        }
        int totalValue = valuePerItem * count;
        int currentPoints = SurvivalEventHandler.getBlockPoints(blockPos);
        int newPoints = currentPoints + totalValue;
        int newRadius = 10 + newPoints / 100 * 5;
        if (newRadius > (currentRadius = SurvivalEventHandler.getCurrentRadius(manager, blockPos)) && newRadius <= 50) {
            for (ProtectionZone zone : manager.getProtectionZones()) {
                if (!zone.getCenterBlock().equals((Object)blockPos)) continue;
                zone.setRadius(newRadius);
                for (ServerPlayer player : level.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)("\u00a7a\u00a7l[\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u0415] \u00a7e\u0420\u0430\u0434\u0438\u0443\u0441 \u0437\u0430\u0449\u0438\u0442\u044b: \u00a7a" + newRadius + " \u00a7e\u0431\u043b\u043e\u043a\u043e\u0432!")));
                }
            }
        }
        SurvivalEventHandler.setBlockPoints(blockPos, newPoints);
    }

    private static int getBlockPoints(BlockPos pos) {
        return 0;
    }

    private static void setBlockPoints(BlockPos pos, int points) {
    }

    private static int getCurrentRadius(SurvivalManager manager, BlockPos blockPos) {
        for (ProtectionZone zone : manager.getProtectionZones()) {
            if (!zone.getCenterBlock().equals((Object)blockPos)) continue;
            return zone.getRadius();
        }
        return 10;
    }

    private static boolean isPositionInProtectedZone(ServerLevel level, BlockPos pos) {
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return false;
        }
        for (ProtectionZone zone : manager.getProtectionZones()) {
            if (!zone.isInZone(pos)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPositionInProtectedZone(ServerLevel level, int x, int y, int z) {
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return false;
        }
        for (ProtectionZone zone : manager.getProtectionZones()) {
            if (!zone.isInZone(x, y, z)) continue;
            return true;
        }
        return false;
    }

    private static void cleanProtectionZones(ServerLevel level) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastZoneCleanCheck < 5000L) {
            return;
        }
        lastZoneCleanCheck = currentTime;
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null || manager.getProtectionZones().isEmpty()) {
            return;
        }
        List<ProtectionZone> zones = manager.getProtectionZones();
        int maxZonesToProcess = Math.min(3, zones.size());
        for (int i = 0; i < maxZonesToProcess; ++i) {
            ProtectionZone zone = zones.get(i);
            BlockPos center = zone.getCenterBlock();
            int radius = Math.min(zone.getRadius(), 50);
            AABB zoneBounds = new AABB((double)(center.m_123341_() - radius), (double)(center.m_123342_() - 5), (double)(center.m_123343_() - radius), (double)(center.m_123341_() + radius), (double)(center.m_123342_() + 5), (double)(center.m_123343_() + radius));
            List monsters = level.m_45976_(Monster.class, zoneBounds);
            int maxMobsToProcess = Math.min(10, monsters.size());
            for (int j = 0; j < maxMobsToProcess; ++j) {
                Monster monster = (Monster)monsters.get(j);
            }
        }
    }

    private static int calculateExpectedMobsForNight(int day) {
        int baseMobs = Math.min(10 + day * 2, 100);
        DifficultyManager.Difficulty difficulty = DifficultyManager.getSelectedDifficulty();
        double multiplier = switch (difficulty) {
            default -> throw new IncompatibleClassChangeError();
            case DifficultyManager.Difficulty.NOVICE -> 1.0;
            case DifficultyManager.Difficulty.EXPERIENCED -> 1.5;
            case DifficultyManager.Difficulty.MONSTER -> 2.0;
            case DifficultyManager.Difficulty.DEATH -> 3.0;
            case DifficultyManager.Difficulty.TEST -> 0.5;
        };
        return (int)((double)baseMobs * multiplier);
    }

    private static void spawnWaveOfMobs(ServerLevel level, SurvivalManager manager, int mobCount) {
        if (manager.survivalBlocks.isEmpty()) {
            return;
        }
        NightBossBar bossBar = NightBossBar.getInstance();
        int remainingToKill = bossBar.getMaxMobs() - bossBar.getKilledMobs();
        int actualMobCount = mobCount;
        if (remainingToKill <= 0) {
            for (ServerPlayer player : level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76[INFO] \u041b\u0438\u043c\u0438\u0442 \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442, \u043d\u043e \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0435\u043c \u0441\u043f\u0430\u0432\u043d! \u0423\u0431\u0438\u0442\u043e: " + bossBar.getKilledMobs() + "/" + bossBar.getMaxMobs())));
            }
        }
        int successfullySpawned = 0;
        for (ServerPlayer player : level.m_6907_()) {
            DebugManager.sendDebugMessage(player, "\u041d\u0435\u043f\u0440\u0435\u0440\u044b\u0432\u043d\u044b\u0439 \u0441\u043f\u0430\u0432\u043d: " + actualMobCount + " \u043c\u043e\u0431\u043e\u0432 (\u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u043f\u043e \u043f\u043b\u0430\u043d\u0443: " + remainingToKill + ")");
        }
        List<BlockPos> survivalBlocks = SurvivalEventHandler.getCachedSurvivalBlocks(level, manager);
        int batchSize = Math.min(5, actualMobCount);
        for (int batch = 0; batch < actualMobCount; batch += batchSize) {
            int mobsInBatch = Math.min(batchSize, actualMobCount - batch);
            block5: for (int i = 0; i < mobsInBatch; ++i) {
                boolean spawned = false;
                for (BlockPos blockPos : survivalBlocks) {
                    if (!SurvivalEventHandler.spawnSingleNightMob(level, blockPos)) continue;
                    bossBar.onMobSpawned();
                    ++successfullySpawned;
                    spawned = true;
                    break;
                }
                if (spawned) continue;
                for (BlockPos blockPos : survivalBlocks) {
                    if (!SurvivalEventHandler.spawnSingleNightMobExtended(level, blockPos)) continue;
                    bossBar.onMobSpawned();
                    ++successfullySpawned;
                    continue block5;
                }
            }
            if (batch + batchSize >= actualMobCount) continue;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        for (ServerPlayer player : level.m_6907_()) {
            DebugManager.sendDebugMessage(player, "\u0417\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e " + successfullySpawned + "/" + actualMobCount + " \u043c\u043e\u0431\u043e\u0432");
        }
    }

    private static void spawnContinuousMobs(ServerLevel level, SurvivalManager manager) {
        long currentNightTime;
        long nightLength;
        long remainingNightTime;
        int intervalsLeft;
        int mobsPerInterval;
        int totalMobsToSpawn;
        boolean isEarlyNight;
        NightBossBar bossBar = NightBossBar.getInstance();
        int aliveMobs = SurvivalEventHandler.countAliveMobsOptimized(level, manager);
        bossBar.updateAliveMobs(aliveMobs);
        long timeOfDay = level.m_46468_() % 24000L;
        boolean isNight = timeOfDay >= 13000L || timeOfDay <= 1000L;
        boolean bossBarActive = bossBar.isActive();
        boolean bl = isEarlyNight = timeOfDay >= 13000L && timeOfDay <= 13600L;
        if (isNight && bossBarActive && !isEarlyNight && (totalMobsToSpawn = bossBar.getMaxMobs() - bossBar.getSpawnedMobs()) > 0 && (mobsPerInterval = Math.max(10, totalMobsToSpawn / (intervalsLeft = Math.max(1, (int)((remainingNightTime = (nightLength = 12000L) - (currentNightTime = timeOfDay >= 13000L ? timeOfDay - 13000L : 11000L + timeOfDay)) / 40L))))) > 0) {
            DebugManager.sendDebugMessageToAll(level, "\u041d\u0435\u043f\u0440\u0435\u0440\u044b\u0432\u043d\u044b\u0439 \u0441\u043f\u0430\u0432\u043d: " + mobsPerInterval + " \u043c\u043e\u0431\u043e\u0432. \u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0438\u0442\u044c: " + totalMobsToSpawn + ", \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u043e\u0432 \u0434\u043e \u0443\u0442\u0440\u0430: " + intervalsLeft + ", \u0436\u0438\u0432\u044b\u0445 \u0441\u0435\u0439\u0447\u0430\u0441: " + aliveMobs);
            SurvivalEventHandler.spawnWaveOfMobs(level, manager, mobsPerInterval);
        }
    }

    private static void checkAndSpawnNewWave(ServerLevel level, SurvivalManager manager) {
        SurvivalEventHandler.spawnContinuousMobs(level, manager);
    }

    private static int calculateAdaptiveWaveSize(int remainingMobs, int totalMobs) {
        if (totalMobs <= 10) {
            return Math.min(remainingMobs, 2);
        }
        if (totalMobs <= 50) {
            return Math.min(remainingMobs, 5);
        }
        if (totalMobs <= 200) {
            return Math.min(remainingMobs, 10);
        }
        if (totalMobs <= 500) {
            return Math.min(remainingMobs, 20);
        }
        if (totalMobs <= 1000) {
            return Math.min(remainingMobs, 30);
        }
        return Math.min(remainingMobs, 50);
    }

    private static void spawnNightMobs(ServerLevel level, SurvivalManager manager) {
    }

    private static boolean spawnSingleNightMob(ServerLevel level, BlockPos centerPos) {
        int minDistance = 25;
        int maxDistance = 50;
        for (int attempt = 0; attempt < 10; ++attempt) {
            int distance = minDistance + random.nextInt(maxDistance - minDistance + 1);
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int x = centerPos.m_123341_() + (int)(Math.cos(angle) * (double)distance);
            int z = centerPos.m_123343_() + (int)(Math.sin(angle) * (double)distance);
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
            BlockPos spawnPos = new BlockPos(x, y, z);
            SurvivalManager manager = SurvivalManager.get((Level)level);
            if (manager != null && SurvivalEventHandler.isPositionInProtectedZone(level, spawnPos) || !level.m_46859_(spawnPos) || !level.m_46859_(spawnPos.m_7494_())) continue;
            EntityType[] mobTypes = new EntityType[]{EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20558_, EntityType.f_20479_};
            EntityType mobType = mobTypes[random.nextInt(mobTypes.length)];
            try {
                Entity entity = mobType.m_20615_((Level)level);
                if (!(entity instanceof Monster)) continue;
                Monster monster = (Monster)entity;
                monster.m_20049_("CITADEL_GUARD_MOB");
                monster.m_6027_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                level.m_7967_((Entity)monster);
                for (ServerPlayer player : level.m_6907_()) {
                    player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a7a[SPAWN] %s \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d \u043d\u0430 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0438 %d \u0431\u043b\u043e\u043a\u043e\u0432", mobType.m_20676_().getString(), distance)));
                }
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (ServerPlayer player : level.m_6907_()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c[SPAWN] \u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0431\u0435\u0437\u043e\u043f\u0430\u0441\u043d\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e \u0434\u043b\u044f \u0441\u043f\u0430\u0432\u043d\u0430 \u043c\u043e\u0431\u0430"));
        }
        return false;
    }

    private static boolean spawnSingleNightMobExtended(ServerLevel level, BlockPos centerPos) {
        int minDistance = 30;
        int maxDistance = 80;
        for (int attempt = 0; attempt < 20; ++attempt) {
            int distance = minDistance + random.nextInt(maxDistance - minDistance + 1);
            double angle = random.nextDouble() * 2.0 * Math.PI;
            int x = centerPos.m_123341_() + (int)(Math.cos(angle) * (double)distance);
            int z = centerPos.m_123343_() + (int)(Math.sin(angle) * (double)distance);
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
            BlockPos spawnPos = new BlockPos(x, y, z);
            SurvivalManager manager = SurvivalManager.get((Level)level);
            if (manager != null && SurvivalEventHandler.isPositionInProtectedZone(level, spawnPos)) continue;
            if (!level.m_46859_(spawnPos)) {
                spawnPos = spawnPos.m_7494_();
            }
            EntityType[] mobTypes = new EntityType[]{EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20558_, EntityType.f_20479_};
            EntityType mobType = mobTypes[random.nextInt(mobTypes.length)];
            try {
                Entity entity = mobType.m_20615_((Level)level);
                if (!(entity instanceof Monster)) continue;
                Monster monster = (Monster)entity;
                monster.m_20049_("CITADEL_GUARD_MOB");
                monster.m_6027_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5);
                level.m_7967_((Entity)monster);
                return true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    private static void syncNightBossBar(ServerLevel level) {
        if (!NightBossBar.getInstance().isActive()) {
            return;
        }
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null || manager.survivalBlocks.isEmpty()) {
            return;
        }
        int totalMobs = 0;
        for (BlockPos blockPos : manager.survivalBlocks) {
            AABB searchArea = new AABB((double)(blockPos.m_123341_() - 100), (double)(blockPos.m_123342_() - 50), (double)(blockPos.m_123343_() - 100), (double)(blockPos.m_123341_() + 100), (double)(blockPos.m_123342_() + 50), (double)(blockPos.m_123343_() + 100));
            for (Monster monster : level.m_45976_(Monster.class, searchArea)) {
                ++totalMobs;
            }
        }
        NightBossBar.getInstance().updateAliveMobs(totalMobs);
        if (level.m_46467_() % 1000L == 0L) {
            for (ServerPlayer player : level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76[SYNC] \u041d\u0430\u0439\u0434\u0435\u043d\u043e " + totalMobs + " \u043c\u043e\u0431\u043e\u0432 \u0432 \u0440\u0430\u0434\u0438\u0443\u0441\u0435 \u0431\u043b\u043e\u043a\u043e\u0432 \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f")));
            }
        }
    }

    private static void checkNightEnd(ServerLevel level) {
        if (!NightBossBar.getInstance().isActive()) {
            return;
        }
        long timeOfDay = level.m_46468_() % 24000L;
        if (timeOfDay >= 0L && timeOfDay <= 1000L) {
            NightBossBar.getInstance().endNight();
        }
    }

    private static int countAliveMobsOptimized(ServerLevel level, SurvivalManager manager) {
        return PerformanceManager.getCachedOrCompute("aliveMobCount", () -> {
            int totalMobs = 0;
            List<BlockPos> survivalBlocks = SurvivalEventHandler.getCachedSurvivalBlocks(level, manager);
            for (BlockPos blockPos : survivalBlocks) {
                List<Monster> nearbyMobs = PerformanceManager.getNearbyMobs(level, blockPos, 80, 30);
                for (Monster monster : nearbyMobs) {
                    if (!monster.m_19880_().contains("CITADEL_GUARD_MOB") || !monster.m_6084_()) continue;
                    ++totalMobs;
                }
            }
            return totalMobs;
        }, 1000L);
    }

    private static List<BlockPos> getCachedSurvivalBlocks(ServerLevel level, SurvivalManager manager) {
        String levelKey = level.m_46472_().m_135782_().toString();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastSurvivalBlocksCacheUpdate > 5000L) {
            survivalBlocksCache.clear();
            lastSurvivalBlocksCacheUpdate = currentTime;
        }
        return survivalBlocksCache.computeIfAbsent(levelKey, k -> new ArrayList<BlockPos>(manager.survivalBlocks));
    }

    private static boolean isPositionInProtectedZoneOptimized(ServerLevel level, BlockPos pos) {
        Boolean cached;
        String key = pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastProtectionCacheClean > 30000L) {
            protectionZoneCache.clear();
            lastProtectionCacheClean = currentTime;
        }
        if ((cached = protectionZoneCache.get(key)) != null) {
            return cached;
        }
        boolean result = SurvivalEventHandler.isPositionInProtectedZone(level, pos);
        protectionZoneCache.put(key, result);
        return result;
    }

    private static BlockPos getPooledBlockPos(int x, int y, int z) {
        BlockPos pos = blockPosPool.poll();
        if (pos != null) {
            return new BlockPos(x, y, z);
        }
        return new BlockPos(x, y, z);
    }

    private static void returnToPool(BlockPos pos) {
        if (blockPosPool.size() < 100) {
            blockPosPool.offer(pos);
        }
    }

    private static void queueParticle(ServerLevel level, double x, double y, double z) {
        pendingParticles.add(new ParticleRequest(level, x, y, z));
    }

    private static void processPendingParticles() {
        if (pendingParticles.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Iterator<ParticleRequest> iterator = pendingParticles.iterator();
        while (iterator.hasNext()) {
            ParticleRequest request = iterator.next();
            if (currentTime - request.timestamp > 5000L) {
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    public static class AttackSurvivalBlockGoal
    extends Goal {
        private final Monster monster;
        private BlockPos targetBlock;
        private int attackTime;
        private int searchRadius = 1000;
        private static final Map<String, BlockPos> healthBlockCache = new ConcurrentHashMap<String, BlockPos>();
        private static long lastHealthBlockCacheUpdate = 0L;

        public AttackSurvivalBlockGoal(Monster monster) {
            this.monster = monster;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            ServerLevel serverLevel;
            SurvivalManager manager;
            BlockPos pos = this.monster.m_20183_();
            Level level = this.monster.m_9236_();
            if (level instanceof ServerLevel && (manager = SurvivalManager.get((Level)(serverLevel = (ServerLevel)level))) != null) {
                this.targetBlock = this.findNearestHealthBoostBlock(level, pos);
                if (this.targetBlock != null) {
                    return true;
                }
                for (ProtectionZone zone : manager.getProtectionZones()) {
                    BlockPos center = zone.getCenterBlock();
                    double distance = pos.m_123331_((Vec3i)center);
                    if (!(distance <= (double)(this.searchRadius * this.searchRadius))) continue;
                    this.targetBlock = center;
                    return true;
                }
            }
            return false;
        }

        public void m_8041_() {
            this.targetBlock = null;
        }

        public boolean m_8045_() {
            if (this.targetBlock == null) {
                return false;
            }
            BlockState state = this.monster.m_9236_().m_8055_(this.targetBlock);
            boolean isValidTarget = state.m_60734_() instanceof SurvivalBlock || state.m_60734_() instanceof HealthBoostBlock;
            return isValidTarget && this.monster.m_20275_((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_()) < 256.0;
        }

        public void m_8056_() {
            if (this.targetBlock != null) {
                this.monster.m_6710_(null);
                this.monster.m_21573_().m_26519_((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_(), 1.5);
                this.attackTime = 0;
            }
        }

        public void m_8037_() {
            if (this.targetBlock != null) {
                this.monster.m_21563_().m_24946_((double)this.targetBlock.m_123341_() + 0.5, (double)this.targetBlock.m_123342_() + 0.5, (double)this.targetBlock.m_123343_() + 0.5);
                if (this.monster.m_20275_((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_()) < 4.0) {
                    ++this.attackTime;
                    if (this.attackTime >= 20) {
                        BlockState state = this.monster.m_9236_().m_8055_(this.targetBlock);
                        if (state.m_60734_() instanceof HealthBoostBlock) {
                            Level level = this.monster.m_9236_();
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                IconNotificationManager.showBlockAttacked(serverLevel);
                            }
                            this.monster.m_9236_().m_46961_(this.targetBlock, true);
                            this.targetBlock = this.findNearestHealthBoostBlock(this.monster.m_9236_(), this.monster.m_20183_());
                            if (this.targetBlock == null) {
                                this.targetBlock = this.findMainSurvivalBlock(this.monster.m_9236_(), this.monster.m_20183_());
                            }
                        } else if (state.m_60734_() instanceof SurvivalBlock) {
                            if (BlockHealthData.damageBlock(this.targetBlock, this.monster.m_9236_())) {
                                this.monster.m_9236_().m_7471_(this.targetBlock, false);
                                this.targetBlock = null;
                            } else {
                                Level level = this.monster.m_9236_();
                                if (level instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)level;
                                    int currentHealth = BlockHealthData.getHealth(this.targetBlock);
                                    for (ServerPlayer player : serverLevel.m_6907_()) {
                                        player.m_213846_((Component)Component.m_237113_((String)("\u00a7e\u0417\u0434\u043e\u0440\u043e\u0432\u044c\u0435: " + currentHealth + "%")));
                                    }
                                }
                            }
                        }
                        this.attackTime = 0;
                    }
                } else {
                    this.monster.m_21573_().m_26519_((double)this.targetBlock.m_123341_(), (double)this.targetBlock.m_123342_(), (double)this.targetBlock.m_123343_(), 1.0);
                }
            }
        }

        private BlockPos findNearestHealthBoostBlock(Level level, BlockPos pos) {
            BlockPos cached;
            long currentTime = System.currentTimeMillis();
            String cacheKey = pos.m_123341_() + "," + pos.m_123343_();
            if (currentTime - lastHealthBlockCacheUpdate > 5000L) {
                healthBlockCache.clear();
                lastHealthBlockCacheUpdate = currentTime;
            }
            if ((cached = healthBlockCache.get(cacheKey)) != null && level.m_8055_(cached).m_60734_() instanceof HealthBoostBlock) {
                return cached;
            }
            BlockPos nearest = null;
            double nearestDistance = Double.MAX_VALUE;
            for (int x = -50; x <= 50; x += 10) {
                for (int y = -10; y <= 10; y += 5) {
                    for (int z = -50; z <= 50; z += 10) {
                        double distance;
                        BlockPos checkPos = pos.m_7918_(x, y, z);
                        if (!(level.m_8055_(checkPos).m_60734_() instanceof HealthBoostBlock) || !((distance = pos.m_123331_((Vec3i)checkPos)) < nearestDistance)) continue;
                        nearest = checkPos;
                        nearestDistance = distance;
                    }
                }
            }
            if (nearest != null) {
                healthBlockCache.put(cacheKey, nearest);
            }
            return nearest;
        }

        private BlockPos findMainSurvivalBlock(Level level, BlockPos pos) {
            ServerLevel serverLevel;
            SurvivalManager manager;
            if (level instanceof ServerLevel && (manager = SurvivalManager.get((Level)(serverLevel = (ServerLevel)level))) != null) {
                for (ProtectionZone zone : manager.getProtectionZones()) {
                    BlockPos center = zone.getCenterBlock();
                    double distance = pos.m_123331_((Vec3i)center);
                    if (!(distance <= (double)(this.searchRadius * this.searchRadius))) continue;
                    return center;
                }
            }
            return null;
        }
    }

    private static class ParticleRequest {
        final ServerLevel level;
        final double x;
        final double y;
        final double z;
        final long timestamp;

        ParticleRequest(ServerLevel level, double x, double y, double z) {
            this.level = level;
            this.x = x;
            this.y = y;
            this.z = z;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

