/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ActiveWave;
import com.example.examplemod.DebugManager;
import com.example.examplemod.PersistentProtectionZoneManager;
import com.example.examplemod.ProtectionZone;
import com.example.examplemod.ScreenNotificationManager;
import com.example.examplemod.SurvivalBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;

public class SurvivalManager
extends SavedData {
    private static final String DATA_NAME = "survival_manager";
    private static final int SURVIVAL_DAYS = 100;
    private static final long TICKS_PER_DAY = 24000L;
    public List<BlockPos> survivalBlocks = new ArrayList<BlockPos>();
    private List<ProtectionZone> protectionZones = new ArrayList<ProtectionZone>();
    private List<String> permanentlyDeadPlayers = new ArrayList<String>();
    private List<ActiveWave> activeWaves = new ArrayList<ActiveWave>();
    private boolean isApocalypseMode = false;
    private long worldStartTime = 0L;
    private boolean gameStarted = false;
    private List<String> spawnedWaves = new ArrayList<String>();
    private long timeBeforeFreeze = 0L;
    private boolean finalDayMessageShown = false;
    private boolean finalNightCompleted = false;
    private boolean nightEverStarted = false;

    public static SurvivalManager get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (SurvivalManager)serverLevel.m_8895_().m_164861_(SurvivalManager::load, SurvivalManager::new, DATA_NAME);
        }
        return null;
    }

    public static SurvivalManager load(CompoundTag tag) {
        SurvivalManager manager = new SurvivalManager();
        manager.worldStartTime = tag.m_128454_("worldStartTime");
        manager.gameStarted = tag.m_128471_("gameStarted");
        ListTag blocksTag = tag.m_128437_("survivalBlocks", 10);
        for (int i = 0; i < blocksTag.size(); ++i) {
            manager.survivalBlocks.add(NbtUtils.m_129239_((CompoundTag)blocksTag.m_128728_(i)));
        }
        ListTag deadPlayersTag = tag.m_128437_("permanentlyDeadPlayers", 8);
        for (int i = 0; i < deadPlayersTag.size(); ++i) {
            manager.permanentlyDeadPlayers.add(deadPlayersTag.m_128778_(i));
        }
        manager.isApocalypseMode = tag.m_128471_("isApocalypseMode");
        manager.timeBeforeFreeze = tag.m_128454_("timeBeforeFreeze");
        ListTag spawnedWavesTag = tag.m_128437_("spawnedWaves", 8);
        for (int i = 0; i < spawnedWavesTag.size(); ++i) {
            manager.spawnedWaves.add(spawnedWavesTag.m_128778_(i));
        }
        manager.finalDayMessageShown = tag.m_128471_("finalDayMessageShown");
        manager.finalNightCompleted = tag.m_128471_("finalNightCompleted");
        manager.nightEverStarted = tag.m_128471_("nightEverStarted");
        return manager;
    }

    public void restoreProtectionZones(Level level) {
        this.protectionZones.clear();
        for (BlockPos pos : this.survivalBlocks) {
            ServerLevel serverLevel;
            PersistentProtectionZoneManager persistentManager;
            if (!(level.m_8055_(pos).m_60734_() instanceof SurvivalBlock)) continue;
            ProtectionZone zone = new ProtectionZone(pos);
            zone.createZone(level);
            this.protectionZones.add(zone);
            if (!(level instanceof ServerLevel) || (persistentManager = PersistentProtectionZoneManager.get(serverLevel = (ServerLevel)level)).getProtectionZone(pos) != null) continue;
            persistentManager.addProtectionZone(zone);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ProtectionZone zone : this.protectionZones) {
                zone.spawnParticles(level);
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128356_("worldStartTime", this.worldStartTime);
        tag.m_128379_("gameStarted", this.gameStarted);
        ListTag blocksTag = new ListTag();
        for (BlockPos blockPos : this.survivalBlocks) {
            blocksTag.add((Object)NbtUtils.m_129224_((BlockPos)blockPos));
        }
        tag.m_128365_("survivalBlocks", (Tag)blocksTag);
        ListTag deadPlayersTag = new ListTag();
        for (String playerUUID : this.permanentlyDeadPlayers) {
            deadPlayersTag.add((Object)StringTag.m_129297_((String)playerUUID));
        }
        tag.m_128365_("permanentlyDeadPlayers", (Tag)deadPlayersTag);
        tag.m_128379_("isApocalypseMode", this.isApocalypseMode);
        tag.m_128356_("timeBeforeFreeze", this.timeBeforeFreeze);
        ListTag listTag = new ListTag();
        for (String waveKey : this.spawnedWaves) {
            listTag.add((Object)StringTag.m_129297_((String)waveKey));
        }
        tag.m_128365_("spawnedWaves", (Tag)listTag);
        tag.m_128379_("finalDayMessageShown", this.finalDayMessageShown);
        tag.m_128379_("finalNightCompleted", this.finalNightCompleted);
        tag.m_128379_("nightEverStarted", this.nightEverStarted);
        return tag;
    }

    public void startGame(Level level) {
        if (!this.gameStarted && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.gameStarted = true;
            this.worldStartTime = serverLevel.m_46468_();
            ScreenNotificationManager.showNotification(serverLevel, "\u00a7e\u00a7l\ud83c\udfae \u0418\u0413\u0420\u0410 \u041d\u0410\u0427\u0410\u041b\u0410\u0421\u042c! \ud83c\udfae", "\u00a7a\u0412\u044b\u0436\u0438\u0432\u0438\u0442\u0435 100 \u0434\u043d\u0435\u0439 \u0438 \u0437\u0430\u0449\u0438\u0442\u0438\u0442\u0435 \u0431\u043b\u043e\u043a!");
            this.m_77762_();
        }
    }

    public void addSurvivalBlock(BlockPos pos, Level level) {
        if (!this.survivalBlocks.contains(pos)) {
            this.survivalBlocks.add(pos);
            ProtectionZone zone = new ProtectionZone(pos);
            zone.createZone(level);
            this.protectionZones.add(zone);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PersistentProtectionZoneManager persistentManager = PersistentProtectionZoneManager.get(serverLevel);
                persistentManager.addProtectionZone(zone);
                zone.spawnParticles(level);
                DebugManager.sendDebugMessageToAll(serverLevel, "\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u0437\u0430\u0449\u0438\u0442\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0432 " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_());
            }
            this.m_77762_();
        }
    }

    public void cleanupInvalidBlocks(Level level) {
        this.survivalBlocks.removeIf(pos -> {
            if (!(level.m_8055_(pos).m_60734_() instanceof SurvivalBlock)) {
                this.protectionZones.removeIf(zone -> {
                    if (zone.getCenterBlock().equals(pos)) {
                        zone.removeZone(level);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            PersistentProtectionZoneManager persistentManager = PersistentProtectionZoneManager.get(serverLevel);
                            persistentManager.removeProtectionZone((BlockPos)pos);
                            DebugManager.sendDebugMessageToAll(serverLevel, "\u0417\u0430\u0449\u0438\u0442\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0432 " + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_());
                        }
                        return true;
                    }
                    return false;
                });
                return true;
            }
            return false;
        });
        if (!this.survivalBlocks.isEmpty()) {
            this.m_77762_();
        }
    }

    public void removeSurvivalBlock(BlockPos pos, Level level) {
        this.survivalBlocks.remove(pos);
        this.protectionZones.removeIf(zone -> {
            if (zone.getCenterBlock().equals((Object)pos)) {
                zone.removeZone(level);
                return true;
            }
            return false;
        });
        this.m_77762_();
    }

    public void tick(Level level) {
        long currentTime;
        long elapsedTime;
        long daysElapsed;
        if (!this.gameStarted || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        this.activeWaves.removeIf(wave -> {
            if (wave.isCompleted()) {
                wave.cleanup();
                return true;
            }
            wave.tick(serverLevel);
            return false;
        });
        if (this.hasActiveBigWaves() && !this.isTimeFrozen()) {
            this.freezeTime(serverLevel);
            ScreenNotificationManager.showNotification(serverLevel, "\u00a75\u23f0 \u0412\u0420\u0415\u041c\u042f \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d\u041e! \u23f0", "\u00a7eB\u043e\u043b\u044c\u0448\u0430\u044f \u0432\u043e\u043b\u043d\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043f\u043e\u0431\u0435\u0436\u0434\u0435\u043d\u0430!");
        } else if (!this.hasActiveBigWaves() && this.isTimeFrozen() && !this.isApocalypseMode) {
            this.unfreezeTime(serverLevel);
            ScreenNotificationManager.showNotification(serverLevel, "\u00a7a\u23f0 \u0412\u0420\u0415\u041c\u042f \u0420\u0410\u0417\u041c\u041e\u0420\u041e\u0416\u0415\u041d\u041e! \u23f0", "\u00a7e\u0412\u0440\u0435\u043c\u044f \u0441\u043d\u043e\u0432\u0430 \u0442\u0435\u0447\u0435\u0442 \u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e!");
        }
        this.updateTime(serverLevel);
        if (serverLevel.m_46467_() % 6000L == 0L) {
            this.cleanupOldWaveRecords();
        }
        if (this.isApocalypseMode) {
            long nightTime = 18000L;
            serverLevel.m_8615_(nightTime);
        }
        if ((daysElapsed = (elapsedTime = (currentTime = serverLevel.m_46468_()) - this.worldStartTime) / 24000L) >= 100L && !this.survivalBlocks.isEmpty()) {
            long timeInDay;
            if (!this.finalDayMessageShown) {
                this.showFinalDayMessage(serverLevel);
                this.finalDayMessageShown = true;
                this.m_77762_();
            }
            if (!this.finalNightCompleted && this.activeWaves.isEmpty() && this.isNightTime(serverLevel) && (timeInDay = currentTime % 24000L) > 12000L) {
                this.completeFinalNight(serverLevel);
            }
        }
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public long getDaysElapsed(Level level) {
        if (!this.gameStarted || !(level instanceof ServerLevel)) {
            return 0L;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        long currentTime = serverLevel.m_46468_();
        long elapsedTime = currentTime - this.worldStartTime;
        return elapsedTime / 24000L;
    }

    public boolean isInProtectedZone(BlockPos pos) {
        return this.protectionZones.stream().anyMatch(zone -> zone.isInProtectedZone(pos));
    }

    public boolean canMobSpawn(BlockPos pos, boolean isHostile) {
        return this.protectionZones.stream().allMatch(zone -> zone.canMobSpawn(pos, isHostile));
    }

    public List<ProtectionZone> getProtectionZones() {
        return this.protectionZones;
    }

    public void spawnZoneParticles(Level level) {
        boolean hasActiveWaves = !this.activeWaves.isEmpty();
        for (ProtectionZone zone : this.protectionZones) {
            if (hasActiveWaves) {
                zone.spawnIntenseParticles(level);
                continue;
            }
            zone.spawnParticles(level);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PersistentProtectionZoneManager persistentManager = PersistentProtectionZoneManager.get(serverLevel);
            for (ProtectionZone zone : persistentManager.getProtectionZones()) {
                if (hasActiveWaves) {
                    zone.spawnIntenseParticles(level);
                    continue;
                }
                zone.spawnParticles(level);
            }
        }
    }

    public void addPermanentlyDeadPlayer(String playerUUID) {
        if (!this.permanentlyDeadPlayers.contains(playerUUID)) {
            this.permanentlyDeadPlayers.add(playerUUID);
            this.m_77762_();
        }
    }

    public boolean isPermanentlyDead(String playerUUID) {
        return this.permanentlyDeadPlayers.contains(playerUUID);
    }

    public void clearPermanentlyDeadPlayers() {
        this.permanentlyDeadPlayers.clear();
        this.m_77762_();
    }

    public boolean removePermanentlyDeadPlayer(String playerUUID) {
        boolean removed = this.permanentlyDeadPlayers.remove(playerUUID);
        if (removed) {
            this.m_77762_();
        }
        return removed;
    }

    public int getPermanentlyDeadPlayersCount() {
        return this.permanentlyDeadPlayers.size();
    }

    public List<String> getPermanentlyDeadPlayers() {
        return new ArrayList<String>(this.permanentlyDeadPlayers);
    }

    public void addActiveWave(ActiveWave wave) {
        this.activeWaves.add(wave);
        if (!this.survivalBlocks.isEmpty()) {
            BlockPos centerPos = this.survivalBlocks.get(0);
            Object var3_3 = null;
        }
        this.m_77762_();
    }

    public void removeActiveWave(ActiveWave wave) {
        this.activeWaves.remove(wave);
        wave.cleanup();
        this.m_77762_();
    }

    public List<ActiveWave> getActiveWaves() {
        return new ArrayList<ActiveWave>(this.activeWaves);
    }

    public boolean hasActiveBigWaves() {
        return this.activeWaves.stream().anyMatch(wave -> wave.isBigWave() && !wave.isCompleted());
    }

    public void freezeTime(ServerLevel level) {
        if (this.timeBeforeFreeze == 0L) {
            this.timeBeforeFreeze = level.m_46468_();
            this.m_77762_();
        }
    }

    public void unfreezeTime(ServerLevel level) {
        if (this.timeBeforeFreeze > 0L) {
            this.timeBeforeFreeze = 0L;
            this.m_77762_();
        }
    }

    public boolean isTimeFrozen() {
        return this.timeBeforeFreeze > 0L;
    }

    public void updateTime(ServerLevel level) {
        if (this.isTimeFrozen()) {
            level.m_8615_(this.timeBeforeFreeze);
        }
    }

    public void enableApocalypseMode() {
        this.isApocalypseMode = true;
        this.m_77762_();
    }

    public boolean isApocalypseMode() {
        return this.isApocalypseMode;
    }

    public static boolean isBigWaveDay(int day) {
        return day == 10 || day == 20 || day == 30 || day == 40 || day == 50 || day == 60 || day == 70 || day == 80 || day == 90 || day == 100;
    }

    public boolean hasWaveSpawnedToday(String nightKey) {
        return this.spawnedWaves.contains(nightKey);
    }

    public void markWaveSpawnedToday(String nightKey) {
        if (!this.spawnedWaves.contains(nightKey)) {
            this.spawnedWaves.add(nightKey);
            this.m_77762_();
        }
    }

    public void cleanupOldWaveRecords() {
        if (this.spawnedWaves.size() > 20) {
            this.spawnedWaves.subList(0, this.spawnedWaves.size() - 20).clear();
            this.m_77762_();
        }
    }

    private void showFinalDayMessage(ServerLevel level) {
        ScreenNotificationManager.showNotification(level, "\u00a76\u00a7l\ud83c\udfc6 \u0424\u0418\u041d\u0410\u041b\u042c\u041d\u042b\u0419 \u0414\u0415\u041d\u042c! \ud83c\udfc6", "\u00a7e\u0412\u0430\u043c \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0436\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044e\u044e, 100-\u044e \u043d\u043e\u0447\u044c!");
        for (ServerPlayer player : level.m_6907_()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l================================="));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a76\u00a7l         \u0424\u0418\u041d\u0410\u041b\u042c\u041d\u042b\u0419 \u0414\u0415\u041d\u042c!"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e  \u0412\u044b \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u0438 100-\u0433\u043e \u0434\u043d\u044f \u0432\u044b\u0436\u0438\u0432\u0430\u043d\u0438\u044f!"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e  \u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u043f\u0435\u0440\u0435\u0436\u0438\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044e\u044e \u043d\u043e\u0447\u044c..."));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c  \u042d\u0442\u043e \u0431\u0443\u0434\u0435\u0442 \u0441\u0430\u043c\u043e\u0435 \u0442\u044f\u0436\u0435\u043b\u043e\u0435 \u0438\u0441\u043f\u044b\u0442\u0430\u043d\u0438\u0435!"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l================================="));
        }
    }

    private void completeFinalNight(ServerLevel level) {
        this.finalNightCompleted = true;
        ScreenNotificationManager.showNotification(level, "\u00a7a\u00a7l\ud83c\udf89 \u041f\u041e\u0411\u0415\u0414\u0410! \ud83c\udf89", "\u00a7a\u0412\u044b \u043f\u0435\u0440\u0435\u0436\u0438\u043b\u0438 \u0442\u044f\u0436\u0435\u043b\u043e\u0435 \u0441\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0438 100 \u043d\u043e\u0447\u0435\u0439!");
        for (ServerPlayer player : level.m_6907_()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l================================="));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a\u00a7l           \u041f\u041e\u0411\u0415\u0414\u0410!"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a  \u0412\u044b \u043f\u0435\u0440\u0435\u0436\u0438\u043b\u0438 \u0432\u0441\u0435 100 \u043d\u043e\u0447\u0435\u0439!"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a  \u0422\u044f\u0436\u0435\u043b\u043e\u0435 \u0441\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e!"));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7e  \u041d\u043e \u0431\u043b\u043e\u043a\u0438 \u043d\u0430\u0447\u0438\u043d\u0430\u044e\u0442 \u0432\u0437\u0440\u044b\u0432\u0430\u0442\u044c\u0441\u044f..."));
            player.m_213846_((Component)Component.m_237113_((String)"\u00a78\u00a7l================================="));
        }
        new Thread(() -> {
            try {
                Thread.sleep(5000L);
                for (BlockPos pos : new ArrayList<BlockPos>(this.survivalBlocks)) {
                    BlockState state = level.m_8055_(pos);
                    if (!(state.m_60734_() instanceof SurvivalBlock)) continue;
                    ((SurvivalBlock)state.m_60734_()).explodeAfter100Days((Level)level, pos);
                    level.m_7471_(pos, false);
                }
                this.survivalBlocks.clear();
                for (ServerPlayer player : level.m_6907_()) {
                    player.m_143403_(GameType.SPECTATOR);
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u0412\u044b \u043f\u0435\u0440\u0435\u0432\u0435\u0434\u0435\u043d\u044b \u0432 \u0440\u0435\u0436\u0438\u043c \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044f"));
                }
                this.enableApocalypseMode();
                ScreenNotificationManager.showNotification(level, "\u00a74\u00a7l\ud83d\udc80 \u0420\u0415\u0416\u0418\u041c \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421\u0410! \ud83d\udc80", "\u00a7c\u0412\u0441\u0435 \u0431\u043b\u043e\u043a\u0438 \u0443\u043d\u0438\u0447\u0442\u043e\u0436\u0435\u043d\u044b! \u041d\u0430\u0441\u0442\u0443\u043f\u0438\u043b\u0430 \u0432\u0435\u0447\u043d\u0430\u044f \u043d\u043e\u0447\u044c!");
                this.m_77762_();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private boolean isNightTime(ServerLevel level) {
        long timeOfDay = level.m_46468_() % 24000L;
        return timeOfDay >= 12000L && timeOfDay < 24000L;
    }

    public boolean isFinalDayMessageShown() {
        return this.finalDayMessageShown;
    }

    public boolean isFinalNightCompleted() {
        return this.finalNightCompleted;
    }

    public boolean hasNightEverStarted() {
        return this.nightEverStarted;
    }

    public void markNightStarted() {
        if (!this.nightEverStarted) {
            this.nightEverStarted = true;
            this.m_77762_();
        }
    }
}

