/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.GenomControllerBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncMachineDataPacket {
    private final BlockPos pos;
    private final boolean isWorking;
    private final int progress;
    private final int maxProgress;

    public SyncMachineDataPacket(BlockPos pos, boolean isWorking, int progress, int maxProgress) {
        this.pos = pos;
        this.isWorking = isWorking;
        this.progress = progress;
        this.maxProgress = maxProgress;
    }

    public static void encode(SyncMachineDataPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.pos);
        buffer.writeBoolean(packet.isWorking);
        buffer.writeInt(packet.progress);
        buffer.writeInt(packet.maxProgress);
    }

    public static SyncMachineDataPacket decode(FriendlyByteBuf buffer) {
        return new SyncMachineDataPacket(buffer.m_130135_(), buffer.readBoolean(), buffer.readInt(), buffer.readInt());
    }

    public static void handle(SyncMachineDataPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity;
            if (Minecraft.m_91087_().f_91073_ != null && (blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(packet.pos)) instanceof GenomControllerBlockEntity) {
                GenomControllerBlockEntity genomController = (GenomControllerBlockEntity)blockEntity;
                genomController.setClientData(packet.isWorking, packet.progress, packet.maxProgress);
            }
        });
        context.setPacketHandled(true);
    }
}

