/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.PersistentProtectionZoneManager;
import com.example.examplemod.ProtectionZone;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TestParticlesCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"testparticles").requires(source -> source.m_6761_(2))).executes(TestParticlesCommand::executeTestParticles));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"testzone").requires(source -> source.m_6761_(2))).executes(TestParticlesCommand::executeTestZone));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"testintense").requires(source -> source.m_6761_(2))).executes(TestParticlesCommand::executeIntenseParticles));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"listzones").requires(source -> source.m_6761_(2))).executes(TestParticlesCommand::executeListZones));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"expandzone").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(TestParticlesCommand::executeExpandZone)));
    }

    private static int executeTestParticles(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel level = player.m_284548_();
            BlockPos playerPos = player.m_20183_();
            ProtectionZone zone = new ProtectionZone(playerPos, 10);
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(level);
            manager.addProtectionZone(zone);
            zone.spawnParticles((Level)level);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[Citadel Guard] \u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430\u044f \u0437\u0430\u0449\u0438\u0442\u043d\u0430\u044f \u0437\u043e\u043d\u0430 21x21 (10 \u0431\u043b\u043e\u043a\u043e\u0432 \u043e\u0442 \u0446\u0435\u043d\u0442\u0440\u0430) \u0441 \u043a\u0440\u0430\u0441\u043d\u044b\u043c\u0438 \u0447\u0430\u0441\u0442\u0438\u0446\u0430\u043c\u0438!"), false);
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77\u0417\u043e\u043d\u0430 \u0431\u0443\u0434\u0435\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0445\u043e\u0434\u0435 \u0432 \u043c\u0438\u0440"), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u043e\u043c!"));
        return 0;
    }

    private static int executeTestZone(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel level = player.m_284548_();
            BlockPos playerPos = player.m_20183_();
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(level);
            ProtectionZone nearestZone = null;
            double nearestDistance = Double.MAX_VALUE;
            for (ProtectionZone zone : manager.getProtectionZones()) {
                double distance = playerPos.m_123331_((Vec3i)zone.getCenterBlock());
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestZone = zone;
            }
            if (nearestZone != null && nearestDistance <= 100.0) {
                manager.removeProtectionZone(nearestZone.getCenterBlock());
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7c[Citadel Guard] \u0417\u0430\u0449\u0438\u0442\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430!"), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[Citadel Guard] \u0417\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0437\u043e\u043d \u043f\u043e\u0431\u043b\u0438\u0437\u043e\u0441\u0442\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e"), false);
            }
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u043e\u043c!"));
        return 0;
    }

    private static int executeIntenseParticles(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel level = player.m_284548_();
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(level);
            List<ProtectionZone> zones = manager.getProtectionZones();
            if (zones.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[Citadel Guard] \u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0437\u043e\u043d"), false);
                return 0;
            }
            for (ProtectionZone zone : zones) {
                zone.spawnIntenseRedstoneParticles((Level)level);
            }
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7c[Citadel Guard] \u041f\u043e\u043a\u0430\u0437\u0430\u043d\u044b \u0438\u043d\u0442\u0435\u043d\u0441\u0438\u0432\u043d\u044b\u0435 \u0447\u0430\u0441\u0442\u0438\u0446\u044b \u0434\u043b\u044f " + zones.size() + " \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0437\u043e\u043d!")), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u043e\u043c!"));
        return 0;
    }

    private static int executeListZones(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel level = player.m_284548_();
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(level);
            List<ProtectionZone> zones = manager.getProtectionZones();
            if (zones.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[Citadel Guard] \u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0437\u043e\u043d"), false);
                return 0;
            }
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7a[Citadel Guard] \u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0437\u0430\u0449\u0438\u0442\u043d\u044b\u0435 \u0437\u043e\u043d\u044b:"), false);
            for (int i = 0; i < zones.size(); ++i) {
                ProtectionZone zone = zones.get(i);
                BlockPos center = zone.getCenterBlock();
                int radius = zone.getRadius();
                int index = i + 1;
                BlockPos finalCenter = center;
                int finalRadius = radius;
                source.m_288197_(() -> Component.m_237113_((String)String.format("\u00a77%d. \u0426\u0435\u043d\u0442\u0440: %d, %d, %d | \u0420\u0430\u0434\u0438\u0443\u0441: %d \u0431\u043b\u043e\u043a\u043e\u0432", index, finalCenter.m_123341_(), finalCenter.m_123342_(), finalCenter.m_123343_(), finalRadius)), false);
            }
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u043e\u043c!"));
        return 0;
    }

    private static int executeExpandZone(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ServerLevel level = player.m_284548_();
            BlockPos playerPos = player.m_20183_();
            int newRadius = IntegerArgumentType.getInteger(context, (String)"radius");
            PersistentProtectionZoneManager manager = PersistentProtectionZoneManager.get(level);
            ProtectionZone nearestZone = null;
            double nearestDistance = Double.MAX_VALUE;
            for (ProtectionZone zone : manager.getProtectionZones()) {
                double distance = playerPos.m_123331_((Vec3i)zone.getCenterBlock());
                if (!(distance < nearestDistance)) continue;
                nearestDistance = distance;
                nearestZone = zone;
            }
            if (nearestZone != null && nearestDistance <= 400.0) {
                int oldRadius = nearestZone.getRadius();
                nearestZone.setRadius(newRadius);
                manager.m_77762_();
                nearestZone.spawnParticles((Level)level);
                int finalOldRadius = oldRadius;
                int finalNewRadius = newRadius;
                BlockPos finalCenter = nearestZone.getCenterBlock();
                source.m_288197_(() -> Component.m_237113_((String)String.format("\u00a7a[Citadel Guard] \u0417\u043e\u043d\u0430 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0430 \u0441 %d \u0434\u043e %d \u0431\u043b\u043e\u043a\u043e\u0432 \u043e\u0442 \u0446\u0435\u043d\u0442\u0440\u0430 (%d, %d, %d)", finalOldRadius, finalNewRadius, finalCenter.m_123341_(), finalCenter.m_123342_(), finalCenter.m_123343_())), false);
                source.m_288197_(() -> Component.m_237113_((String)"\u00a77\u0427\u0430\u0441\u0442\u0438\u0446\u044b \u0442\u0435\u043f\u0435\u0440\u044c \u043d\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u0435 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b"), false);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)"\u00a7e[Citadel Guard] \u0417\u0430\u0449\u0438\u0442\u043d\u044b\u0445 \u0437\u043e\u043d \u043f\u043e\u0431\u043b\u0438\u0437\u043e\u0441\u0442\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e"), false);
            }
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u043e\u043c!"));
        return 0;
    }
}

