/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.DebugManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;

public class WaveBossBar {
    private final CustomBossEvent bossEvent;
    private final ServerLevel level;

    public WaveBossBar(String name, int day, ServerLevel level) {
        this.level = level;
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"citadelguard", (String)("wave_" + day + "_" + System.currentTimeMillis()));
        this.bossEvent = new CustomBossEvent(id, (Component)Component.m_237113_((String)name));
        this.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
        this.bossEvent.m_5648_(BossEvent.BossBarOverlay.PROGRESS);
        this.bossEvent.m_142711_(1.0f);
        this.bossEvent.m_8321_(true);
        this.bossEvent.m_7003_(false);
        this.bossEvent.m_7006_(false);
        try {
            level.m_7654_().m_129901_().m_136299_(id, (Component)Component.m_237113_((String)name));
        }
        catch (Exception e) {
            CustomBossEvent existingBar = level.m_7654_().m_129901_().m_136297_(id);
            if (existingBar != null) {
                // empty if block
            }
        }
        for (ServerPlayer player : level.m_6907_()) {
            this.bossEvent.m_6543_(player);
            DebugManager.sendDebugMessage(player, "CustomBossEvent \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430: " + player.m_7755_().getString());
            DebugManager.sendDebugMessage(player, "Boss bar ID: " + id.toString());
        }
    }

    public void addPlayer(ServerPlayer player) {
        if (this.bossEvent != null) {
            this.bossEvent.m_6543_(player);
        }
    }

    public void removePlayer(ServerPlayer player) {
        if (this.bossEvent != null) {
            this.bossEvent.m_6539_(player);
        }
    }

    public void setProgress(float progress) {
        if (this.bossEvent != null) {
            this.bossEvent.m_142711_(Math.max(0.0f, Math.min(1.0f, progress)));
        }
    }

    public void setName(String name) {
        if (this.bossEvent != null) {
            this.bossEvent.m_6456_((Component)Component.m_237113_((String)name));
        }
    }

    public void setColor(String colorName) {
        if (this.bossEvent != null) {
            BossEvent.BossBarColor color = switch (colorName.toLowerCase()) {
                case "red" -> BossEvent.BossBarColor.RED;
                case "yellow" -> BossEvent.BossBarColor.YELLOW;
                case "green" -> BossEvent.BossBarColor.GREEN;
                case "blue" -> BossEvent.BossBarColor.BLUE;
                case "pink" -> BossEvent.BossBarColor.PINK;
                case "purple" -> BossEvent.BossBarColor.PURPLE;
                case "white" -> BossEvent.BossBarColor.WHITE;
                default -> BossEvent.BossBarColor.RED;
            };
            this.bossEvent.m_6451_(color);
        }
    }

    public void setVisible(boolean visible) {
        if (this.bossEvent != null) {
            this.bossEvent.m_8321_(visible);
        }
    }

    public void removeAllPlayers() {
        if (this.bossEvent != null) {
            this.bossEvent.m_7706_();
        }
    }

    public void cleanup() {
        if (this.bossEvent != null) {
            this.bossEvent.m_7706_();
            if (this.level != null && this.level.m_7654_() != null) {
                this.level.m_7654_().m_129901_().m_136302_(this.bossEvent);
            }
        }
    }

    public CustomBossEvent getBossEvent() {
        return this.bossEvent;
    }
}

