/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class WaveDisplayManager {
    private static final Map<Integer, Long> lastUpdateTime = new HashMap<Integer, Long>();
    private static final int UPDATE_INTERVAL_MS = 1000;

    public static void showWaveProgress(ServerLevel level, int day, int remainingMobs, int totalMobs, boolean isBigWave) {
        MutableComponent subtitle;
        MutableComponent title;
        long currentTime = System.currentTimeMillis();
        Long lastUpdate = lastUpdateTime.get(day);
        if (lastUpdate != null && currentTime - lastUpdate < 1000L) {
            return;
        }
        lastUpdateTime.put(day, currentTime);
        if (isBigWave) {
            title = Component.m_237113_((String)("\u00a74\u00a7l\u26a1 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + " \u26a1"));
            subtitle = Component.m_237113_((String)("\u00a7c" + remainingMobs + " \u00a77\u0438\u0437 \u00a7c" + totalMobs + " \u00a77\u043c\u043e\u0431\u043e\u0432 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c"));
        } else {
            title = Component.m_237113_((String)("\u00a7c\u00a7l\u0412\u041e\u041b\u041d\u0410 " + day));
            subtitle = Component.m_237113_((String)("\u00a7e" + remainingMobs + " \u00a77\u0438\u0437 \u00a7e" + totalMobs + " \u00a77\u043c\u043e\u0431\u043e\u0432 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c"));
        }
        for (ServerPlayer player : level.m_6907_()) {
            WaveDisplayManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 0, 25, 5);
        }
    }

    public static void showWaveStart(ServerLevel level, int day, int totalMobs, boolean isBigWave, boolean isApocalypse) {
        MutableComponent subtitle;
        MutableComponent title;
        if (isApocalypse) {
            title = Component.m_237113_((String)("\u00a74\u00a7l\ud83d\udc80 \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0422\u0418\u0427\u0415\u0421\u041a\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + " \ud83d\udc80"));
            subtitle = Component.m_237113_((String)"\u00a7c\u00a7l\u0411\u0415\u0421\u041a\u041e\u041d\u0415\u0427\u041d\u0410\u042f \u041d\u041e\u0427\u042c \u041d\u0410\u0427\u0410\u041b\u0410\u0421\u042c!");
        } else if (isBigWave) {
            title = Component.m_237113_((String)("\u00a75\u00a7l\u26a1 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + " \u26a1"));
            subtitle = Component.m_237113_((String)("\u00a7c" + totalMobs + " \u00a77\u043c\u043e\u0431\u043e\u0432 \u0430\u0442\u0430\u043a\u0443\u044e\u0442! \u00a7e\u00a7l\u0412\u0420\u0415\u041c\u042f \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d\u041e!"));
        } else {
            title = Component.m_237113_((String)("\u00a7c\u00a7l\u0412\u041e\u041b\u041d\u0410 " + day + " \u041d\u0410\u0427\u0410\u041b\u0410\u0421\u042c"));
            subtitle = Component.m_237113_((String)("\u00a7e" + totalMobs + " \u00a77\u043c\u043e\u0431\u043e\u0432 \u043f\u0440\u0438\u0431\u043b\u0438\u0436\u0430\u0435\u0442\u0441\u044f!"));
        }
        for (ServerPlayer player : level.m_6907_()) {
            WaveDisplayManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 10, 60, 20);
        }
    }

    public static void showWaveComplete(ServerLevel level, int day, int duration, boolean isBigWave) {
        MutableComponent subtitle;
        MutableComponent title;
        if (isBigWave) {
            title = Component.m_237113_((String)"\u00a7a\u00a7l\ud83c\udf89 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 \u041f\u041e\u0411\u0415\u0416\u0414\u0415\u041d\u0410! \ud83c\udf89");
            subtitle = Component.m_237113_((String)("\u00a7e\u0412\u043e\u043b\u043d\u0430 " + day + " \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0437\u0430 \u00a7a" + duration + " \u00a7e\u0441\u0435\u043a\u0443\u043d\u0434! \u00a7a\u0412\u0440\u0435\u043c\u044f \u0442\u0435\u0447\u0435\u0442 \u0441\u043d\u043e\u0432\u0430!"));
        } else {
            title = Component.m_237113_((String)"\u00a7a\u00a7l\u2713 \u0412\u041e\u041b\u041d\u0410 \u0417\u0410\u0412\u0415\u0420\u0428\u0415\u041d\u0410");
            subtitle = Component.m_237113_((String)("\u00a7e\u0412\u043e\u043b\u043d\u0430 " + day + " \u043f\u043e\u0431\u0435\u0436\u0434\u0435\u043d\u0430 \u0437\u0430 \u00a7a" + duration + " \u00a7e\u0441\u0435\u043a\u0443\u043d\u0434!"));
        }
        for (ServerPlayer player : level.m_6907_()) {
            WaveDisplayManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 10, 40, 20);
        }
        lastUpdateTime.remove(day);
    }

    public static void showMilestone(ServerLevel level, String message) {
        MutableComponent title = Component.m_237113_((String)"\u00a76\u00a7l\ud83c\udfc6 \u0412\u0410\u0416\u041d\u0410\u042f \u0412\u0415\u0425\u0410 \ud83c\udfc6");
        MutableComponent subtitle = Component.m_237113_((String)message);
        for (ServerPlayer player : level.m_6907_()) {
            WaveDisplayManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 10, 60, 20);
        }
    }

    public static void clearDisplay(ServerLevel level) {
        for (ServerPlayer player : level.m_6907_()) {
            player.f_8906_.m_9829_((Packet)new ClientboundClearTitlesPacket(false));
        }
    }

    private static void sendTitleToPlayer(ServerPlayer player, Component title, Component subtitle, int fadeIn, int stay, int fadeOut) {
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut));
        if (title != null) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(title));
        }
        if (subtitle != null) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket(subtitle));
        }
    }

    public static void showProgressBar(ServerLevel level, int day, int remainingMobs, int totalMobs, boolean isBigWave) {
        int i;
        int barLength = 20;
        int filledBars = totalMobs > 0 ? (int)((double)(totalMobs - remainingMobs) / (double)totalMobs * (double)barLength) : 0;
        StringBuilder progressBar = new StringBuilder();
        progressBar.append("\u00a7a");
        for (i = 0; i < filledBars; ++i) {
            progressBar.append("\u2588");
        }
        progressBar.append("\u00a77");
        for (i = filledBars; i < barLength; ++i) {
            progressBar.append("\u2588");
        }
        int percentage = totalMobs > 0 ? (int)((double)(totalMobs - remainingMobs) / (double)totalMobs * 100.0) : 0;
        MutableComponent title = isBigWave ? Component.m_237113_((String)("\u00a74\u00a7l\u26a1 \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + " \u26a1")) : Component.m_237113_((String)("\u00a7c\u00a7l\u0412\u041e\u041b\u041d\u0410 " + day));
        MutableComponent subtitle = Component.m_237113_((String)(progressBar.toString() + " \u00a7f" + percentage + "%"));
        for (ServerPlayer player : level.m_6907_()) {
            WaveDisplayManager.sendTitleToPlayer(player, (Component)title, (Component)subtitle, 0, 25, 5);
        }
    }
}

