/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ActiveWave;
import com.example.examplemod.BloodNightManager;
import com.example.examplemod.DebugManager;
import com.example.examplemod.DifficultyManager;
import com.example.examplemod.NightMobConfig;
import com.example.examplemod.SurvivalConfig;
import com.example.examplemod.SurvivalManager;
import com.example.examplemod.WaveNotificationManager;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class WaveManager {
    private static final Random random = new Random();

    public static void spawnWaveForDay(ServerLevel level, BlockPos blockPos, int day) {
        SurvivalConfig config = SurvivalConfig.getInstance();
        SurvivalManager manager = SurvivalManager.get((Level)level);
        if (manager == null) {
            return;
        }
        manager.markNightStarted();
        boolean isBloodNight = BloodNightManager.isBloodNightDay(day);
        if (isBloodNight) {
            BloodNightManager.startBloodNight(level, day);
        } else {
            for (ServerPlayer player : level.m_6907_()) {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a76[\u0412\u041e\u041b\u041d\u0410] \u0414\u0435\u043d\u044c " + day + " \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f...")));
                if (!SurvivalManager.isBigWaveDay(day)) continue;
                int expectedMobs = WaveManager.getTargetTotalForMilestoneDay(day);
                DebugManager.sendDebugMessage(player, "\u041e\u0436\u0438\u0434\u0430\u0435\u0442\u0441\u044f \u043c\u043e\u0431\u043e\u0432: " + expectedMobs + " (\u0411\u043e\u043b\u044c\u0448\u0430\u044f \u0432\u043e\u043b\u043d\u0430)");
            }
        }
        SurvivalConfig.WaveConfig wave = config.getWaveForDay(day);
        if (wave.mobs.isEmpty() && !manager.isApocalypseMode()) {
            return;
        }
        boolean isBigWave = SurvivalManager.isBigWaveDay(day) || manager.isApocalypseMode() || isBloodNight;
        ActiveWave activeWave = new ActiveWave(day, blockPos, isBigWave, level);
        WaveNotificationManager.announceWaveStart(level, day, isBigWave, manager.isApocalypseMode());
        WaveNotificationManager.sendMilestoneNotification(level, day);
        DifficultyManager.Difficulty difficulty = DifficultyManager.getSelectedDifficulty();
        int targetTotal = NightMobConfig.getMobCountForNight(day, difficulty);
        WaveManager.spawnBalancedWave(level, blockPos, targetTotal, activeWave, day);
        manager.addActiveWave(activeWave);
        activeWave.finalizeWave();
        if (manager.isApocalypseMode()) {
            int maxMobs = WaveManager.getMaxApocalypseMobs();
            WaveManager.spawnBalancedWave(level, blockPos, maxMobs, activeWave, day);
            manager.addActiveWave(activeWave);
            activeWave.finalizeWave();
            return;
        }
    }

    private static void spawnBalancedWave(ServerLevel level, BlockPos blockPos, int targetTotal, ActiveWave activeWave, int day) {
        if (targetTotal <= 0) {
            return;
        }
        String[] mobTypes = WaveManager.getMobTypesForDay(day);
        int[] mobCounts = WaveManager.distributeMobs(targetTotal, mobTypes.length);
        for (int i = 0; i < mobTypes.length && i < mobCounts.length; ++i) {
            if (mobCounts[i] <= 0) continue;
            SurvivalConfig.MobConfig mobConfig = new SurvivalConfig.MobConfig();
            mobConfig.type = mobTypes[i];
            mobConfig.count = mobCounts[i];
            mobConfig.spawn_radius = WaveManager.getSpawnRadiusForDay(day);
            WaveManager.spawnMobs(level, blockPos, mobConfig, activeWave);
        }
        DebugManager.sendDebugMessageToAll(level, String.format("\u0414\u0435\u043d\u044c %d: %d \u043c\u043e\u0431\u043e\u0432 (\u0422\u0438\u043f\u043e\u0432: %d)", day, targetTotal, mobTypes.length));
    }

    private static String[] getMobTypesForDay(int day) {
        if (day <= 10) {
            return new String[]{"zombie", "skeleton"};
        }
        if (day <= 30) {
            return new String[]{"zombie", "skeleton", "spider"};
        }
        if (day <= 50) {
            return new String[]{"zombie", "skeleton", "spider", "creeper"};
        }
        if (day <= 70) {
            return new String[]{"zombie", "skeleton", "spider", "creeper", "witch"};
        }
        return new String[]{"zombie", "skeleton", "spider", "creeper", "witch", "enderman", "husk", "stray"};
    }

    private static int[] distributeMobs(int totalMobs, int mobTypeCount) {
        int i;
        int[] distribution = new int[mobTypeCount];
        int baseCount = totalMobs / mobTypeCount;
        int remainder = totalMobs % mobTypeCount;
        for (i = 0; i < mobTypeCount; ++i) {
            distribution[i] = baseCount;
        }
        for (i = 0; i < remainder; ++i) {
            int n = i % mobTypeCount;
            distribution[n] = distribution[n] + 1;
        }
        return distribution;
    }

    private static int getSpawnRadiusForDay(int day) {
        if (day <= 20) {
            return 25;
        }
        if (day <= 50) {
            return 35;
        }
        return 45;
    }

    private static void spawnMobs(ServerLevel level, BlockPos blockPos, SurvivalConfig.MobConfig mobConfig, ActiveWave activeWave) {
        int actuallySpawned = 0;
        int mobCount = mobConfig.count * BloodNightManager.getBloodNightMobMultiplier();
        for (int i = 0; i < mobCount; ++i) {
            Mob mob;
            BlockPos spawnPos = WaveManager.findSpawnPosition(level, blockPos, mobConfig.spawn_radius);
            if (spawnPos == null || (mob = WaveManager.createMob(level, mobConfig.type)) == null) continue;
            mob.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            level.m_7967_((Entity)mob);
            activeWave.addMob(mob);
            ++actuallySpawned;
        }
        if (actuallySpawned > 0) {
            String mobName = WaveManager.getMobDisplayName(mobConfig.type);
            DebugManager.sendDebugMessageToAll(level, "+ " + actuallySpawned + " " + mobName + " \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0435\u043d\u043e");
        }
    }

    private static void spawnMobs(ServerLevel level, BlockPos blockPos, SurvivalConfig.MobConfig mobConfig) {
        for (int i = 0; i < mobConfig.count; ++i) {
            Mob mob;
            BlockPos spawnPos = WaveManager.findSpawnPosition(level, blockPos, mobConfig.spawn_radius);
            if (spawnPos == null || (mob = WaveManager.createMob(level, mobConfig.type)) == null) continue;
            mob.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, random.nextFloat() * 360.0f, 0.0f);
            level.m_7967_((Entity)mob);
        }
    }

    private static BlockPos findSpawnPosition(ServerLevel level, BlockPos center, int radius) {
        for (int attempts = 0; attempts < 50; ++attempts) {
            int z;
            int y;
            int x = center.m_123341_() + random.nextInt(radius * 2) - radius;
            BlockPos pos = new BlockPos(x, y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z = center.m_123343_() + random.nextInt(radius * 2) - radius), z);
            if (!level.m_46859_(pos) || !level.m_46859_(pos.m_7494_())) continue;
            return pos;
        }
        return null;
    }

    private static Mob createMob(ServerLevel level, String mobType) {
        return switch (mobType.toLowerCase()) {
            case "zombie" -> new Zombie(EntityType.f_20501_, (Level)level);
            case "skeleton" -> new Skeleton(EntityType.f_20524_, (Level)level);
            case "spider" -> new Spider(EntityType.f_20479_, (Level)level);
            case "creeper" -> new Creeper(EntityType.f_20558_, (Level)level);
            case "enderman" -> new EnderMan(EntityType.f_20566_, (Level)level);
            case "witch" -> new Witch(EntityType.f_20495_, (Level)level);
            case "zombie_villager" -> new ZombieVillager(EntityType.f_20530_, (Level)level);
            case "husk" -> new Husk(EntityType.f_20458_, (Level)level);
            case "stray" -> new Stray(EntityType.f_20481_, (Level)level);
            case "cave_spider" -> new CaveSpider(EntityType.f_20554_, (Level)level);
            default -> new Zombie(EntityType.f_20501_, (Level)level);
        };
    }

    private static int getTargetTotalForMilestoneDay(int day) {
        DifficultyManager.Difficulty diff = DifficultyManager.getSelectedDifficulty();
        if (diff == null) {
            return 0;
        }
        return NightMobConfig.getMobCountForNight(day, diff);
    }

    private static int getMaxApocalypseMobs() {
        DifficultyManager.Difficulty diff = DifficultyManager.getSelectedDifficulty();
        if (diff == null) {
            return 100;
        }
        int finalNightMobs = NightMobConfig.getFinalNightTarget(diff);
        return (int)Math.round((double)finalNightMobs * 1.5);
    }

    private static int getBaseMobCountForDay(int day) {
        DifficultyManager.Difficulty diff = DifficultyManager.getSelectedDifficulty();
        if (diff == null) {
            return 10;
        }
        return NightMobConfig.getMobCountForNight(day, diff);
    }

    private static String getMobDisplayName(String mobType) {
        return switch (mobType.toLowerCase()) {
            case "zombie" -> "\u00a72\u0417\u043e\u043c\u0431\u0438";
            case "skeleton" -> "\u00a7f \u0421\u043a\u0435\u043b\u0435\u0442";
            case "spider" -> "\u00a78\u041f\u0430\u0443\u043a";
            case "creeper" -> "\u00a7a\u041a\u0440\u0438\u043f\u0435\u0440";
            case "enderman" -> "\u00a75\u042d\u043d\u0434\u0435\u0440\u043c\u0435\u043d";
            case "witch" -> "\u00a7d\u0412\u0435\u0434\u044c\u043c\u0430";
            case "zombie_villager" -> "\u00a72\u0417\u043e\u043c\u0431\u0438-\u0436\u0438\u0442\u0435\u043b\u044c";
            case "husk" -> "\u00a76\u041a\u0430\u0434\u0430\u0432\u0440";
            case "stray" -> "\u00a7b\u0421\u043a\u0438\u0442\u0430\u043b\u0435\u0446";
            case "cave_spider" -> "\u00a78\u041f\u0435\u0449\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0443\u043a";
            default -> "\u00a77" + mobType;
        };
    }
}

