/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.IconNotificationManager;
import com.example.examplemod.ScreenNotificationManager;
import com.example.examplemod.SurvivalManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class WaveNotificationManager {
    private static final Map<Integer, Long> waveWarnings = new HashMap<Integer, Long>();

    public static void scheduleWaveWarning(ServerLevel level, int day, BlockPos blockPos) {
        new Thread(() -> {
            try {
                Thread.sleep(30000L);
                SurvivalManager manager = SurvivalManager.get((Level)level);
                if (manager != null && manager.isGameStarted()) {
                    WaveNotificationManager.sendWaveWarning(level, day);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private static void sendWaveWarning(ServerLevel level, int day) {
        boolean isBigWave = SurvivalManager.isBigWaveDay(day);
        if (isBigWave) {
            ScreenNotificationManager.showNotification(level, "\u00a7c\u00a7l\u26a0 \u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415! \u26a0", "\u00a7e\u0427\u0435\u0440\u0435\u0437 30 \u0441\u0435\u043a\u0443\u043d\u0434 \u043d\u0430\u0447\u043d\u0435\u0442\u0441\u044f \u0411\u041e\u041b\u042c\u0428\u0410\u042f \u0412\u041e\u041b\u041d\u0410 " + day + "!");
        } else {
            ScreenNotificationManager.showNotification(level, "\u00a7e\u26a0 \u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415 \u26a0", "\u00a7e\u0412\u043e\u043b\u043d\u0430 " + day + " \u043d\u0430\u0447\u043d\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 30 \u0441\u0435\u043a\u0443\u043d\u0434");
        }
        for (ServerPlayer player : level.m_6907_()) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_11699_, SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    public static void announceWaveStart(ServerLevel level, int day, boolean isBigWave, boolean isApocalypse) {
        ScreenNotificationManager.showWaveNotification(level, day, isBigWave, isApocalypse);
        for (ServerPlayer player : level.m_6907_()) {
            if (isApocalypse) {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12563_, SoundSource.MASTER, 0.5f, 0.5f);
                continue;
            }
            if (isBigWave) {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11894_, SoundSource.MASTER, 0.3f, 1.0f);
                continue;
            }
            level.m_5594_(null, player.m_20183_(), (SoundEvent)((Holder.Reference)SoundEvents.f_215702_.get(0)).m_203334_(), SoundSource.MASTER, 0.6f, 1.0f);
        }
    }

    public static void announceWaveComplete(ServerLevel level, int day, boolean isBigWave, int duration) {
        if (isBigWave) {
            ScreenNotificationManager.showWaveComplete(level, day, duration, isBigWave);
            for (ServerPlayer player : level.m_6907_()) {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
        IconNotificationManager.showSafe(level);
    }

    public static void sendMilestoneNotification(ServerLevel level, int day) {
        ScreenNotificationManager.showMilestone(level, day);
        for (ServerPlayer player : level.m_6907_()) {
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12496_, SoundSource.MASTER, 1.0f, 1.2f);
        }
    }

    public static void notifyWaveCompleted(ServerLevel level, int day, int seconds, boolean isBigWave) {
        WaveNotificationManager.announceWaveComplete(level, day, isBigWave, seconds);
    }
}

